/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.sqltools.sql.internal.SQLActivator;
import org.eclipse.datatools.sqltools.sql.parser.Messages;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.ISQLParserVisitor;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class SimpleNode
implements Node {
    protected Node _parent;
    protected Node[] _children;
    protected int _id;
    protected SQLParser _parser;
    protected Token _firstToken;
    protected Token _lastToken;

    public SimpleNode(int i) {
        this._id = i;
    }

    public SimpleNode(SQLParser p, int i) {
        this(i);
        this._parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this._parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this._parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this._children == null) {
            this._children = new Node[i + 1];
        } else if (i >= this._children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this._children, 0, c, 0, this._children.length);
            this._children = c;
        }
        this._children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this._children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this._children == null ? 0 : this._children.length;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this._children != null) {
            int i = 0;
            while (i < this._children.length) {
                SimpleNode n = (SimpleNode)this._children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }

    @Override
    public Token getLastToken() {
        return this._lastToken;
    }

    @Override
    public void setLastToken(Token token) {
        this._lastToken = token;
    }

    @Override
    public Token getFirstToken() {
        return this._firstToken;
    }

    @Override
    public void setFirstToken(Token token) {
        this._firstToken = token;
    }

    @Override
    public int getStartOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._firstToken != null) {
            offset = this._firstToken.getStartOffset(document);
        }
        return offset;
    }

    @Override
    public int getEndOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._lastToken != null) {
            offset = this._lastToken.getEndOffset(document);
        }
        return offset;
    }

    @Override
    public int getGreatestEndOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._lastToken != null) {
            try {
                Token next = this._lastToken.next;
                if (next == null || next.kind == 0) {
                    return document.getLength() > 0 ? document.getLength() : 0;
                }
                offset = document.getLineOffset(next.beginLine - 1) + next.beginColumn - 1;
            }
            catch (BadLocationException e1) {
                SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
            }
        }
        return offset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleNode)) {
            return false;
        }
        try {
            SimpleNode other = (SimpleNode)obj;
            boolean equals = this._id == other._id && this._firstToken.equals(other._firstToken);
            return equals;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setDocument(IDocument document) {
        if (this instanceof IASTStart) {
            ((IASTStart)((Object)this)).doSetDocument(document);
            return;
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            parent.setDocument(document);
        }
    }

    @Override
    public IDocument getDocument() {
        if (this instanceof IASTStart) {
            return ((IASTStart)((Object)this)).doGetDocument();
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            return null;
        }
        return parent.getDocument();
    }

    @Override
    public int getStartOffset() {
        return this.getStartOffset(this.getDocument());
    }

    @Override
    public int getEndOffset() {
        return this.getEndOffset(this.getDocument());
    }

    @Override
    public int getGreatestEndOffset() {
        return this.getGreatestEndOffset(this.getDocument());
    }

    @Override
    public String getSQLText() {
        IDocument doc = this.getDocument();
        Assert.isNotNull((Object)doc);
        int start = this.getStartOffset(doc);
        int end = this.getEndOffset(doc);
        int length = end - start;
        length = length > 0 ? length : 0;
        try {
            return doc.get(start, length);
        }
        catch (BadLocationException e) {
            SQLActivator.getDefault().log(Messages.SimpleNode_2, e);
            return "";
        }
    }

    @Override
    public int getNextTokenOffset() {
        return this.getNextTokenOffset(this.getDocument());
    }

    @Override
    public int getNextTokenOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        Token nextToken = this._lastToken.next;
        if (this._lastToken != null && (nextToken.image.equals(",") || nextToken.image.equals(";"))) {
            try {
                offset = document.getLineOffset(nextToken.endLine - 1) + nextToken.endColumn;
            }
            catch (BadLocationException e1) {
                SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
            }
        }
        return offset;
    }

    @Override
    public Node getPreviousNode() {
        this.getStartOffset();
        Node previousNode = ParsingResult.findNode(this.getDocument(), this.getStartOffset(), this.getRootNode(), true);
        return previousNode;
    }

    private Node getRootNode() {
        Node rootNode = this;
        while (rootNode.jjtGetParent() != null) {
            rootNode = rootNode.jjtGetParent();
        }
        return rootNode;
    }

    public String getText() {
        SimpleNode node = this;
        StringBuffer text = new StringBuffer("");
        if (node != null) {
            Token token = node.getFirstToken();
            text.append(token.image);
            while (token.next != null && token != node.getLastToken()) {
                if (token.image.equals(".") || token.next.image.equals(".")) {
                    token = token.next;
                } else {
                    token = token.next;
                    text.append(" ");
                }
                text.append(token.image);
            }
        }
        return text.toString();
    }

    @Override
    public Object jjtAccept(ISQLParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object acceptChildren(ISQLParserVisitor visitor, Object data) {
        if (this._children != null) {
            int i = 0;
            while (i < this._children.length) {
                this._children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    @Override
    public boolean exists() {
        return this._firstToken != null && this._lastToken != null && this._lastToken.next != this._firstToken;
    }
}

