/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileBaseDeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public class ConnectionProfileCopyChange
extends Change {
    private IConnectionProfile mProfileToDuplicate;
    private IConnectionProfile mNewProfile;
    private CopyArguments mArguments;

    public ConnectionProfileCopyChange(IConnectionProfile profile, CopyArguments arguments) {
        this.mProfileToDuplicate = profile;
        this.mArguments = arguments;
    }

    public String getName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.name"), this.mProfileToDuplicate.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.mProfileToDuplicate == null) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.ProfileDoesNotExist"));
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.copyProfile(pm));
        return undo;
    }

    public Object getModifiedElement() {
        return this.mProfileToDuplicate;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.mArguments.getDestination()};
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ReorgExecutionLog.class)) {
            return this.mArguments.getExecutionLog();
        }
        return super.getAdapter(adapter);
    }

    private Change copyProfile(IProgressMonitor pm) throws CoreException {
        try {
            Object destination = this.mArguments.getDestination();
            IConnectionProfile repo = destination instanceof IConnectionProfile ? (IConnectionProfile)destination : null;
            this.mNewProfile = InternalProfileManager.getInstance().copyProfile(this.mProfileToDuplicate, repo, this.mArguments.getExecutionLog().getNewName((Object)this.mProfileToDuplicate));
            return new ConnectionProfileBaseDeleteChange(this.mNewProfile, new DeleteArguments());
        }
        catch (ConnectionProfileException e) {
            Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

