/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;

public class StringConfigureOption
extends AbstractConfigurationOption {
    private String value;

    public StringConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = "";
    }

    public StringConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
        this.value = "";
    }

    private StringConfigureOption(String name, AutotoolsConfiguration cfg, String value) {
        super(name, cfg);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (!newValue.equals(this.value)) {
            this.cfg.setDirty(true);
            this.value = newValue;
        }
    }

    @Override
    public boolean isParmSet() {
        return this.value.length() > 0;
    }

    @Override
    public String getParameter() {
        if (this.isParmSet()) {
            return this.getParameterName() + "=" + this.getValue();
        }
        return "";
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new StringConfigureOption(this.name, config, this.value);
    }

    @Override
    public int getType() {
        return 2;
    }
}

