/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd.CommonDnD;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.MoveCopyCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboard;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.handlers.HandlerUtil;

public class PasteFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FsClipboard cb = UIPlugin.getClipboard();
        if (!cb.isEmpty()) {
            IOperation operation;
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            List<IFSTreeNode> nodes = cb.getFiles();
            if (cb.isCutOp()) {
                IFSTreeNode dest = (IFSTreeNode)selection.getFirstElement();
                operation = dest.operationDropMove(nodes, (IConfirmCallback)new MoveCopyCallback());
            } else if (cb.isCopyOp()) {
                IFSTreeNode hovered = (IFSTreeNode)selection.getFirstElement();
                IFSTreeNode dest = this.getCopyDestination(hovered, nodes);
                boolean cpPerm = UIPlugin.isCopyPermission();
                boolean cpOwn = UIPlugin.isCopyOwnership();
                operation = dest.operationDropCopy(nodes, cpPerm, cpOwn, (IConfirmCallback)new MoveCopyCallback());
            } else {
                return null;
            }
            UiExecutor.execute(operation);
            if (cb.isCutOp()) {
                UIPlugin.getClipboard().clear();
            }
        } else {
            Clipboard clipboard = cb.getSystemClipboard();
            Object contents = clipboard.getContents((Transfer)FileTransfer.getInstance());
            if (contents != null) {
                String[] files = (String[])contents;
                IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                IFSTreeNode hovered = (IFSTreeNode)selection.getFirstElement();
                CommonDnD dnd = new CommonDnD();
                dnd.dropFiles(null, files, 1, hovered);
            }
        }
        return null;
    }

    private IFSTreeNode getCopyDestination(IFSTreeNode hovered, List<IFSTreeNode> nodes) {
        if (hovered.isFile()) {
            return hovered.getParent();
        }
        if (hovered.isDirectory()) {
            for (IFSTreeNode node : nodes) {
                if (node != hovered) continue;
                return hovered.getParent();
            }
        }
        return hovered;
    }
}

