/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.HideFilter;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;

public final class HideFilterHelperImpl
implements HideFilterHelper {
    private HideFilterHelperImpl() {
    }

    public static HideFilterHelperImpl init() {
        return new HideFilterHelperImpl();
    }

    @Override
    public void hide(DDiagramElement element) {
        if (new DDiagramElementQuery(element).isHidden()) {
            return;
        }
        HideFilter filter = DiagramFactory.eINSTANCE.createHideFilter();
        element.getGraphicalFilters().add((Object)filter);
    }

    @Override
    public void reveal(DDiagramElement element) {
        if (!this.isDirectlyHidden(element)) {
            return;
        }
        Object hidefilter = EcoreUtil.getObjectByType((Collection)element.getGraphicalFilters(), (EClassifier)DiagramPackage.eINSTANCE.getHideFilter());
        if (hidefilter instanceof HideFilter) {
            element.getGraphicalFilters().remove(hidefilter);
        }
    }

    private boolean isDirectlyHidden(DDiagramElement element) {
        DDiagramElementQuery query = new DDiagramElementQuery(element);
        return element != null && query.isHidden();
    }

    @Override
    public void hideLabel(DDiagramElement element) {
        HideLabelFilter filter;
        if (new DDiagramElementQuery(element).isLabelHidden()) {
            return;
        }
        if (element.getGraphicalFilters().stream().anyMatch(gf -> gf instanceof HideLabelFilter)) {
            filter = element.getGraphicalFilters().stream().filter(HideLabelFilter.class::isInstance).map(HideLabelFilter.class::cast).findFirst().get();
            element.getGraphicalFilters().remove((Object)filter);
        }
        filter = DiagramFactory.eINSTANCE.createHideLabelFilter();
        element.getGraphicalFilters().add((Object)filter);
    }

    @Override
    public void hideLabel(DDiagramElement element, Map<EObject, List<Integer>> selectedLabelVisualIds) {
        HideLabelFilter filter;
        if (new DDiagramElementQuery(element).areAllLabelsHidden(selectedLabelVisualIds.get(element))) {
            return;
        }
        if (Iterables.any((Iterable)element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(HideLabelFilter.class))) {
            filter = element.getGraphicalFilters().stream().filter(HideLabelFilter.class::isInstance).map(HideLabelFilter.class::cast).findFirst().get();
        } else {
            filter = DiagramFactory.eINSTANCE.createHideLabelFilter();
            element.getGraphicalFilters().add((Object)filter);
        }
        if (element instanceof DEdge && !selectedLabelVisualIds.isEmpty()) {
            filter.getHiddenLabels().addAll((Collection)selectedLabelVisualIds.get(element));
        }
    }

    @Override
    public void revealLabel(DDiagramElement element) {
        if (!new DDiagramElementQuery(element).hasAnyHiddenLabel()) {
            return;
        }
        Object filter = EcoreUtil.getObjectByType((Collection)element.getGraphicalFilters(), (EClassifier)DiagramPackage.eINSTANCE.getHideLabelFilter());
        if (filter instanceof HideLabelFilter) {
            element.getGraphicalFilters().remove(filter);
        }
    }

    @Override
    public void revealLabel(DDiagramElement element, Map<EObject, List<Integer>> selectedLabelVisualIds) {
        if (!new DDiagramElementQuery(element).hasAnyHiddenLabel()) {
            return;
        }
        Object filter = EcoreUtil.getObjectByType((Collection)element.getGraphicalFilters(), (EClassifier)DiagramPackage.eINSTANCE.getHideLabelFilter());
        if (filter instanceof HideLabelFilter) {
            HideLabelFilter hideLabelFilter = (HideLabelFilter)filter;
            hideLabelFilter.getHiddenLabels().removeAll((Collection)selectedLabelVisualIds.get(element));
            if (hideLabelFilter.getHiddenLabels().isEmpty()) {
                element.getGraphicalFilters().remove((Object)hideLabelFilter);
            }
        }
    }
}

