/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.php.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.text.correction.IInvocationContext;
import org.eclipse.php.ui.text.correction.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;

    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection<IScriptCompletionProposal> proposals, int kind, int relevance) throws CoreException {
        Program astRoot = context.getASTRoot();
        if (astRoot == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getType()) {
            case 33: {
                binding = ((Identifier)selectedNode).resolveBinding();
                break;
            }
            case 65: {
                List segments = ((NamespaceName)selectedNode).segments();
                if (segments.size() <= 0) break;
                binding = ((Identifier)segments.get(segments.size() - 1)).resolveBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        if (!(binding instanceof ITypeBinding)) {
            return;
        }
        typeBinding = (ITypeBinding)binding;
        String name = PHPModelUtils.extractElementName((String)binding.getName());
        if (typeBinding != null) {
            String label;
            int excludedModifiers = 0;
            switch (kind) {
                case 5: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            IType type = (IType)typeBinding.getPHPElement();
            ISourceModule targetCU = type.getSourceModule();
            if (targetCU != null) {
                try {
                    Image image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
                    Program root = SharedASTProvider.getAST(targetCU, SharedASTProvider.WAIT_YES, null);
                    if (root != null) {
                        AST ast = root.getAST();
                        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                        ClassDeclaration decl = (ClassDeclaration)root.findDeclaringNode((IBinding)typeBinding);
                        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)ClassDeclaration.MODIFIER_PROPERTY, (Object)(decl.getModifier() & ~excludedModifiers), null);
                        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, targetCU, rewrite, 6, image);
                        proposals.add(proposal);
                    }
                }
                catch (IOException e) {
                    PHPUiPlugin.log(e);
                }
            }
        }
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection<IScriptCompletionProposal> proposals) {
        ISourceModule cu = context.getCompilationUnit();
        Program astRoot = context.getASTRoot();
        if (astRoot == null) {
            return;
        }
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode.getParent() instanceof FunctionDeclaration)) {
            return;
        }
        selectedNode = selectedNode.getParent();
        FunctionDeclaration decl = (FunctionDeclaration)selectedNode;
        MethodDeclaration mdecl = (MethodDeclaration)decl.getParent();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)FunctionDeclaration.BODY_PROPERTY, (Object)body, null);
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_addmissingbody_description;
        Image image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 9, image);
        proposals.add(proposal);
        if (!Flags.isAbstract((int)mdecl.getModifier())) {
            rewrite = ASTRewrite.create((AST)ast);
            rewrite.set((ASTNode)mdecl, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIER_PROPERTY, (Object)(mdecl.getModifier() | 1), null);
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_setmethodabstract_description;
            Image image2 = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
            LinkedCorrectionProposal proposal2 = new LinkedCorrectionProposal(label2, cu, rewrite, 8, image2);
            proposals.add(proposal2);
        }
    }

    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection<IScriptCompletionProposal> proposals) {
        ISourceModule cu = context.getCompilationUnit();
        Program astRoot = context.getASTRoot();
        if (astRoot == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        FunctionDeclaration funcDecl = null;
        while ((selectedNode = selectedNode.getParent()) != null) {
            if (!(selectedNode instanceof FunctionDeclaration)) continue;
            funcDecl = (FunctionDeclaration)selectedNode;
            break;
        }
        if (funcDecl == null) {
            return;
        }
        MethodDeclaration mdecl = (MethodDeclaration)funcDecl.getParent();
        FunctionDeclaration parent = funcDecl;
        ClassDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof ClassDeclaration) {
                parentTypeDecl = (ClassDeclaration)parent;
                if (!Flags.isAbstract((int)parentTypeDecl.getModifier())) break;
                parentIsAbstractClass = true;
                break;
            }
            if (!(parent instanceof AnonymousClassDeclaration)) continue;
            parentIsAbstractClass = false;
            break;
        }
        boolean hasNoBody = funcDecl.getBody() == null;
        IProblemIdentifier id = problem.getProblemIdentifier();
        if (id == PHPProblemIdentifier.AbstractMethodInAbstractClass || parentIsAbstractClass) {
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            rewrite.set((ASTNode)mdecl, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIER_PROPERTY, (Object)(mdecl.getModifier() & 0xFFFFFFFE), null);
            if (hasNoBody) {
                Block body = ast.newBlock();
                rewrite.set((ASTNode)funcDecl, (StructuralPropertyDescriptor)FunctionDeclaration.BODY_PROPERTY, (Object)body, null);
            }
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            Image image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        if (!hasNoBody && id == PHPProblemIdentifier.BodyForAbstractMethod) {
            ASTRewrite rewrite = ASTRewrite.create((AST)funcDecl.getAST());
            rewrite.remove((ASTNode)funcDecl.getBody(), null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal2);
        }
        if (id == PHPProblemIdentifier.AbstractMethodInAbstractClass && parentTypeDecl != null && !(parentTypeDecl instanceof TraitDeclaration)) {
            ModifierCorrectionSubProcessor.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals, cu);
        }
    }

    public static void addAbstractTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<IScriptCompletionProposal> proposals) {
        Program astRoot = context.getASTRoot();
        if (astRoot == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ClassDeclaration parentTypeDecl = null;
        if (selectedNode instanceof Identifier) {
            ASTNode parent = selectedNode.getParent();
            if (parent != null) {
                parentTypeDecl = (ClassDeclaration)parent;
            }
        } else if (selectedNode instanceof ClassDeclaration) {
            parentTypeDecl = (ClassDeclaration)selectedNode;
        }
        if (parentTypeDecl == null) {
            return;
        }
        ModifierCorrectionSubProcessor.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals, context.getCompilationUnit());
    }

    public static void addMakeTypeAbstractProposal(IInvocationContext context, ClassDeclaration parentTypeDecl, Collection<IScriptCompletionProposal> proposals, ISourceModule cu) {
        ASTRewrite rewrite = ASTRewrite.create((AST)parentTypeDecl.getAST());
        rewrite.set((ASTNode)parentTypeDecl, (StructuralPropertyDescriptor)ClassDeclaration.MODIFIER_PROPERTY, (Object)(parentTypeDecl.getModifier() | 1), null);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, parentTypeDecl.getName().getName());
        Image image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
        proposals.add(proposal);
    }
}

