/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.Table;

public class CachedCheckboxTableViewer
extends CheckboxTableViewer {
    private Set<Object> checkState = new HashSet<Object>();
    private static final Object[] NO_ELEMENTS = new Object[0];

    protected CachedCheckboxTableViewer(Table table) {
        super(table);
        this.addCheckStateListener(event -> this.updateCheckState(event.getElement(), event.getChecked()));
        this.setUseHashlookup(true);
    }

    protected void updateCheckState(Object element, boolean state) {
        if (state) {
            this.checkState.add(element);
        } else {
            this.checkState.remove(element);
        }
    }

    public void restoreCachedState() {
        this.getTable().setRedraw(false);
        super.setCheckedElements(NO_ELEMENTS);
        this.setGrayedElements(NO_ELEMENTS);
        super.setCheckedElements(this.checkState.toArray());
        this.getTable().setRedraw(true);
    }

    protected void preservingSelection(Runnable updateCode) {
        super.preservingSelection(updateCode);
        this.restoreCachedState();
    }

    public Object[] getUnfilteredCheckedElements() {
        return this.checkState.toArray(Object[]::new);
    }

    public int getUnfilteredCheckedCount() {
        return this.checkState.size();
    }

    public boolean isCheckedElement(Object element) {
        return this.checkState.contains(element);
    }

    public boolean setChecked(Object element, boolean state) {
        this.updateCheckState(element, state);
        return super.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        this.checkState.clear();
        Collections.addAll(this.checkState, elements);
        super.setCheckedElements(elements);
    }

    public void setAllChecked(boolean state) {
        super.setAllChecked(state);
        if (state) {
            Object[] visible = this.getFilteredChildren(this.getRoot());
            Collections.addAll(this.checkState, visible);
        } else {
            Object[] visible;
            Object[] objectArray = visible = this.filter(this.checkState.toArray());
            int n = visible.length;
            int n2 = 0;
            while (n2 < n) {
                Object visibleObject = objectArray[n2];
                this.checkState.remove(visibleObject);
                ++n2;
            }
        }
    }

    public void remove(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.updateCheckState(element, false);
            ++n2;
        }
        super.remove(elements);
    }

    public void remove(Object element) {
        this.updateCheckState(element, false);
        super.remove(element);
    }
}

