/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.uml2.uml.Image;

public class PropertiesImageServices {
    private static final String KIND_UNDEFINED = "undefined";
    private static final String KIND_ICON = "icon";
    private static final String KIND_SHAPE = "shape";
    private static final String IMAGE_PAPYRUS_EA = "image_papyrus";
    private static final String IMAGE_EXPR_KEY = "image_expr_key";
    private static final String IMAGE_KIND_KEY = "image_kind_key";
    private static final String IMAGE_NAME_KEY = "image_name_key";

    private static void cleanImageAnnotation(EAnnotation annotation) {
        EMap details = annotation.getDetails();
        if (details.isEmpty()) {
            annotation.setEModelElement(null);
        }
    }

    public String getImageName(Image image) {
        EAnnotation eaImage = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String name = null;
        if (eaImage != null && eaImage.getDetails().containsKey((Object)IMAGE_NAME_KEY)) {
            name = (String)eaImage.getDetails().get((Object)IMAGE_NAME_KEY);
        }
        return name;
    }

    public void setImageName(Image image, String name) {
        EAnnotation eaImage = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (eaImage == null) {
            eaImage = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(name)) {
            eaImage.getDetails().removeKey((Object)IMAGE_NAME_KEY);
        } else {
            eaImage.getDetails().put((Object)IMAGE_NAME_KEY, (Object)name);
        }
        PropertiesImageServices.cleanImageAnnotation(eaImage);
    }

    public String getImageKind(Image image) {
        EAnnotation eaImageExpr = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String kind = null;
        if (eaImageExpr != null && eaImageExpr.getDetails().containsKey((Object)IMAGE_KIND_KEY)) {
            kind = (String)eaImageExpr.getDetails().get((Object)IMAGE_KIND_KEY);
        }
        return kind;
    }

    public void setImageKind(Image image, String kind) {
        EAnnotation eaImage = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (eaImage == null) {
            eaImage = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(kind)) {
            eaImage.getDetails().removeKey((Object)IMAGE_KIND_KEY);
        } else {
            eaImage.getDetails().put((Object)IMAGE_KIND_KEY, (Object)kind);
        }
        PropertiesImageServices.cleanImageAnnotation(eaImage);
    }

    public List<String> getImageKindEnumerations(Image obj) {
        return Arrays.asList(KIND_UNDEFINED, KIND_ICON, KIND_SHAPE);
    }

    public String getImageExpression(Image image) {
        EAnnotation eaImageExpr = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String expr = null;
        if (eaImageExpr != null && eaImageExpr.getDetails().containsKey((Object)IMAGE_EXPR_KEY)) {
            expr = (String)eaImageExpr.getDetails().get((Object)IMAGE_EXPR_KEY);
        }
        return expr;
    }

    public void setImageExpression(Image image, String expression) {
        EAnnotation eaImage = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (eaImage == null) {
            eaImage = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(expression)) {
            eaImage.getDetails().removeKey((Object)IMAGE_EXPR_KEY);
        } else {
            eaImage.getDetails().put((Object)IMAGE_EXPR_KEY, (Object)expression);
        }
        PropertiesImageServices.cleanImageAnnotation(eaImage);
    }
}

