/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.OpaqueBehaviorLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.PreferenceConstants;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ValueSpecificationLabelHelper;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransitionPropertiesParser {
    public static final String ONE_SPACE_STRING = " ";
    public static final String EMPTY_STRING = "";
    protected Constraint guardConstraint = null;
    private final INamedElementNameProvider namedElementNameProvider;

    public TransitionPropertiesParser(INamedElementNameProvider namedElementNameProvider) {
        this.namedElementNameProvider = namedElementNameProvider;
    }

    public String getValueString(Transition transition) {
        StringBuilder result = new StringBuilder();
        String textForTrigger = this.getTextForTrigger(transition);
        if (textForTrigger != null && !EMPTY_STRING.equals(textForTrigger)) {
            result.append(textForTrigger);
        }
        result.append(this.getTextForGuard(transition));
        String textForEffect = this.getTextForEffect(transition);
        if (textForEffect != null && !EMPTY_STRING.equals(textForEffect)) {
            result.append("/");
            if (PreferenceConstants.LINEBREAK_BEFORE_EFFECT.booleanValue()) {
                result.append("\n");
            }
            result.append(textForEffect);
        }
        return result.toString();
    }

    protected String getTextForGuard(Transition trans) {
        Constraint constraint = trans.getGuard();
        if (constraint != null) {
            String value;
            if (constraint.getSpecification() != null) {
                value = new ValueSpecificationLabelHelper(this.namedElementNameProvider).getConstraintValue(constraint);
            } else {
                String name = this.namedElementNameProvider.getName((NamedElement)constraint);
                if (name == null) {
                    name = "<undef>";
                }
                value = String.format("%s (no spec)", name);
            }
            if (value != null) {
                return String.format("[%s]", value);
            }
        }
        return EMPTY_STRING;
    }

    protected String getTextForEffect(Transition trans) {
        StringBuilder result = new StringBuilder();
        Behavior effect = trans.getEffect();
        if (effect != null) {
            OpaqueBehavior ob;
            EClass eClass = effect.eClass();
            if (effect instanceof OpaqueBehavior && (ob = (OpaqueBehavior)effect).getBodies().size() > 0) {
                result.append(OpaqueBehaviorLabelHelper.retrieveBody(ob));
                return result.toString();
            }
            if (eClass != null) {
                result.append(eClass.getName()).append(": ").append(this.namedElementNameProvider.getName((NamedElement)effect));
            }
        }
        return result.toString();
    }

    protected String getTextForTrigger(Transition trans) {
        StringBuilder result = new StringBuilder();
        boolean isFirstTrigger = true;
        for (Trigger t : trans.getTriggers()) {
            if (t == null) continue;
            if (!isFirstTrigger) {
                result.append(", ");
            } else {
                isFirstTrigger = false;
            }
            Event e = t.getEvent();
            if (e instanceof CallEvent) {
                Operation op = ((CallEvent)e).getOperation();
                if (op != null) {
                    result.append(this.namedElementNameProvider.getName((NamedElement)op));
                    if (op.getOwnedParameters().size() <= 0 || !PreferenceConstants.INDICATE_PARAMETERS.booleanValue()) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(this.namedElementNameProvider.getName((NamedElement)e));
                continue;
            }
            if (e instanceof SignalEvent) {
                Signal signal = ((SignalEvent)e).getSignal();
                if (signal != null) {
                    result.append(this.namedElementNameProvider.getName((NamedElement)signal));
                    if (signal.getAttributes().size() <= 0 || !PreferenceConstants.INDICATE_PARAMETERS.booleanValue()) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(this.namedElementNameProvider.getName((NamedElement)e));
                continue;
            }
            if (e instanceof ChangeEvent) {
                ValueSpecification vs = ((ChangeEvent)e).getChangeExpression();
                String value = vs instanceof OpaqueExpression ? OpaqueBehaviorLabelHelper.retrieveBody((OpaqueExpression)vs) : vs.stringValue();
                result.append(value);
                continue;
            }
            if (e instanceof TimeEvent) {
                ValueSpecification vs;
                TimeEvent timeEvent = (TimeEvent)e;
                result.append(timeEvent.isRelative() ? "after " : "at ");
                TimeExpression te = timeEvent.getWhen();
                String value = te != null ? ((vs = te.getExpr()) instanceof OpaqueExpression ? OpaqueBehaviorLabelHelper.retrieveBody((OpaqueExpression)vs) : vs.stringValue()) : "undefined";
                result.append(value);
                continue;
            }
            result.append("all");
        }
        return result.toString();
    }
}

