/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.ReadSelfAction;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDefaultNameProvider {
    public String getDefaultName(NamedElement element, EObject parent) {
        return this.getDefaultName(element, this.getContextContent(parent));
    }

    private Collection<EObject> getContextContent(EObject parent) {
        EList contents = parent != null ? parent.eContents() : Collections.emptyList();
        return contents;
    }

    public String getDefaultName(NamedElement element, Collection<EObject> context) {
        if (element == null) {
            return null;
        }
        if (element.getName() != null && context.contains(element)) {
            ENamedElement eNamedElement;
            if (element instanceof ENamedElement && (eNamedElement = (ENamedElement)element).getName() != null) {
                return eNamedElement.getName();
            }
            NamedElement namedElement = element;
            if (namedElement.getName() != null) {
                return namedElement.getName();
            }
        }
        return ((Optional)new NameGenerator(context).doSwitch((EObject)element)).orElse(null);
    }

    final class NameGenerator
    extends UMLSwitch<Optional<String>> {
        private static final String EXTENSION_SEPARATOR = "_";
        private static final String EXTENSION_BASE = "E_";
        private static final String SEPARATOR = "";
        private final Collection<EObject> context;

        NameGenerator(Collection<EObject> context) {
            this.context = context;
        }

        public Optional<String> caseRelationship(Relationship object) {
            return Optional.empty();
        }

        public Optional<String> caseAssociation(Association object) {
            return Optional.empty();
        }

        public Optional<String> caseActivityEdge(ActivityEdge object) {
            return Optional.empty();
        }

        public Optional<String> caseExtension(Extension extension) {
            Class target = extension.getMetaclass();
            Object name = EXTENSION_BASE;
            Stereotype source = extension.getStereotype();
            String sourceName = SEPARATOR;
            if (source != null && !source.getName().isBlank()) {
                sourceName = source.getName();
            }
            name = (String)name + sourceName + EXTENSION_SEPARATOR + target.getName();
            name = this.computeDefaultNameWithIncrementFromBase((String)name, (EObject)extension, SEPARATOR);
            return Optional.of(name);
        }

        public Optional<String> caseTransition(Transition object) {
            return Optional.empty();
        }

        public Optional<String> caseGeneralOrdering(GeneralOrdering object) {
            return Optional.empty();
        }

        public Optional<String> caseReadSelfAction(ReadSelfAction object) {
            return Optional.of("this");
        }

        public Optional<String> defaultCase(EObject object) {
            String base = object.eClass().getName();
            return Optional.ofNullable(this.computeDefaultNameWithIncrementFromBase(base, object, SEPARATOR));
        }

        public Optional<String> casePseudostate(Pseudostate pseudostate) {
            Object base = pseudostate.getKind().getLiteral();
            base = ((String)base).substring(0, 1).toUpperCase() + ((String)base).substring(1);
            return Optional.of(this.computeDefaultNameWithIncrementFromBase((String)base, (EObject)pseudostate, SEPARATOR));
        }

        private String computeDefaultNameWithIncrementFromBase(String base, EObject elementToRename, String separator) {
            int nextNumber = this.context.stream().filter(e -> e != elementToRename && e instanceof NamedElement).map(o -> ((NamedElement)o).getName()).filter(name -> name != null && name.startsWith(base)).map(name -> name.substring(base.length() + separator.length())).mapToInt(end -> {
                try {
                    return Integer.parseInt(end);
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }).max().orElse(0) + 1;
            return base + separator + nextNumber;
        }
    }
}

