/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorHelper {
    public CheckStatus canCreateConnector(IViewQuerier representationQuery, Object sourceView, Object targetView) {
        CheckStatus result = sourceView == targetView ? CheckStatus.no("Cannot connect a port to itself.") : (representationQuery.getBorderedNodes(sourceView).contains(targetView) || representationQuery.getBorderedNodes(targetView).contains(sourceView) ? CheckStatus.no("Cannot create a connector from a view representing a Part to its own Port (or the opposite).") : (this.getStructureContainers(sourceView, representationQuery).contains(targetView) || this.getStructureContainers(targetView, representationQuery).contains(sourceView) ? CheckStatus.no("Cannot connect a Part to one of its (possibly indirect) containment, must connect to one of its Port.") : CheckStatus.YES));
        return result;
    }

    public EObject getConnectorContainer(Connector connector, IViewQuerier representationQuery, Object sourceView, Object targetView) {
        List sourceStructureClassifiers = representationQuery.getVisualAncestorNodes(sourceView).stream().map(representationQuery::getSemanticElement).filter(e -> e instanceof StructuredClassifier).map(e -> (StructuredClassifier)e).collect(Collectors.toList());
        List targetStructureClassifiers = representationQuery.getVisualAncestorNodes(targetView).stream().map(representationQuery::getSemanticElement).filter(e -> e instanceof StructuredClassifier).map(e -> (StructuredClassifier)e).collect(Collectors.toList());
        for (StructuredClassifier structuredClassifier : targetStructureClassifiers) {
            if (!sourceStructureClassifiers.contains(structuredClassifier)) continue;
            return structuredClassifier;
        }
        return null;
    }

    private List<Object> getStructureContainers(Object view, IViewQuerier representationQuery) {
        return representationQuery.getVisualAncestorNodes(view).stream().filter(v -> this.getStructuredClassifier(v, representationQuery) != null).collect(Collectors.toList());
    }

    private StructuredClassifier getStructuredClassifier(Object view, IViewQuerier querier) {
        Property property;
        StructuredClassifier structuredClassifier = null;
        EObject semanticElement = querier.getSemanticElement(view);
        if (semanticElement instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)semanticElement;
        } else if (semanticElement instanceof Property && (property = (Property)semanticElement).getType() instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)property.getType();
        }
        return structuredClassifier;
    }
}

