/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.IDomainBasedEdgeCreationChecker;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ConnectorHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ControlFlowHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ExtensionHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ObjectFlowHelper;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;

public class ElementDomainBasedEdgeCreationChecker
implements IDomainBasedEdgeCreationChecker {
    @Override
    public CheckStatus canCreate(EObject semanticEdgeSource, EObject semanticEdgeTarget, String type, String referenceName, IViewQuerier representationQuery, Object sourceView, Object targetView) {
        return switch (UMLHelper.toEClass(type).getClassifierID()) {
            case 24 -> this.handleAssociation(semanticEdgeSource, semanticEdgeTarget);
            case 193 -> this.handleCommunicationPath(semanticEdgeSource, semanticEdgeTarget);
            case 84 -> this.handleConnector(representationQuery, sourceView, targetView);
            case 33 -> this.handleDeployment(semanticEdgeSource, semanticEdgeTarget);
            case 73 -> this.handleElementImport(semanticEdgeSource, semanticEdgeTarget);
            case 80 -> this.handleUsage(semanticEdgeSource, semanticEdgeTarget);
            case 85 -> this.handleGeneralization(semanticEdgeSource, semanticEdgeTarget);
            case 197 -> this.handleInformationFlow(semanticEdgeSource, semanticEdgeTarget);
            case 198 -> this.handleMessage(semanticEdgeSource, semanticEdgeTarget);
            case 92 -> this.handleSubstitution(semanticEdgeSource, semanticEdgeTarget);
            case 38 -> this.handleManifestation(semanticEdgeSource, semanticEdgeTarget);
            case 66 -> this.handlePackageMerge(semanticEdgeSource, semanticEdgeTarget);
            case 74 -> this.handlePackageImport(semanticEdgeSource, semanticEdgeTarget);
            case 62 -> this.handleTransition(semanticEdgeSource, semanticEdgeTarget);
            case 91 -> this.handleInclude(semanticEdgeSource, semanticEdgeTarget);
            case 34 -> this.handleDependency(semanticEdgeSource, semanticEdgeTarget);
            case 89 -> this.handleExtend(semanticEdgeSource, semanticEdgeTarget);
            case 95 -> this.handleInterfaceRealization(semanticEdgeSource, semanticEdgeTarget);
            case 225 -> this.handleComponentRealization(semanticEdgeSource, semanticEdgeTarget);
            case 75 -> this.handleExtension(semanticEdgeSource, semanticEdgeTarget);
            case 176 -> this.handleObjectFlow(semanticEdgeSource, semanticEdgeTarget);
            case 173 -> this.handleControlFlow(semanticEdgeSource, semanticEdgeTarget);
            default -> CheckStatus.YES;
        };
    }

    @Override
    public CheckStatus canCreateFromSource(EObject semanticEdgeSource, String type, String referenceName, IViewQuerier representionQuery, Object sourceView) {
        return switch (UMLHelper.toEClass(type).getClassifierID()) {
            case 176 -> this.handleObjectFlowSource(semanticEdgeSource);
            case 173 -> this.handleControlFlowSource(semanticEdgeSource);
            default -> CheckStatus.YES;
        };
    }

    private CheckStatus handleAssociation(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Classifier) || !(semanticEdgeTarget instanceof Classifier) ? CheckStatus.no("Association can only be connected from a Classifier source to a Classifier target") : CheckStatus.YES;
        return result;
    }

    private CheckStatus handleCommunicationPath(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Classifier) || !(semanticEdgeSource instanceof DeploymentTarget) ? CheckStatus.no("CommunicationPath can only be connected from a DeploymentTarget and Classifier source") : (!(semanticEdgeTarget instanceof Classifier) || !(semanticEdgeTarget instanceof DeploymentTarget) ? CheckStatus.no("CommunicationPath can only be connected to a DeploymentTarget and Classifier target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleComponentRealization(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Classifier) ? CheckStatus.no("ComponentRealization can only be connected from a Classifier source") : (!(semanticEdgeTarget instanceof Component) ? CheckStatus.no("ComponentRealization can only be connected to a Component target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("The source and target of a ComponentRealization must be different") : CheckStatus.YES));
        return result;
    }

    private CheckStatus handleConnector(IViewQuerier representationQuery, Object sourceView, Object targetView) {
        ConnectorHelper connectorHelper = new ConnectorHelper();
        return connectorHelper.canCreateConnector(representationQuery, sourceView, targetView);
    }

    private CheckStatus handleControlFlow(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (new ControlFlowHelper().canCreateControlFlow(semanticEdgeSource, semanticEdgeTarget)) {
            return CheckStatus.YES;
        }
        return CheckStatus.no("A ControlFlow can only be connected from an ActivityNode or ObjectNode source to an ActivityNode or ObjectNode target that are Control Types");
    }

    private CheckStatus handleControlFlowSource(EObject semanticEdgeSource) {
        if (new ControlFlowHelper().canCreateFromSource(semanticEdgeSource)) {
            return CheckStatus.YES;
        }
        return CheckStatus.no("A ControlFlow can only be connected from an ActivityNode or ObjectNode source that is a Control Type");
    }

    private CheckStatus handleDependency(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof NamedElement) || !(semanticEdgeTarget instanceof NamedElement) ? CheckStatus.no("Dependency can only be connected from a NamedElement source to a NamedElement target") : CheckStatus.YES;
        return result;
    }

    private CheckStatus handleDeployment(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof DeployedArtifact) || !(semanticEdgeTarget instanceof DeploymentTarget) ? CheckStatus.no("Deployment can only be connected from a DeployedArtifact source to a DeploymentTarget target") : (Objects.equals(semanticEdgeSource, semanticEdgeTarget) ? CheckStatus.no("The source and target of a Deployment must be different") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleElementImport(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Namespace) || !(semanticEdgeTarget instanceof PackageableElement) ? CheckStatus.no("ElementImport can only be connected from a Namespace source to a PackageableElement target") : CheckStatus.YES;
        return result;
    }

    private CheckStatus handleExtend(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof UseCase) || !(semanticEdgeTarget instanceof UseCase) ? CheckStatus.no("Extend can only be connected from a Use Case source to a UseCase target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("Extend cannot use the same element for source and target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleExtension(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        ExtensionHelper extensionHelper = new ExtensionHelper();
        CheckStatus result = !extensionHelper.canCreate(semanticEdgeSource, semanticEdgeTarget) ? CheckStatus.no("Extension can only be connected from a Stereotype source to a Metaclass target") : CheckStatus.YES;
        return result;
    }

    private CheckStatus handleGeneralization(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Classifier) || !(semanticEdgeTarget instanceof Classifier) ? CheckStatus.no("Generalization can only be connected from a Classifier source to a Classifier target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("Generalization cannot use the same element for source and target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleInclude(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof UseCase) || !(semanticEdgeTarget instanceof UseCase) ? CheckStatus.no("Include can only be connected from a UseCase source to a UseCase target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("Include cannot use the same element for source and target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleInformationFlow(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (!(semanticEdgeSource instanceof NamedElement) || !(semanticEdgeTarget instanceof NamedElement)) {
            return CheckStatus.no("InformationFlow can only be connected from a NamedElement source to a NamedElement target");
        }
        return CheckStatus.YES;
    }

    private CheckStatus handleInterfaceRealization(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof BehavioredClassifier) ? CheckStatus.no("InterfaceRealization can only be connected from a BehaviorClassifier source") : (!(semanticEdgeTarget instanceof Interface) ? CheckStatus.no("InterfaceRealization can only be connected to an Interface source") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleManifestation(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof NamedElement) || !(semanticEdgeTarget instanceof PackageableElement) ? CheckStatus.no("Manifestation can only be connected from a NamedElement source to a PackageableElement target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("Manifestation cannot use the same element for source and target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleMessage(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Lifeline) && !(semanticEdgeSource instanceof Interaction) && !(semanticEdgeSource instanceof Gate) && !(semanticEdgeSource instanceof ExecutionSpecification) ? CheckStatus.no("Message can only be connected from a Lifeline or Interaction or Gate or ExecutionSpecification source") : (!(semanticEdgeTarget instanceof Lifeline) && !(semanticEdgeTarget instanceof Interaction) && !(semanticEdgeTarget instanceof Gate) && !(semanticEdgeTarget instanceof ExecutionSpecification) ? CheckStatus.no("Message can only be connected to Lifeline or Interaction or Gate or ExecutionSpecification target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleObjectFlow(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (new ObjectFlowHelper().canCreateObjectFlow(semanticEdgeSource, semanticEdgeTarget)) {
            return CheckStatus.YES;
        }
        return CheckStatus.no("An ObjectFlow can only be connected between ActivityNode except ExecutableNode");
    }

    private CheckStatus handleObjectFlowSource(EObject semanticEdgeSource) {
        if (semanticEdgeSource instanceof ActivityNode && new ObjectFlowHelper().canCreateFromSource((ActivityNode)semanticEdgeSource, null)) {
            return CheckStatus.YES;
        }
        return CheckStatus.no("ObjectFlow can only be connected from an ActivityNode source");
    }

    private CheckStatus handlePackageImport(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Namespace) ? CheckStatus.no("PackageImport can only be connected from a Namespace source") : (!(semanticEdgeTarget instanceof Package) ? CheckStatus.no("PackageImport can only be connected to a Package target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handlePackageMerge(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Package) || !(semanticEdgeTarget instanceof Package) ? CheckStatus.no("PackageMerge can only be connected from a Package source to a Package target") : CheckStatus.YES;
        return result;
    }

    private CheckStatus handleSubstitution(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        CheckStatus result = !(semanticEdgeSource instanceof Classifier) || !(semanticEdgeTarget instanceof Classifier) ? CheckStatus.no("Substitution can only be connected from a Classifier source to a Classifier target") : (semanticEdgeSource == semanticEdgeTarget ? CheckStatus.no("Substitution cannot use the same element for source and target") : CheckStatus.YES);
        return result;
    }

    private CheckStatus handleTransition(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (!(semanticEdgeSource instanceof Vertex) || !(semanticEdgeTarget instanceof Vertex)) {
            return CheckStatus.no("A Transition can only be connected from a Vertex source to a Vertex target");
        }
        return CheckStatus.YES;
    }

    private CheckStatus handleUsage(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (!(semanticEdgeSource instanceof NamedElement) || !(semanticEdgeTarget instanceof NamedElement)) {
            return CheckStatus.no("Usage can only be connected from a NamedElement source to a NamedElement target");
        }
        return CheckStatus.YES;
    }
}

