/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.ViewpointHelpers;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.sirius.diagram.sequence.description.ObservationPointMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public final class SequenceDiagramObservationServices {
    private static final UMLPackage UML = UMLPackage.eINSTANCE;
    private static final SequenceDiagramUMLHelper UML_HELPER = new SequenceDiagramUMLHelper();
    private static final SequenceDiagramOrderServices ORDER_SERVICES = new SequenceDiagramOrderServices();
    private static final CommonDiagramServices COMMONS = new CommonDiagramServices();

    private SequenceDiagramObservationServices() {
    }

    public static boolean canCreateTimeElement(DSemanticDecorator view) {
        boolean end = view.getTarget() instanceof EAnnotation;
        return end && ViewpointHelpers.isMapping(view, ObservationPointMapping.class, "SD_ImplicitTimeElement");
    }

    public static TimeObservation createTimeObservation(EAnnotation end, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createTimeElement(end, event -> {
            Namespace container = UMLHelper.getPackagedContainer((Element)event);
            TimeObservation result = (TimeObservation)COMMONS.createElement((Element)container, UML.getTimeObservation().getName(), "packagedElement", parentView);
            result.setEvent(event);
            return result;
        });
    }

    public static TimeConstraint createTimeConstraint(EAnnotation end, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createTimeElement(end, event -> {
            Interaction interaction = UML_HELPER.getOwningInteraction((Element)event);
            TimeConstraint result = (TimeConstraint)COMMONS.createElement((Element)interaction, UML.getTimeConstraint().getName(), UML.getNamespace_OwnedRule().getName(), parentView);
            result.getConstrainedElements().add(event);
            return result;
        });
    }

    private static <T extends PackageableElement> T createTimeElement(EAnnotation end, Function<NamedElement, T> factory) {
        InteractionFragment event = ORDER_SERVICES.getEndFragment(end);
        List<PackageableElement> existingElements = SequenceDiagramUMLHelper.getTimeElementsFromEvent((NamedElement)event);
        if (!existingElements.isEmpty()) {
            return null;
        }
        return (T)((PackageableElement)factory.apply((NamedElement)event));
    }

    public static PackageableElement getAssociatedTimeElement(EAnnotation end) {
        return SequenceDiagramUMLHelper.getTimeElementFromEnd(end).orElse(null);
    }

    public static EAnnotation getDurationElementSource(PackageableElement element) {
        return SequenceDiagramObservationServices.getEndFromEventPair(SequenceDiagramObservationServices.getDurationEnds(element), true);
    }

    public static EAnnotation getDurationElementTarget(PackageableElement element) {
        return SequenceDiagramObservationServices.getEndFromEventPair(SequenceDiagramObservationServices.getDurationEnds(element), false);
    }

    /*
     * WARNING - void declaration
     */
    private static List<? extends NamedElement> getDurationEnds(PackageableElement element) {
        Object result = Collections.emptyList();
        PackageableElement packageableElement = element;
        if (packageableElement instanceof DurationConstraint) {
            void constraint;
            DurationConstraint durationConstraint = (DurationConstraint)packageableElement;
            DurationConstraint cfr_ignored_0 = (DurationConstraint)packageableElement;
            result = constraint.getConstrainedElements().stream().filter(OccurrenceSpecification.class::isInstance).map(OccurrenceSpecification.class::cast).toList();
        } else {
            PackageableElement packageableElement2 = element;
            if (packageableElement2 instanceof DurationObservation) {
                void observation;
                DurationObservation durationObservation = (DurationObservation)packageableElement2;
                DurationObservation cfr_ignored_1 = (DurationObservation)packageableElement2;
                result = observation.getEvents();
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static EAnnotation getEndFromEventPair(List<? extends NamedElement> values, boolean first) {
        if (values.size() < 2) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = 1;
        }
        EAnnotation result = null;
        NamedElement namedElement = values.get(index);
        if (namedElement instanceof OccurrenceSpecification) {
            void occurence;
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)namedElement;
            OccurrenceSpecification cfr_ignored_0 = (OccurrenceSpecification)namedElement;
            result = ORDER_SERVICES.findOccurrenceEnd((OccurrenceSpecification)occurence);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean canCreateDurationElement(EObject source, EObject target) {
        boolean result = true;
        if (source == target) {
            result = SequenceDiagramObservationServices.hasDuration(source);
        } else {
            EObject eObject = source;
            if (eObject instanceof Message) {
                void message;
                Message message2 = (Message)eObject;
                Message cfr_ignored_0 = (Message)eObject;
                result = SequenceDiagramObservationServices.containsDuration((Message)message, target);
            } else {
                EObject eObject2 = target;
                if (eObject2 instanceof Message) {
                    void message;
                    Message message3 = (Message)eObject2;
                    Message cfr_ignored_1 = (Message)eObject2;
                    result = SequenceDiagramObservationServices.containsDuration((Message)message, source);
                }
            }
        }
        return result && SequenceDiagramObservationServices.areFragmentSiblings(SequenceDiagramObservationServices.adaptToOccurrence(source), SequenceDiagramObservationServices.adaptToOccurrence(target));
    }

    /*
     * WARNING - void declaration
     */
    private static OccurrenceSpecification adaptToOccurrence(EObject element) {
        OccurrenceSpecification result = null;
        EObject eObject = element;
        if (eObject instanceof OccurrenceSpecification) {
            void value;
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)eObject;
            OccurrenceSpecification cfr_ignored_0 = (OccurrenceSpecification)eObject;
            result = value;
        } else {
            EObject eObject2 = element;
            if (eObject2 instanceof ExecutionSpecification) {
                void exec;
                ExecutionSpecification executionSpecification = (ExecutionSpecification)eObject2;
                ExecutionSpecification cfr_ignored_1 = (ExecutionSpecification)eObject2;
                result = exec.getStart();
            } else {
                EObject eObject3 = element;
                if (eObject3 instanceof Message) {
                    void message;
                    Message message2 = (Message)eObject3;
                    Message cfr_ignored_2 = (Message)eObject3;
                    result = (OccurrenceSpecification)message.getSendEvent();
                } else {
                    EObject eObject4 = element;
                    if (eObject4 instanceof EAnnotation) {
                        void end;
                        EAnnotation eAnnotation = (EAnnotation)eObject4;
                        EAnnotation cfr_ignored_3 = (EAnnotation)eObject4;
                        InteractionFragment interactionFragment = ORDER_SERVICES.getEndFragment((EAnnotation)end);
                        if (interactionFragment instanceof OccurrenceSpecification) {
                            void value;
                            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)interactionFragment;
                            OccurrenceSpecification cfr_ignored_4 = (OccurrenceSpecification)interactionFragment;
                            result = value;
                        }
                    }
                }
            }
        }
        return result;
    }

    private static boolean areFragmentSiblings(OccurrenceSpecification source, OccurrenceSpecification target) {
        return source != null && target != null && source.getEnclosingOperand() == target.getEnclosingOperand();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsDuration(Message message, EObject other) {
        EObject eObject = other;
        if (eObject instanceof EAnnotation) {
            void pseudoEnd;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EAnnotation cfr_ignored_0 = (EAnnotation)eObject;
            InteractionFragment interactionFragment = ORDER_SERVICES.getEndFragment((EAnnotation)pseudoEnd);
            if (interactionFragment instanceof MessageEnd) {
                void end;
                MessageEnd messageEnd = (MessageEnd)interactionFragment;
                MessageEnd cfr_ignored_1 = (MessageEnd)interactionFragment;
                return message != end.getMessage() || SequenceDiagramObservationServices.hasDuration((EObject)message);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasDuration(EObject element) {
        block2: {
            block3: {
                void message;
                if (element instanceof ExecutionSpecification) break block2;
                EObject eObject = element;
                if (!(eObject instanceof Message)) break block3;
                Message message2 = (Message)eObject;
                Message cfr_ignored_0 = (Message)eObject;
                if (message.getSendEvent() instanceof MessageOccurrenceSpecification && message.getReceiveEvent() instanceof MessageOccurrenceSpecification) break block2;
            }
            return false;
        }
        return true;
    }

    public static DurationConstraint createDurationConstraint(EObject source, EObject target, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createDuration(source, target, context -> {
            Interaction interaction = UML_HELPER.getOwningInteraction((Element)context);
            return (DurationConstraint)COMMONS.createElement((Element)interaction, UML.getDurationConstraint().getName(), UML.getNamespace_OwnedRule().getName(), parentView);
        });
    }

    public static DurationObservation createDurationObservation(EObject source, EObject target, DSemanticDecorator view) {
        return SequenceDiagramObservationServices.createDuration(source, target, context -> {
            Namespace container = UMLHelper.getPackagedContainer((Element)context);
            return (DurationObservation)COMMONS.createElement((Element)container, UML.getDurationObservation().getName(), "packagedElement", view);
        });
    }

    private static <T extends PackageableElement> T createDuration(EObject source, EObject target, Function<Element, T> factory) {
        DurationEventCandidate sourceSet = SequenceDiagramObservationServices.createDurationEventCandidate(source);
        DurationEventCandidate targetSet = SequenceDiagramObservationServices.createDurationEventCandidate(target);
        if (!sourceSet.isValid() || !targetSet.isValid()) {
            return null;
        }
        PackageableElement result = (PackageableElement)factory.apply((Element)sourceSet.getContext());
        if (!sourceSet.applySingleEvent(result, targetSet) && !sourceSet.applySharedEvent(result, targetSet)) {
            sourceSet.addInEvents(result);
            targetSet.addInEvents(result);
        }
        return (T)result;
    }

    /*
     * WARNING - void declaration
     */
    private static DurationEventCandidate createDurationEventCandidate(EObject element) {
        DurationEventCandidate result = null;
        EObject eObject = element;
        if (eObject instanceof Message) {
            void message;
            Message message2 = (Message)eObject;
            Message cfr_ignored_0 = (Message)eObject;
            result = new DurationEventCandidate(null, (Message)message, null);
        } else {
            EObject eObject2 = element;
            if (eObject2 instanceof ExecutionSpecification) {
                void execution;
                ExecutionSpecification executionSpecification = (ExecutionSpecification)eObject2;
                ExecutionSpecification cfr_ignored_1 = (ExecutionSpecification)eObject2;
                result = new DurationEventCandidate(null, null, (ExecutionSpecification)execution);
            } else {
                EObject eObject3 = element;
                if (eObject3 instanceof EAnnotation) {
                    void end;
                    EAnnotation eAnnotation = (EAnnotation)eObject3;
                    EAnnotation cfr_ignored_2 = (EAnnotation)eObject3;
                    InteractionFragment interactionFragment = ORDER_SERVICES.getEndFragment((EAnnotation)end);
                    if (interactionFragment instanceof OccurrenceSpecification) {
                        void occurrence;
                        OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)interactionFragment;
                        OccurrenceSpecification cfr_ignored_3 = (OccurrenceSpecification)interactionFragment;
                        Message message = null;
                        void var17_11 = occurrence;
                        if (var17_11 instanceof MessageOccurrenceSpecification) {
                            void mos;
                            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)var17_11;
                            MessageOccurrenceSpecification cfr_ignored_4 = (MessageOccurrenceSpecification)var17_11;
                            message = mos.getMessage();
                        }
                        result = new DurationEventCandidate((OccurrenceSpecification)occurrence, message, SequenceDiagramUMLHelper.getAssociatedExecution((OccurrenceSpecification)occurrence));
                    }
                }
            }
        }
        return result;
    }

    private static boolean applySharedMessageEvent(PackageableElement value, Message message, ExecutionSpecification execution) {
        if (message == null || execution == null) {
            return false;
        }
        boolean result = false;
        if (message.getReceiveEvent() == execution.getStart()) {
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)message, true);
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)execution, false);
            result = true;
        } else if (message.getSendEvent() == execution.getFinish()) {
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)execution, true);
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)message, false);
            result = true;
        }
        return result;
    }

    private static void addEventEnd(PackageableElement parent, NamedElement event, boolean firstEvent) {
        OccurrenceSpecification end = firstEvent ? (OccurrenceSpecification)UML_HELPER.getSemanticStart((Element)event) : (OccurrenceSpecification)UML_HELPER.getSemanticFinish((Element)event);
        SequenceDiagramObservationServices.addEvent(parent, (NamedElement)end);
    }

    /*
     * WARNING - void declaration
     */
    private static void addEvent(PackageableElement parent, NamedElement event) {
        PackageableElement packageableElement = parent;
        if (packageableElement instanceof DurationConstraint) {
            void constraint;
            DurationConstraint durationConstraint = (DurationConstraint)packageableElement;
            DurationConstraint cfr_ignored_0 = (DurationConstraint)packageableElement;
            constraint.getConstrainedElements().add((Object)event);
        } else {
            PackageableElement packageableElement2 = parent;
            if (packageableElement2 instanceof DurationObservation) {
                void observation;
                DurationObservation durationObservation = (DurationObservation)packageableElement2;
                DurationObservation cfr_ignored_1 = (DurationObservation)packageableElement2;
                observation.getEvents().add((Object)event);
            }
        }
    }

    public static void replaceFragmentReferences(OccurrenceSpecification previous, OccurrenceSpecification next) {
        List<PackageableElement> temporals = SequenceDiagramUMLHelper.getTemporalElementsFromEvent((NamedElement)previous);
        temporals.forEach(element -> {
            Object object = element;
            if (object instanceof TimeObservation) {
                void timeObs;
                TimeObservation timeObservation = (TimeObservation)object;
                TimeObservation cfr_ignored_0 = (TimeObservation)object;
                timeObs.setEvent((NamedElement)next);
            } else {
                EList refs;
                Object object2 = element;
                if (object2 instanceof DurationObservation) {
                    void durationObs;
                    DurationObservation durationObservation = (DurationObservation)object2;
                    DurationObservation cfr_ignored_1 = (DurationObservation)object2;
                    refs = durationObs.getEvents();
                } else {
                    refs = ((Constraint)element).getConstrainedElements();
                }
                refs.set(refs.indexOf(previous), next);
            }
        });
        List.copyOf(previous.getToBefores()).forEach(ordering -> ordering.setAfter(next));
        List.copyOf(previous.getToAfters()).forEach(ordering -> ordering.setBefore(next));
    }

    private record DurationEventCandidate(OccurrenceSpecification event, Message message, ExecutionSpecification execution) {
        boolean isValid() {
            return this.message != null || this.execution != null;
        }

        NamedElement getContext() {
            if (this.message != null) {
                return this.message;
            }
            return this.execution;
        }

        void addInEvents(PackageableElement result) {
            Message element = this.message;
            if (this.execution != null) {
                element = this.execution;
            }
            boolean first = this.event == null || UML_HELPER.getSemanticStart((Element)element) == this.event;
            SequenceDiagramObservationServices.addEventEnd(result, (NamedElement)element, first);
        }

        boolean applySingleEvent(PackageableElement parent, DurationEventCandidate other) {
            Message value = null;
            if (this.message != null && this.message == other.message) {
                value = this.message;
            } else if (this.execution != null && this.execution == other.execution) {
                value = this.execution;
            }
            if (value == null) {
                return false;
            }
            SequenceDiagramObservationServices.addEvent(parent, (NamedElement)value);
            return true;
        }

        boolean applySharedEvent(PackageableElement value, DurationEventCandidate other) {
            return SequenceDiagramObservationServices.applySharedMessageEvent(value, this.message, other.execution) || SequenceDiagramObservationServices.applySharedMessageEvent(value, other.message, this.execution);
        }
    }
}

