/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterVariable;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ResultVariable;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryIterationOrOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class PivotHelper {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull StandardLibrary standardLibrary;
    private final @NonNull PivotMetamodelManager metamodelManager;

    public PivotHelper(@NonNull EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.standardLibrary = environmentFactory.getStandardLibrary();
        this.metamodelManager = (PivotMetamodelManager)environmentFactory.getMetamodelManager();
    }

    public @NonNull BooleanLiteralExp createBooleanLiteralExp(boolean booleanSymbol) {
        BooleanLiteralExp asBoolean = PivotFactory.eINSTANCE.createBooleanLiteralExp();
        asBoolean.setBooleanSymbol(booleanSymbol);
        asBoolean.setType(this.standardLibrary.getBooleanType());
        asBoolean.setIsRequired(true);
        return asBoolean;
    }

    public @NonNull OCLExpression createCoercionCallExp(@NonNull OCLExpression asExpression, @NonNull Operation coercion) {
        Class integerType;
        Operation asCoercion;
        IntegerLiteralExp asIntegerLiteralExp;
        Number integerSymbol;
        if (asExpression instanceof IntegerLiteralExp && (integerSymbol = (asIntegerLiteralExp = (IntegerLiteralExp)asExpression).getIntegerSymbol()).longValue() >= 0L && coercion == (asCoercion = NameUtil.getNameable((integerType = this.standardLibrary.getIntegerType()).getOwnedOperations(), "toUnlimitedNatural"))) {
            return this.createUnlimitedNaturalLiteralExp(integerSymbol);
        }
        OperationCallExp asCoercionCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        asCoercionCallExp.setOwnedSource(asExpression);
        asCoercionCallExp.setReferredOperation(coercion);
        asCoercionCallExp.setType(coercion.getType());
        asCoercionCallExp.setIsRequired(coercion.isIsRequired());
        return asCoercionCallExp;
    }

    public @NonNull CollectionItem createCollectionItem(@NonNull OCLExpression asItem) {
        CollectionItem collectionItem = PivotFactory.eINSTANCE.createCollectionItem();
        collectionItem.setOwnedItem(asItem);
        collectionItem.setType(asItem.getType());
        collectionItem.setIsRequired(asItem.isIsRequired());
        return collectionItem;
    }

    public @NonNull CollectionLiteralExp createCollectionLiteralExp(@NonNull CollectionType asType, @NonNull Iterable<CollectionLiteralPart> asParts) {
        CollectionLiteralExp collectionLiteralExp = PivotFactory.eINSTANCE.createCollectionLiteralExp();
        Iterables.addAll(collectionLiteralExp.getOwnedParts(), asParts);
        collectionLiteralExp.setType(asType);
        collectionLiteralExp.setKind(TypeUtil.getCollectionKind(asType));
        collectionLiteralExp.setIsRequired(true);
        return collectionLiteralExp;
    }

    public @NonNull CollectionRange createCollectionRange(@NonNull OCLExpression asFirst, @NonNull OCLExpression asLast) {
        CollectionRange collectionRange = PivotFactory.eINSTANCE.createCollectionRange();
        collectionRange.setOwnedFirst(asFirst);
        collectionRange.setOwnedLast(asLast);
        collectionRange.setType(this.standardLibrary.getIntegerType());
        collectionRange.setIsRequired(true);
        return collectionRange;
    }

    public @NonNull Comment createComment(@NonNull String comment) {
        Comment asComment = PivotFactory.eINSTANCE.createComment();
        asComment.setBody(comment);
        return asComment;
    }

    public @NonNull EnumLiteralExp createEnumLiteralExp(@NonNull EnumerationLiteral value) {
        EnumLiteralExp asEnumLiteralExp = PivotFactory.eINSTANCE.createEnumLiteralExp();
        asEnumLiteralExp.setReferredLiteral(value);
        asEnumLiteralExp.setType(value.getOwningEnumeration());
        asEnumLiteralExp.setIsRequired(true);
        return asEnumLiteralExp;
    }

    public @NonNull IfExp createIfExp(@NonNull OCLExpression asCondition, @NonNull OCLExpression asThen, @NonNull OCLExpression asElse) {
        Type commonType = this.metamodelManager.getCommonType(ClassUtil.nonNullState(asThen.getType()), TemplateParameterSubstitutions.EMPTY, ClassUtil.nonNullState(asElse.getType()), TemplateParameterSubstitutions.EMPTY);
        IfExp asIf = PivotFactory.eINSTANCE.createIfExp();
        asIf.setOwnedCondition(asCondition);
        asIf.setOwnedThen(asThen);
        asIf.setOwnedElse(asElse);
        asIf.setType(commonType);
        asIf.setIsRequired(asThen.isIsRequired() && asElse.isIsRequired());
        return asIf;
    }

    public @NonNull Import createImport(@Nullable String name, @NonNull Namespace namespace) {
        Import asImport = PivotFactory.eINSTANCE.createImport();
        asImport.setName(name);
        asImport.setImportedNamespace(namespace);
        asImport.setXmiidVersion(1);
        return asImport;
    }

    public @NonNull IntegerLiteralExp createIntegerLiteralExp(@NonNull Number integerSymbol) {
        IntegerLiteralExp asInteger = PivotFactory.eINSTANCE.createIntegerLiteralExp();
        asInteger.setIntegerSymbol(integerSymbol);
        asInteger.setType(this.standardLibrary.getIntegerType());
        asInteger.setIsRequired(true);
        return asInteger;
    }

    public @NonNull InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.standardLibrary.getOclInvalidType());
        return invalidLiteralExp;
    }

    public @NonNull IterateExp createIterateExp(@NonNull OCLExpression asSource, @NonNull Iteration asIteration, @NonNull List<@NonNull ? extends Variable> asIterators, @NonNull Variable asResult, @NonNull OCLExpression asBody) {
        IterateExp asCallExp = PivotFactory.eINSTANCE.createIterateExp();
        asCallExp.setReferredIteration(asIteration);
        asCallExp.setName(asIteration.getName());
        asCallExp.setOwnedSource(asSource);
        asCallExp.getOwnedIterators().addAll(asIterators);
        asCallExp.setOwnedResult(asResult);
        asCallExp.setOwnedBody(asBody);
        this.setOperationReturnType(asCallExp, asIteration);
        return asCallExp;
    }

    public @NonNull IteratorExp createIteratorExp(@NonNull OCLExpression asSource, @NonNull Iteration asIteration, @NonNull List<@NonNull ? extends Variable> asIterators, @NonNull OCLExpression asBody) {
        IteratorExp asCallExp = PivotFactory.eINSTANCE.createIteratorExp();
        asCallExp.setReferredIteration(asIteration);
        asCallExp.setName(asIteration.getName());
        asCallExp.setOwnedSource(asSource);
        asCallExp.getOwnedIterators().addAll(asIterators);
        asCallExp.setOwnedBody(asBody);
        this.setOperationReturnType(asCallExp, asIteration);
        return asCallExp;
    }

    public @NonNull IteratorVariable createIteratorVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        IteratorVariable asVariable = PivotFactory.eINSTANCE.createIteratorVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull LetExp createLetExp(@NonNull Variable asVariable, @NonNull OCLExpression asInExpression) {
        LetExp asLetExp = PivotFactory.eINSTANCE.createLetExp();
        asLetExp.setOwnedVariable(asVariable);
        asLetExp.setOwnedIn(asInExpression);
        asLetExp.setType(asInExpression.getType());
        asLetExp.setIsRequired(asInExpression.isIsRequired());
        asLetExp.setOwnedVariable(asVariable);
        return asLetExp;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asInitExpression.getType());
        asVariable.setIsRequired(asInitExpression.isIsRequired());
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull LetVariable createLetVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asInitExpression) {
        LetVariable asVariable = PivotFactory.eINSTANCE.createLetVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull OCLExpression createMapLiteralExp(@NonNull MapType asType, @NonNull Iterable<MapLiteralPart> asParts) {
        MapLiteralExp mapLiteralExp = PivotFactory.eINSTANCE.createMapLiteralExp();
        Iterables.addAll(mapLiteralExp.getOwnedParts(), asParts);
        mapLiteralExp.setType(asType);
        mapLiteralExp.setIsRequired(true);
        return mapLiteralExp;
    }

    public @NonNull MapLiteralPart createMapLiteralPart(@NonNull OCLExpression asKey, @NonNull OCLExpression asValue) {
        MapLiteralPart mapLiteralPart = PivotFactory.eINSTANCE.createMapLiteralPart();
        mapLiteralPart.setOwnedKey(asKey);
        mapLiteralPart.setOwnedValue(asValue);
        return mapLiteralPart;
    }

    public @NonNull NavigationCallExp createNavigationCallExp(@NonNull OCLExpression asSourceExpression, @NonNull Property asProperty) {
        return PivotUtil.createNavigationCallExp(asSourceExpression, asProperty);
    }

    public @NonNull NullLiteralExp createNullLiteralExp() {
        NullLiteralExp asNull = PivotFactory.eINSTANCE.createNullLiteralExp();
        asNull.setType(this.standardLibrary.getOclVoidType());
        asNull.setIsRequired(false);
        return asNull;
    }

    public @NonNull OperationCallExp createOperationCallExp(@NonNull OCLExpression asSourceExpression, @NonNull String opName, OCLExpression ... asArguments) {
        Type asType = ClassUtil.nonNullState(asSourceExpression.getType());
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(asType);
        int argumentCount = asArguments != null ? asArguments.length : 0;
        int bestMatches = -1;
        Operation bestOperation = null;
        for (Operation asOperation : completeClass.getOperations(FeatureFilter.SELECT_NON_STATIC, opName)) {
            List<@NonNull Parameter> asParameters = ClassUtil.nullFree(asOperation.getOwnedParameters());
            if (asParameters.size() != argumentCount || asArguments == null) continue;
            int exactMatches = 0;
            boolean gotOne = true;
            int i = 0;
            while (i < argumentCount) {
                Type asParameterType = ClassUtil.nonNullState(((TypedElement)asParameters.get(i)).getType());
                OCLExpression asArgument = asArguments[i];
                Type asArgumentType = asArgument.getType();
                if (asParameterType instanceof SelfType) {
                    if (asArgumentType.conformsTo(this.standardLibrary, asType) && asType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                } else {
                    if (!asArgumentType.conformsTo(this.standardLibrary, asParameterType)) {
                        gotOne = false;
                        break;
                    }
                    if (asParameterType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                }
                ++i;
            }
            if (!gotOne) continue;
            if (exactMatches > bestMatches) {
                bestMatches = exactMatches;
                bestOperation = asOperation;
                continue;
            }
            if (exactMatches <= bestMatches) continue;
            bestOperation = null;
        }
        if (bestMatches < 0) {
            throw new IllegalStateException("No match found for " + opName);
        }
        if (bestOperation == null) {
            throw new IllegalStateException("Ambiguous match found for " + opName);
        }
        return this.createOperationCallExp(asSourceExpression, bestOperation, asArguments != null ? Lists.newArrayList((Object[])asArguments) : null);
    }

    public @NonNull OperationCallExp createOperationCallExp(@Nullable OCLExpression asSourceExpression, @NonNull Operation asOperation, @Nullable List<@NonNull OCLExpression> asArguments) {
        OperationCallExp asOperationCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        asOperationCallExp.setOwnedSource(asSourceExpression);
        asOperationCallExp.setReferredOperation(asOperation);
        asOperationCallExp.setName(asOperation.getName());
        if (asArguments != null) {
            asOperationCallExp.getOwnedArguments().addAll(asArguments);
        }
        this.setOperationReturnType(asOperationCallExp, asOperation);
        return asOperationCallExp;
    }

    public @NonNull Package createPackage(@NonNull String name, @Nullable String nsPrefix, @Nullable String nsURI) {
        Package asPackage = PivotFactory.eINSTANCE.createPackage();
        asPackage.setName(name);
        if (nsPrefix != null) {
            asPackage.setNsPrefix(nsPrefix);
        }
        if (nsURI != null) {
            asPackage.setURI(nsURI);
        }
        return asPackage;
    }

    public @NonNull Parameter createParameter(@NonNull TypedElement typedElement) {
        String name = ClassUtil.nonNullState(typedElement.getName());
        Type type = ClassUtil.nonNullState(typedElement.getType());
        Parameter asParameter = PivotUtil.createParameter(name, type, typedElement.isIsRequired());
        return asParameter;
    }

    public @NonNull Parameter createParameter(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        return PivotUtil.createParameter(name, asType, isRequired);
    }

    @Deprecated
    public @NonNull ParameterVariable createParameterVariable(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        ParameterVariable asVariable = PivotFactory.eINSTANCE.createParameterVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        return asVariable;
    }

    public @NonNull ParameterVariable createParameterVariable(@NonNull Parameter asParameter) {
        ParameterVariable asParameterVariable = PivotFactory.eINSTANCE.createParameterVariable();
        asParameterVariable.setName(asParameter.getName());
        asParameterVariable.setType(asParameter.getType());
        asParameterVariable.setIsRequired(asParameter.isIsRequired());
        asParameterVariable.setRepresentedParameter(asParameter);
        return asParameterVariable;
    }

    public @NonNull PropertyCallExp createPropertyCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        return PivotUtil.createPropertyCallExp(asSource, asProperty);
    }

    public @NonNull RealLiteralExp createRealLiteralExp(@NonNull Number realSymbol) {
        RealLiteralExp asReal = PivotFactory.eINSTANCE.createRealLiteralExp();
        asReal.setRealSymbol(realSymbol);
        asReal.setType(this.standardLibrary.getRealType());
        asReal.setIsRequired(true);
        return asReal;
    }

    public @NonNull ResultVariable createResultVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asInitExpression) {
        ResultVariable asVariable = PivotFactory.eINSTANCE.createResultVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public @NonNull OCLExpression createShadowExp(@NonNull Class asClass, @NonNull Iterable<ShadowPart> asParts) {
        ShadowExp shadowExp = PivotFactory.eINSTANCE.createShadowExp();
        Iterables.addAll(shadowExp.getOwnedParts(), asParts);
        shadowExp.setType(asClass);
        shadowExp.setIsRequired(true);
        return shadowExp;
    }

    public @NonNull ShadowPart createShadowPart(@NonNull Property asProperty, @NonNull OCLExpression asValue) {
        ShadowPart shadowPart = PivotFactory.eINSTANCE.createShadowPart();
        shadowPart.setReferredProperty(asProperty);
        shadowPart.setType(asProperty.getType());
        shadowPart.setIsRequired(asProperty.isIsRequired());
        shadowPart.setOwnedInit(asValue);
        return shadowPart;
    }

    public @NonNull StringLiteralExp createStringLiteralExp(@NonNull String stringSymbol) {
        StringLiteralExp asString = PivotFactory.eINSTANCE.createStringLiteralExp();
        asString.setStringSymbol(stringSymbol);
        asString.setType(this.standardLibrary.getStringType());
        asString.setIsRequired(true);
        return asString;
    }

    public @NonNull TupleLiteralExp createTupleLiteralExp(@NonNull TupleType asType, @NonNull Iterable<TupleLiteralPart> asParts) {
        TupleLiteralExp tupleLiteralExp = PivotFactory.eINSTANCE.createTupleLiteralExp();
        Iterables.addAll(tupleLiteralExp.getOwnedParts(), asParts);
        tupleLiteralExp.setType(asType);
        tupleLiteralExp.setIsRequired(true);
        return tupleLiteralExp;
    }

    public @NonNull TupleLiteralPart createTupleLiteralPart(@NonNull String name, @NonNull Type asType, boolean isRequired, @NonNull OCLExpression asValue) {
        TupleLiteralPart tupleLiteralPart = PivotFactory.eINSTANCE.createTupleLiteralPart();
        tupleLiteralPart.setName(name);
        tupleLiteralPart.setType(asType);
        tupleLiteralPart.setIsRequired(isRequired);
        tupleLiteralPart.setOwnedInit(asValue);
        return tupleLiteralPart;
    }

    public @NonNull TypeExp createTypeExp(@NonNull Type type) {
        assert (type instanceof Class);
        TypeExp asTypeExp = PivotFactory.eINSTANCE.createTypeExp();
        asTypeExp.setIsRequired(true);
        asTypeExp.setReferredType(type);
        asTypeExp.setName(type.getName());
        Class metaType = this.standardLibrary.getMetaclass(type);
        asTypeExp.setType(metaType);
        asTypeExp.setTypeValue(type);
        return asTypeExp;
    }

    public @NonNull UnlimitedNaturalLiteralExp createUnlimitedNaturalLiteralExp(@NonNull Number unlimitedNaturalSymbol) {
        UnlimitedNaturalLiteralExp asUnlimitedNatural = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
        asUnlimitedNatural.setUnlimitedNaturalSymbol(unlimitedNaturalSymbol);
        asUnlimitedNatural.setType(this.standardLibrary.getUnlimitedNaturalType());
        asUnlimitedNatural.setIsRequired(true);
        return asUnlimitedNatural;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        Variable asVariable = PivotUtil.createVariable(name, asInitExpression);
        return asVariable;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        Variable asVariable = PivotUtil.createVariable(name, asType, isRequired, asInitExpression);
        return asVariable;
    }

    @Deprecated
    public @NonNull Variable createVariable(@NonNull TypedElement typedElement) {
        String name = ClassUtil.nonNullState(typedElement.getName());
        Type type = ClassUtil.nonNullState(typedElement.getType());
        Variable asVariable = PivotUtil.createVariable(name, type, typedElement.isIsRequired(), null);
        return asVariable;
    }

    public @NonNull VariableExp createVariableExp(@NonNull VariableDeclaration asVariable) {
        VariableExp asVariableExp = PivotUtil.createVariableExp(asVariable);
        return asVariableExp;
    }

    public @NonNull Class getDataTypeClass() {
        return ClassUtil.nonNullState(this.metamodelManager.getASClass("DataType"));
    }

    public @NonNull Property getDataTypeValueProperty() {
        return ClassUtil.nonNullState(NameUtil.getNameable(this.getDataTypeClass().getOwnedProperties(), "value"));
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    public <T extends EObject> void refreshList(@Nullable List<? super T> oldElements, @Nullable List<? extends T> newElements) {
        PivotUtilInternal.refreshList(oldElements, newElements);
    }

    public void refreshName(@NonNull NamedElement pivotNamedElement, @Nullable String newName) {
        String oldName = pivotNamedElement.getName();
        if (!(newName == oldName || newName != null && newName.equals(oldName))) {
            pivotNamedElement.setName(newName);
        }
    }

    public void refreshNsURI(@NonNull Package pivotPackage, String newNsURI) {
        String oldNsURI = pivotPackage.getURI();
        if (!(newNsURI == oldNsURI || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotPackage.setURI(newNsURI);
        }
    }

    public void rewriteSafeNavigations(@NonNull Element asTree) {
        List<@NonNull CallExp> unsafeCallExps = null;
        if (asTree instanceof CallExp) {
            unsafeCallExps = this.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)asTree);
        }
        TreeIterator tit = asTree.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof CallExp)) continue;
            unsafeCallExps = this.rewriteUnsafeCallExp_Gather(unsafeCallExps, (CallExp)eObject);
        }
        if (unsafeCallExps != null) {
            Class oclAnyType = this.standardLibrary.getOclAnyType();
            Operation oclEqualsOperation = NameUtil.getNameable(oclAnyType.getOwnedOperations(), "=");
            assert (oclEqualsOperation != null);
            Class collectionType = this.standardLibrary.getCollectionType();
            Operation excludingOperation = NameUtil.getNameable(collectionType.getOwnedOperations(), "excluding");
            assert (excludingOperation != null);
            for (CallExp unsafeCallExp : unsafeCallExps) {
                OCLExpression source = unsafeCallExp.getOwnedSource();
                assert (source != null);
                if (source.getType() instanceof CollectionType) {
                    this.rewriteUnsafeCollectionCallExp(this.metamodelManager, excludingOperation, unsafeCallExp);
                    continue;
                }
                this.rewriteUnsafeObjectCallExp(this.metamodelManager, oclEqualsOperation, unsafeCallExp);
            }
        }
    }

    private @Nullable List<@NonNull CallExp> rewriteUnsafeCallExp_Gather(@Nullable List<@NonNull CallExp> unsafeCallExps, @NonNull CallExp callExp) {
        OCLExpression source = callExp.getOwnedSource();
        if (source != null && callExp.isIsSafe()) {
            if (unsafeCallExps == null) {
                unsafeCallExps = new ArrayList<CallExp>();
            }
            unsafeCallExps.add(callExp);
        }
        return unsafeCallExps;
    }

    private void rewriteUnsafeCollectionCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation excludingOperation, @NonNull CallExp unsafeCollectionCallExp) {
        unsafeCollectionCallExp.setIsSafe(false);
        EObject eContainer = unsafeCollectionCallExp.eContainer();
        EReference eContainmentFeature = unsafeCollectionCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer(unsafeCollectionCallExp);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp safeCollectionCallExp = this.createOperationCallExp((OCLExpression)unsafeCollectionCallExp, excludingOperation, Collections.singletonList(nullExpression));
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeCollectionCallExp);
    }

    private void rewriteUnsafeObjectCallExp(@NonNull PivotMetamodelManager metamodelManager, @NonNull Operation oclEqualsOperation, @NonNull CallExp unsafeObjectCallExp) {
        unsafeObjectCallExp.setIsSafe(false);
        EObject eContainer = unsafeObjectCallExp.eContainer();
        EReference eContainmentFeature = unsafeObjectCallExp.eContainmentFeature();
        PivotUtilInternal.resetContainer(unsafeObjectCallExp);
        OCLExpression oldSourceExpression = unsafeObjectCallExp.getOwnedSource();
        assert (oldSourceExpression != null);
        LetVariable unsafeSourceVariable = this.createLetVariable("unsafe", oldSourceExpression);
        VariableExp unsafeSourceExpression1 = this.createVariableExp(unsafeSourceVariable);
        unsafeObjectCallExp.setOwnedSource(unsafeSourceExpression1);
        VariableExp unsafeSourceExpression2 = this.createVariableExp(unsafeSourceVariable);
        NullLiteralExp nullExpression = metamodelManager.createNullLiteralExp();
        OperationCallExp isUnsafeExpression = this.createOperationCallExp((OCLExpression)unsafeSourceExpression2, oclEqualsOperation, Collections.singletonList(nullExpression));
        NullLiteralExp thenExpression = metamodelManager.createNullLiteralExp();
        IfExp safeObjectCallExp = metamodelManager.createIfExp((OCLExpression)isUnsafeExpression, (OCLExpression)thenExpression, (OCLExpression)unsafeObjectCallExp);
        LetExp safeExp = this.createLetExp(unsafeSourceVariable, safeObjectCallExp);
        eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)safeExp);
    }

    @Deprecated
    public void setBehavioralType(@NonNull TypedElement targetElement, @NonNull TypedElement sourceElement) {
        if (!sourceElement.eIsProxy()) {
            Type type = PivotUtil.getType(sourceElement);
            if (type instanceof SelfType) {
                type = this.standardLibrary.getOclAnyType();
            }
            if (type.eIsProxy()) {
                type = null;
            }
            boolean isRequired = sourceElement.isIsRequired();
            this.setType(targetElement, type, isRequired);
        }
    }

    public void setContextVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull String selfVariableName, @Nullable Type contextType, @Nullable Type contextInstance) {
        Variable contextVariable = pivotSpecification.getOwnedContext();
        if (contextVariable == null) {
            @NonNull ParameterVariable nonNullContextVariable = PivotFactory.eINSTANCE.createParameterVariable();
            contextVariable = nonNullContextVariable;
            pivotSpecification.setOwnedContext(contextVariable);
            if (contextType == null) {
                contextType = this.standardLibrary.getOclVoidType();
            }
        }
        this.refreshName(contextVariable, selfVariableName);
        this.setType(contextVariable, contextType, contextVariable.isIsRequired(), contextInstance);
    }

    public void setOperationReturnType(@NonNull CallExp asCallExp, @NonNull Operation asOperation) {
        LibraryIterationOrOperation implementation;
        OCLExpression asSourceExpression = asCallExp.getOwnedSource();
        Type sourceType = asSourceExpression != null ? asSourceExpression.getType() : null;
        Type returnType = null;
        Type formalType = asOperation.getType();
        boolean returnIsRequired = asOperation.isIsRequired();
        Object returnValue = null;
        if (formalType != null && sourceType != null) {
            returnType = TemplateParameterSubstitutionVisitor.specializeType(formalType, asCallExp, (EnvironmentFactoryInternal)this.environmentFactory, sourceType, null);
        }
        if ((implementation = (LibraryIterationOrOperation)asOperation.getImplementation()) != null) {
            returnType = implementation.resolveReturnType(this.environmentFactory, asCallExp, returnType);
            returnIsRequired = implementation.resolveReturnNullity(this.environmentFactory, asCallExp, returnIsRequired);
            returnValue = implementation.resolveReturnValue(this.environmentFactory, asCallExp);
        } else assert (!asOperation.isIsTypeof());
        this.setType(asCallExp, returnType, returnIsRequired, (Type)returnValue);
    }

    public void setType(@NonNull OCLExpression asExpression, Type type, boolean isRequired, @Nullable Type typeValue) {
        Type primaryTypeValue;
        this.setType(asExpression, type, isRequired);
        Type type2 = primaryTypeValue = typeValue != null ? this.metamodelManager.getPrimaryType(typeValue) : null;
        if (primaryTypeValue != asExpression.getTypeValue()) {
            asExpression.setTypeValue(primaryTypeValue);
        }
    }

    public void setType(@NonNull VariableDeclaration asVariable, Type type, boolean isRequired, @Nullable Type typeValue) {
        Type primaryTypeValue;
        this.setType(asVariable, type, isRequired);
        Type type2 = primaryTypeValue = typeValue != null ? this.metamodelManager.getPrimaryType(typeValue) : null;
        if (primaryTypeValue != asVariable.getTypeValue()) {
            asVariable.setTypeValue(primaryTypeValue);
        }
    }

    public void setType(@NonNull TypedElement asTypedElement, Type type, boolean isRequired) {
        boolean wasRequired;
        Type primaryType;
        Type type2 = primaryType = type != null ? this.metamodelManager.getPrimaryType(type) : null;
        if (primaryType != asTypedElement.getType()) {
            asTypedElement.setType(primaryType);
        }
        if ((wasRequired = asTypedElement.isIsRequired()) != isRequired) {
            asTypedElement.setIsRequired(isRequired);
        }
        if (primaryType != null) {
            PivotUtil.debugWellContainedness(primaryType);
        }
    }
}

