/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell.decorator;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PaddingDecorator
extends CellPainterWrapper {
    private final int topPadding;
    private final int rightPadding;
    private final int bottomPadding;
    private final int leftPadding;
    private final boolean paintBg;

    public PaddingDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, 2);
    }

    public PaddingDecorator(ICellPainter interiorPainter, boolean paintBg) {
        this(interiorPainter, 2, paintBg);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int padding) {
        this(interiorPainter, padding, padding, padding, padding);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int padding, boolean paintBg) {
        this(interiorPainter, padding, padding, padding, padding, paintBg);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int topPadding, int rightPadding, int bottomPadding, int leftPadding) {
        this(interiorPainter, topPadding, rightPadding, bottomPadding, leftPadding, true);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int topPadding, int rightPadding, int bottomPadding, int leftPadding, boolean paintBg) {
        super(interiorPainter);
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
        this.paintBg = paintBg;
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return GUIHelper.convertHorizontalPixelToDpi(this.leftPadding, configRegistry) + super.getPreferredWidth(cell, gc, configRegistry) + GUIHelper.convertHorizontalPixelToDpi(this.rightPadding, configRegistry);
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return GUIHelper.convertVerticalPixelToDpi(this.topPadding, configRegistry) + super.getPreferredHeight(cell, gc, configRegistry) + GUIHelper.convertVerticalPixelToDpi(this.bottomPadding, configRegistry);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle interiorBounds = this.getInteriorBounds(adjustedCellBounds, configRegistry);
        if (this.paintBg) {
            Color originalBg = gc.getBackground();
            Color cellStyleBackground = this.getBackgroundColor(cell, configRegistry);
            gc.setBackground(cellStyleBackground != null ? cellStyleBackground : originalBg);
            gc.fillRectangle(adjustedCellBounds);
            gc.setBackground(originalBg);
        }
        if (interiorBounds.width > 0 && interiorBounds.height > 0) {
            super.paintCell(cell, gc, interiorBounds, configRegistry);
        }
    }

    public Rectangle getInteriorBounds(Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        return new Rectangle(adjustedCellBounds.x + GUIHelper.convertHorizontalPixelToDpi(this.leftPadding, configRegistry), adjustedCellBounds.y + GUIHelper.convertVerticalPixelToDpi(this.topPadding, configRegistry), adjustedCellBounds.width - GUIHelper.convertHorizontalPixelToDpi(this.leftPadding, configRegistry) - GUIHelper.convertHorizontalPixelToDpi(this.rightPadding, configRegistry), adjustedCellBounds.height - GUIHelper.convertVerticalPixelToDpi(this.topPadding, configRegistry) - GUIHelper.convertVerticalPixelToDpi(this.bottomPadding, configRegistry));
    }

    protected Color getBackgroundColor(ILayerCell cell, IConfigRegistry configRegistry) {
        return CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }

    @Override
    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        HorizontalAlignmentEnum horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        int horizontalAlignmentPadding = 0;
        if (horizontalAlignment == HorizontalAlignmentEnum.LEFT) {
            horizontalAlignmentPadding = GUIHelper.convertHorizontalPixelToDpi(this.leftPadding, configRegistry);
        } else if (horizontalAlignment == HorizontalAlignmentEnum.CENTER) {
            horizontalAlignmentPadding = GUIHelper.convertHorizontalPixelToDpi(this.leftPadding, configRegistry) / 2;
        }
        VerticalAlignmentEnum verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        int verticalAlignmentPadding = 0;
        if (verticalAlignment == VerticalAlignmentEnum.TOP) {
            verticalAlignmentPadding = GUIHelper.convertVerticalPixelToDpi(this.topPadding, configRegistry);
        } else if (verticalAlignment == VerticalAlignmentEnum.MIDDLE) {
            verticalAlignmentPadding = GUIHelper.convertVerticalPixelToDpi(this.topPadding, configRegistry) / 2;
        }
        return super.getCellPainterAt(x - horizontalAlignmentPadding, y - verticalAlignmentPadding, cell, gc, adjustedCellBounds, configRegistry);
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }
}

