/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer;

import java.util.TreeSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.AbstractSerializerAdapter;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

public class WsSerializerAdapter
extends AbstractSerializerAdapter {
    public WsSerializerAdapter(JaxWsWorkspaceResource resource) {
        super(resource);
    }

    @Override
    protected boolean isAnnotationRequired() {
        return true;
    }

    @Override
    protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
        assert (this.getTarget() instanceof IWebService);
        return this.createIAnnotation((IWebService)this.getTarget(), this.resource().javaModel());
    }

    protected IAnnotation<? extends IJavaElement> createIAnnotation(IWebService ws, IJavaModel javaModel) throws JavaModelException {
        ContractChecker.nullCheckParam((Object)ws, (String)"ws");
        ContractChecker.nullCheckParam((Object)javaModel, (String)"javaModel");
        IType type = this.findType(ws, ws.getImplementation());
        if (type == null) {
            return null;
        }
        TreeSet<IParamValuePair> paramValuePairs = this.createParamValueSortedTreeSet();
        IServiceEndpointInterface sei = ws.getServiceEndpoint();
        if (sei != null) {
            if (sei.isImplicit()) {
                String seiName = sei.getName();
                if (!JaxWsUtils.getDefaultPorttypeName((String)sei.getImplementation()).equals(seiName)) {
                    paramValuePairs.add(this.createParamValue("name", ws.getServiceEndpoint().getName()));
                }
            } else {
                paramValuePairs.add(this.createParamValue("endpointInterface", ws.getServiceEndpoint().getImplementation()));
            }
        }
        if (ws.getName() != null && !ws.getName().equals(JaxWsUtils.getDefaultServiceName((String)ws.getImplementation()))) {
            paramValuePairs.add(this.createParamValue("serviceName", ws.getName()));
        }
        if (ws.getPortName() != null && !ws.getPortName().equals(JaxWsUtils.getDefaultPortName((String)ws.getImplementation()))) {
            paramValuePairs.add(this.createParamValue("portName", ws.getPortName()));
        }
        if (ws.getTargetNamespace() != null && !ws.getTargetNamespace().equals(JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)type.getPackageFragment().getElementName()))) {
            paramValuePairs.add(this.createParamValue("targetNamespace", ws.getTargetNamespace()));
        }
        if (ws.getWsdlLocation() != null) {
            paramValuePairs.add(this.createParamValue("wsdlLocation", ws.getWsdlLocation()));
        }
        return AnnotationFactory.createAnnotation((String)"javax.jws.WebService", (IJavaElement)type, paramValuePairs);
    }
}

