/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language.settings.providers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class LanguageSettingsProviderAssociationManager {
    private static final String PROVIDER_ASSOCIATION_EXTENSION_POINT_SIMPLE_ID = "LanguageSettingsProviderAssociation";
    private static final String ELEM_ID_ASSOCIATION = "id-association";
    private static final String ELEM_CLASS_ASSOCIATION = "class-association";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_PAGE = "page";
    private static final String ATTR_UI_CLEAR_ENTRIES = "ui-clear-entries";
    private static final String ATTR_UI_EDIT_ENTRIES = "ui-edit-entries";
    private static boolean isLoaded = false;
    private static List<URL> loadedIcons = new ArrayList<URL>();
    private static Map<String, URL> fImagesUrlById = new HashMap<String, URL>();
    private static Map<String, URL> fImagesUrlByClass = new HashMap<String, URL>();
    private static List<String> fRegirestedIds = new ArrayList<String>();
    private static List<String> fRegisteredClasses = new ArrayList<String>();
    private static Map<String, Map<String, String>> fAssociationsById = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> fAssociationsByClass = new HashMap<String, Map<String, String>>();

    private static void loadExtensions() {
        if (isLoaded) {
            return;
        }
        isLoaded = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.ui", PROVIDER_ASSOCIATION_EXTENSION_POINT_SIMPLE_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                String extensionID = ext.getUniqueIdentifier();
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                    if (cfgEl.getName().equals(ELEM_ID_ASSOCIATION)) {
                        String id = cfgEl.getAttribute(ATTR_ID);
                        url = LanguageSettingsProviderAssociationManager.getIconUrl(cfgEl);
                        fImagesUrlById.put(id, url);
                        fRegirestedIds.add(id);
                        HashMap<String, String> properties = new HashMap<String, String>();
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_PAGE, cfgEl.getAttribute(ATTR_PAGE));
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_UI_CLEAR_ENTRIES, cfgEl.getAttribute(ATTR_UI_CLEAR_ENTRIES));
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_UI_EDIT_ENTRIES, cfgEl.getAttribute(ATTR_UI_EDIT_ENTRIES));
                        fAssociationsById.put(id, properties);
                    } else if (cfgEl.getName().equals(ELEM_CLASS_ASSOCIATION)) {
                        String className = cfgEl.getAttribute(ATTR_CLASS);
                        url = LanguageSettingsProviderAssociationManager.getIconUrl(cfgEl);
                        fImagesUrlByClass.put(className, url);
                        String pageClass = cfgEl.getAttribute(ATTR_PAGE);
                        if (pageClass != null && pageClass.length() > 0) {
                            fRegisteredClasses.add(className);
                        }
                        HashMap<String, String> properties = new HashMap<String, String>();
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_PAGE, cfgEl.getAttribute(ATTR_PAGE));
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_UI_CLEAR_ENTRIES, cfgEl.getAttribute(ATTR_UI_CLEAR_ENTRIES));
                        LanguageSettingsProviderAssociationManager.putNotEmpty(properties, ATTR_UI_EDIT_ENTRIES, cfgEl.getAttribute(ATTR_UI_EDIT_ENTRIES));
                        fAssociationsByClass.put(className, properties);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static void putNotEmpty(Map<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    private static URL getIconUrl(IConfigurationElement config) {
        URL url = null;
        try {
            URL pluginInstallUrl;
            String iconName = config.getAttribute(ATTR_ICON);
            if (iconName != null && loadedIcons.contains(url = new URL(pluginInstallUrl = Platform.getBundle((String)config.getDeclaringExtension().getContributor().getName()).getEntry("/"), iconName))) {
                return url;
            }
        }
        catch (MalformedURLException e) {
            CUIPlugin.log(e);
        }
        loadedIcons.add(url);
        if (url != null) {
            CDTSharedImages.register(url);
        }
        return url;
    }

    public static URL getImageUrl(String providerId) {
        LanguageSettingsProviderAssociationManager.loadExtensions();
        return fImagesUrlById.get(providerId);
    }

    private static ICOptionPage createOptionsPageById(String providerId) {
        IExtensionRegistry registry;
        IExtensionPoint extension;
        LanguageSettingsProviderAssociationManager.loadExtensions();
        if (fRegirestedIds.contains(providerId) && (extension = (registry = Platform.getExtensionRegistry()).getExtensionPoint("org.eclipse.cdt.ui", PROVIDER_ASSOCIATION_EXTENSION_POINT_SIMPLE_ID)) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    String extensionID = ext.getUniqueIdentifier();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String pageClass;
                        String id;
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_ID_ASSOCIATION) && providerId.equals(id = cfgEl.getAttribute(ATTR_ID)) && (pageClass = cfgEl.getAttribute(ATTR_PAGE)) != null && pageClass.trim().length() > 0) {
                            ICOptionPage page = (ICOptionPage)cfgEl.createExecutableExtension(ATTR_PAGE);
                            return page;
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CUIPlugin.log("Cannot load LanguageSettingsProviderAssociation extension " + ext.getUniqueIdentifier(), e);
                }
                ++n2;
            }
        }
        return null;
    }

    private static ICOptionPage createOptionsPageByClass(String providerClassName) {
        IExtensionRegistry registry;
        IExtensionPoint extension;
        LanguageSettingsProviderAssociationManager.loadExtensions();
        if (fRegisteredClasses.contains(providerClassName) && (extension = (registry = Platform.getExtensionRegistry()).getExtensionPoint("org.eclipse.cdt.ui", PROVIDER_ASSOCIATION_EXTENSION_POINT_SIMPLE_ID)) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    String extensionID = ext.getUniqueIdentifier();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String pageClass;
                        String className;
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_CLASS_ASSOCIATION) && providerClassName.equals(className = cfgEl.getAttribute(ATTR_CLASS)) && (pageClass = cfgEl.getAttribute(ATTR_PAGE)) != null && pageClass.trim().length() > 0) {
                            ICOptionPage page = (ICOptionPage)cfgEl.createExecutableExtension(ATTR_PAGE);
                            return page;
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CUIPlugin.log("Cannot load LanguageSettingsProviderAssociation extension " + ext.getUniqueIdentifier(), e);
                }
                ++n2;
            }
        }
        return null;
    }

    public static URL getImage(Class<? extends ILanguageSettingsProvider> providerClass) {
        URL url = null;
        Class<? extends ILanguageSettingsProvider> c = providerClass;
        block0: while (c != null) {
            url = LanguageSettingsProviderAssociationManager.getImageURL(c);
            if (url != null) break;
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                url = LanguageSettingsProviderAssociationManager.getImageURL(i);
                if (url != null) break block0;
                ++n2;
            }
            c = c.getSuperclass();
        }
        return url;
    }

    private static URL getImageURL(Class<?> clazz) {
        String className = clazz.getCanonicalName();
        for (Map.Entry<String, URL> entry : fImagesUrlByClass.entrySet()) {
            if (!entry.getKey().equals(className)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ICOptionPage createOptionsPage(ILanguageSettingsProvider provider) {
        Class<?> clazz;
        String id = provider.getId();
        ICOptionPage optionsPage = LanguageSettingsProviderAssociationManager.createOptionsPageById(id);
        if (optionsPage != null) {
            return optionsPage;
        }
        Class<?> c = clazz = provider.getClass();
        block0: while (c != null) {
            optionsPage = LanguageSettingsProviderAssociationManager.createOptionsPageByClass(c);
            if (optionsPage != null) break;
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                optionsPage = LanguageSettingsProviderAssociationManager.createOptionsPageByClass(i);
                if (optionsPage != null) break block0;
                ++n2;
            }
            c = c.getSuperclass();
        }
        return optionsPage;
    }

    private static ICOptionPage createOptionsPageByClass(Class<?> clazz) {
        ICOptionPage optionsPage = null;
        String className = clazz.getCanonicalName();
        if (fRegisteredClasses.contains(className)) {
            optionsPage = LanguageSettingsProviderAssociationManager.createOptionsPageByClass(className);
        }
        return optionsPage;
    }

    private static boolean getBooleanAttribute(ILanguageSettingsProvider provider, String attr) {
        LanguageSettingsProviderAssociationManager.loadExtensions();
        String id = provider.getId();
        Map<String, String> properties = fAssociationsById.get(id);
        if (properties != null) {
            return Boolean.parseBoolean(properties.get(attr));
        }
        Class<?> c = provider.getClass();
        while (c != null) {
            String className = c.getCanonicalName();
            properties = fAssociationsByClass.get(className);
            if (properties != null) {
                return Boolean.parseBoolean(properties.get(attr));
            }
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                String interfaceName = i.getCanonicalName();
                properties = fAssociationsByClass.get(interfaceName);
                if (properties != null) {
                    return Boolean.parseBoolean(properties.get(attr));
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isAllowedToEditEntries(ILanguageSettingsProvider provider) {
        return LanguageSettingsProviderAssociationManager.getBooleanAttribute(provider, ATTR_UI_EDIT_ENTRIES);
    }

    public static boolean isAllowedToClear(ILanguageSettingsProvider provider) {
        return LanguageSettingsProviderAssociationManager.getBooleanAttribute(provider, ATTR_UI_CLEAR_ENTRIES);
    }
}

