/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class OneOrMorePath
extends Path {
    private final Path path;

    public OneOrMorePath(Resource id, Resource path, ShapeSource shapeSource) {
        super(id);
        this.path = Path.buildPath(shapeSource, path);
    }

    public OneOrMorePath(Resource id, Path path) {
        super(id);
        this.path = path;
    }

    public String toString() {
        return "OneOrMorePath{ " + String.valueOf(this.path) + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.ONE_OR_MORE_PATH, this.path.getId(), new Resource[0]);
        this.path.toModel(this.path.getId(), null, model, cycleDetection);
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        List<StatementMatcher.Variable<Value>> variables = List.of(new StatementMatcher.Variable<String>("subject"), new StatementMatcher.Variable<String>("value"));
        SparqlFragment targetQueryFragment = this.getTargetQueryFragment(variables.get(0), variables.get(1), connectionsGroup.getRdfsSubClassOfReasoner(), new StatementMatcher.StableRandomVariableProvider(), Set.of());
        PlanNode targetChainRetriever = new TargetChainRetriever(connectionsGroup, dataGraph, targetQueryFragment.getStatementMatchers(), List.of(), null, targetQueryFragment, variables, ConstraintComponent.Scope.propertyShape, true);
        targetChainRetriever = connectionsGroup.getCachedNodeFor(targetChainRetriever);
        if (planNodeWrapper != null) {
            targetChainRetriever = (PlanNode)planNodeWrapper.apply(targetChainRetriever);
        }
        return connectionsGroup.getCachedNodeFor(targetChainRetriever);
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper);
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public String toSparqlPathString() {
        assert (this.path.toSparqlPathString().equals(this.path.toSparqlPathString().trim()));
        if (this.path instanceof SimplePath || this.path instanceof AlternativePath || this.path instanceof SequencePath) {
            return this.path.toSparqlPathString() + "+";
        }
        return "(" + this.path.toSparqlPathString() + ")+";
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        inheritedVarNames = inheritedVarNames.isEmpty() ? Set.of(subject.getName()) : Sets.union(inheritedVarNames, Set.of(subject.getName()));
        String variablePrefix = this.getVariablePrefix(subject, object);
        String sparqlPathString = this.path.toSparqlPathString();
        StatementMatcher.Variable pathStart = new StatementMatcher.Variable(subject, variablePrefix + "start");
        StatementMatcher.Variable pathEnd = new StatementMatcher.Variable(subject, variablePrefix + "end");
        SparqlFragment targetQueryFragmentMiddle = this.path.getTargetQueryFragment(pathStart, pathEnd, rdfsSubClassOfReasoner, stableRandomVariableProvider, (Set<String>)inheritedVarNames);
        SparqlFragment targetQueryFragmentExactlyOne = this.path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner, stableRandomVariableProvider, (Set<String>)inheritedVarNames);
        String twoOrMore = subject.asSparqlVariable() + " (" + sparqlPathString + ")+ " + pathStart.asSparqlVariable() + " .\n" + targetQueryFragmentMiddle.getFragment() + "\n" + pathEnd.asSparqlVariable() + " (" + sparqlPathString + ")* " + object.asSparqlVariable() + " .\n";
        SparqlFragment twoOrMoreBgp = SparqlFragment.bgp(List.of(), twoOrMore, targetQueryFragmentMiddle.getStatementMatchers());
        Sets.SetView temp = inheritedVarNames;
        return SparqlFragment.union(List.of(targetQueryFragmentExactlyOne, twoOrMoreBgp), (arg_0, arg_1, arg_2, arg_3, arg_4) -> OneOrMorePath.lambda$getTargetQueryFragment$1(targetQueryFragmentExactlyOne, targetQueryFragmentMiddle, pathStart, subject, sparqlPathString, (Set)temp, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneOrMorePath that = (OneOrMorePath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private static /* synthetic */ Stream lambda$getTargetQueryFragment$1(SparqlFragment targetQueryFragmentExactlyOne, SparqlFragment targetQueryFragmentMiddle, StatementMatcher.Variable pathStart, StatementMatcher.Variable subject, String sparqlPathString, Set temp, ConnectionsGroup connectionsGroup, Resource[] dataGraph, Path path, StatementMatcher currentStatementMatcher, List currentStatements) {
        Stream<EffectiveTarget.SubjectObjectAndMatcher> statementsAndMatcherStream1 = targetQueryFragmentExactlyOne.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements).filter(EffectiveTarget.SubjectObjectAndMatcher::hasStatements);
        Stream<EffectiveTarget.SubjectObjectAndMatcher> peek = targetQueryFragmentMiddle.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements).filter(EffectiveTarget.SubjectObjectAndMatcher::hasStatements).map(a -> {
            SailConnection baseConnection = connectionsGroup.getBaseConnection();
            String subjectName = a.getStatementMatcher().getSubjectName();
            assert (subjectName.equals(pathStart.getName()));
            String query = "select distinct " + subject.asSparqlVariable() + " where {\n" + subject.asSparqlVariable() + " (" + sparqlPathString + ")+ " + pathStart.asSparqlVariable() + "\n}";
            TupleExpr tupleExpr = SparqlQueryParserCache.get(query);
            ArrayList<EffectiveTarget.SubjectObjectAndMatcher.SubjectObject> statements = new ArrayList<EffectiveTarget.SubjectObjectAndMatcher.SubjectObject>();
            for (EffectiveTarget.SubjectObjectAndMatcher.SubjectObject statement : a.getStatements()) {
                CloseableIteration<? extends BindingSet> evaluate = baseConnection.evaluate(tupleExpr, PlanNodeHelper.asDefaultGraphDataset(dataGraph), new SingletonBindingSet(subjectName, statement.getSubject()), true);
                try {
                    while (evaluate.hasNext()) {
                        BindingSet next = (BindingSet)evaluate.next();
                        statements.add(new EffectiveTarget.SubjectObjectAndMatcher.SubjectObject((Resource)next.getValue(subject.getName()), null));
                    }
                }
                finally {
                    if (evaluate == null) continue;
                    evaluate.close();
                }
            }
            StatementMatcher statementMatcher = new StatementMatcher(subject, null, null, path, temp);
            EffectiveTarget.SubjectObjectAndMatcher effectiveTarget = new EffectiveTarget.SubjectObjectAndMatcher(statements, statementMatcher);
            return effectiveTarget;
        });
        return Stream.concat(statementsAndMatcherStream1, peek);
    }
}

