/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CorrelationSignificanceEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public CorrelationSignificanceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return null;
        }
        if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            Object corr = matrix.getAttribute("corr");
            if (corr instanceof PearsonsCorrelation) {
                PearsonsCorrelation pcorr = (PearsonsCorrelation)corr;
                RealMatrix realMatrix = pcorr.getCorrelationPValues();
                return new Matrix(realMatrix.getData());
            }
            throw new IOException("Correlation pvalues are only available for Pearsons and Spearmans correlations");
        }
        throw new IOException("matrix parameter expected for transpose function");
    }
}

