/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Book;
import ee.jakarta.tck.nosql.factories.BookListSupplier;
import java.util.List;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The query execution exploring records")
public class SelectRecordTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should insert book and select with no conditions")
    void shouldInsertBookAndSelectWithNoConditions(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            List result = this.template.select(Book.class).result();
            SoftAssertions.assertSoftly(soft -> ((ListAssert)soft.assertThat(result).isNotEmpty()).hasSize(books.size()));
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should select book by title")
    void shouldSelectBookByTitle(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            List result = this.template.select(Book.class).where("title").eq((Object)books.get(0).title()).result();
            SoftAssertions.assertSoftly(soft -> ((ListAssert)soft.assertThat(result).isNotEmpty()).allMatch(book -> book.title().equals(((Book)books.get(0)).title())));
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should select book with 'like' condition")
    void shouldSelectBookWithLikeCondition(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            List result = this.template.select(Book.class).where("title").like(books.get(0).title()).result();
            SoftAssertions.assertSoftly(soft -> ((ListAssert)soft.assertThat(result).isNotEmpty()).allMatch(book -> book.title().contains(((Book)books.get(0)).title())));
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should select book by genre")
    void shouldSelectBookByGenre(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            List result = this.template.select(Book.class).where("genre").eq((Object)books.get(0).genre()).result();
            SoftAssertions.assertSoftly(soft -> ((ListAssert)soft.assertThat(result).isNotEmpty()).allMatch(book -> book.genre().equals(((Book)books.get(0)).genre())));
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }
}

