/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.testing.RepeatedTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.Exceptions;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public abstract class TestedWorkspace
extends TestWatcher {
    private String name;
    private final ProjectOpenedOrClosedListener closedProjectTaskProcessor;
    @Inject
    private IBuilderState builderState;

    protected TestedWorkspace(ProjectOpenedOrClosedListener closedProjectTaskProcessor) {
        this.closedProjectTaskProcessor = closedProjectTaskProcessor;
    }

    public Statement apply(Statement statement, Description description) {
        Statement result = super.apply(statement, description);
        RepeatedTest repeat = (RepeatedTest)description.getAnnotation(RepeatedTest.class);
        if (repeat == null) {
            repeat = description.getTestClass().getAnnotation(RepeatedTest.class);
        }
        if (repeat != null) {
            result = new RepeatedTest.Rule.RepeatedTestStatement(repeat.times(), result, description, false);
        }
        return result;
    }

    protected void starting(Description d) {
        IIntroManager introManager;
        this.name = d.getMethodName();
        this.assertEmptyIndex();
        Assert.assertEquals((long)0L, (long)IResourcesSetupUtil.root().getProjects().length);
        if (PlatformUI.isWorkbenchRunning() && (introManager = PlatformUI.getWorkbench().getIntroManager()).getIntro() != null) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = introManager.closeIntro(introManager.getIntro());
            });
        }
    }

    private void joinRemovedProjectsJob() {
        this.closedProjectTaskProcessor.joinRemoveProjectJob();
    }

    protected void finished(Description description) {
        super.finished(description);
        this.deleteAllProjects();
        this.build();
        this.assertEmptyIndex();
    }

    public void assertEmptyIndex() {
        ArrayList inIndex = Lists.newArrayList((Iterable)this.builderState.getAllResourceDescriptions());
        if (!inIndex.isEmpty()) {
            StringBuilder remaining = new StringBuilder();
            inIndex.forEach(desc -> {
                StringBuilder stringBuilder2 = remaining.append(desc.getURI()).append("\n");
            });
            Assert.assertEquals((String)remaining.toString(), (long)0L, (long)inIndex.size());
        }
    }

    public void build() {
        this.joinJobsBeforeBuild();
        IResourcesSetupUtil.waitForBuild();
    }

    public void joinJobsBeforeBuild() {
        this.joinRemovedProjectsJob();
    }

    public void cleanBuild() {
        try {
            this.joinJobsBeforeBuild();
            IResourcesSetupUtil.cleanBuild();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void fullBuild() {
        try {
            this.joinJobsBeforeBuild();
            IResourcesSetupUtil.fullBuild();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IFile createFile(IPath wsRelativePath, String content) {
        try {
            return IResourcesSetupUtil.createFile(wsRelativePath, content);
        }
        catch (Exception e) {
            return (IFile)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IFile createFile(String wsRelativePath, String content) {
        return this.createFile((IPath)new Path(wsRelativePath), content);
    }

    public String readFile(IFile file) {
        try {
            return IResourcesSetupUtil.fileToString(file);
        }
        catch (Exception e) {
            return (String)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void deleteAllProjects() {
        try {
            IResourcesSetupUtil.cleanWorkspace();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public String getTestName() {
        return this.name;
    }

    public IProject createProject() {
        return this.createProject(this.getTestName());
    }

    public void run(final IWorkspaceModifyOperation op) {
        try {
            new WorkspaceModifyOperation(op.getRule()){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, CoreException, InterruptedException {
                    op.accept(monitor);
                }
            }.run(this.monitor());
        }
        catch (InterruptedException | InvocationTargetException e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public <Result> Result run(final IWorkspaceModifyOperationWithResult<? extends Result> op) {
        try {
            return new WorkspaceModifyOperation(op.getRule()){
                Result result;

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, CoreException, InterruptedException {
                    this.result = op.compute(monitor);
                }

                protected Result getResult() throws InvocationTargetException, InterruptedException {
                    this.run(TestedWorkspace.this.monitor());
                    return this.result;
                }
            }.getResult();
        }
        catch (InterruptedException | InvocationTargetException e) {
            return (Result)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IProject createProject(String name) {
        try {
            return IResourcesSetupUtil.createProject(name);
        }
        catch (Exception e) {
            return (IProject)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void addNature(IProject project, String natureId) {
        try {
            IResourcesSetupUtil.addNature(project, natureId);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void addBuilder(IProject project, String builderId) {
        try {
            IResourcesSetupUtil.addBuilder(project, builderId);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void setReference(IProject from, IProject to) {
        try {
            IResourcesSetupUtil.setReference(from, to);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void removeReference(IProject from, IProject to) {
        try {
            IResourcesSetupUtil.removeReference(from, to);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void removeNature(IProject project, String natureId) {
        try {
            IResourcesSetupUtil.removeNature(project, natureId);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void removeBuilder(IProject project, String builderId) {
        try {
            IResourcesSetupUtil.removeBuilder(project, builderId);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IWorkspaceRoot root() {
        return IResourcesSetupUtil.root();
    }

    public IProgressMonitor monitor() {
        return IResourcesSetupUtil.monitor();
    }

    public void enableAutobuild(Runnable r) {
        this.withAutobuild(true, r);
    }

    public void disableAutobuild(Runnable r) {
        this.withAutobuild(false, r);
    }

    private void withAutobuild(boolean enabled, Runnable r) {
        boolean prev = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        if (prev == enabled) {
            r.run();
        } else {
            try {
                IResourcesSetupUtil.setAutobuild(enabled);
                r.run();
            }
            finally {
                IResourcesSetupUtil.setAutobuild(prev);
            }
        }
    }

    @FunctionalInterface
    public static interface IWorkspaceModifyOperation {
        public void accept(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

        default public ISchedulingRule getRule() {
            return IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        }
    }

    @FunctionalInterface
    public static interface IWorkspaceModifyOperationWithResult<Result> {
        public Result compute(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

        default public ISchedulingRule getRule() {
            return IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        }
    }
}

