/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import java.beans.Introspector;
import java.util.Locale;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.util.Strings;

public class PropertyUtil {
    public static String getPropertyName(JvmFeature feature) {
        if (feature.isStatic()) {
            return PropertyUtil.getPropertyName(feature, feature.getSimpleName(), 1, 2);
        }
        return PropertyUtil.getPropertyName(feature, feature.getSimpleName(), 0, 1);
    }

    public static String getPropertyName(JvmFeature feature, String methodName, int getterParams, int setterParams) {
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            String propertyName = PropertyUtil.getPropertyName(operation, methodName, "get", getterParams);
            if (propertyName != null) {
                return propertyName;
            }
            propertyName = PropertyUtil.getPropertyName(operation, methodName, "set", setterParams);
            if (propertyName != null) {
                return propertyName;
            }
            return PropertyUtil.getPropertyName(operation, methodName, "is", getterParams);
        }
        return null;
    }

    protected static String getPropertyName(JvmOperation operation, String methodName, String prefix, int params) {
        int prefixLength = prefix.length();
        if (PropertyUtil.startsWithPrefix(methodName, prefix, prefixLength) && operation.getParameters().size() == params) {
            return Introspector.decapitalize(methodName.substring(prefixLength));
        }
        return null;
    }

    protected static boolean startsWithPrefix(String methodName, String prefix, int prefixLength) {
        return methodName.length() > prefixLength && methodName.startsWith(prefix) && Character.isUpperCase(methodName.charAt(prefixLength));
    }

    public static String tryGetShorthandName(String fullName) {
        String name = null;
        if (fullName.startsWith("get") || fullName.startsWith("set")) {
            name = fullName.substring(3);
        } else if (fullName.startsWith("is")) {
            name = fullName.substring(2);
        } else {
            return null;
        }
        if (name.length() == 1) {
            return name.toLowerCase(Locale.ENGLISH);
        }
        if (name.length() > 1) {
            if (Character.isUpperCase(name.charAt(1))) {
                if (Character.isUpperCase(name.charAt(0))) {
                    return name;
                }
                return null;
            }
            return Strings.toFirstLower((String)name);
        }
        return null;
    }
}

