/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layerstack;

import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionBindings;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusRowHeaderStyleConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusRowResizeBindingsConfiguration;
import org.eclipse.papyrus.infra.nattable.dataprovider.RowIndexHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.RowLabelHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.layer.CustomDataLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.DefaultSizeUtils;

public class RowHeaderLayerStack
extends AbstractLayerTransform {
    public static final int DEFAULT_COLUMN_WIDTH = 150;
    public static final int DEFAULT_ROW_HEIGHT = DefaultSizeUtils.getDefaultCellWidth();
    protected final INattableModelManager tableManager;
    protected final CompositeLayer compositeLayer;
    protected final DataLayer indexDataLayer;
    protected final DataLayer labelDataLayer;
    private final AbstractLayer indexRowHeaderLayer;
    protected final AbstractLayer labelRowHeaderLayer;
    protected final IDataProvider indexDataProvider;
    protected final IDataProvider labelDataProvider;

    @Deprecated
    public RowHeaderLayerStack(IDataProvider dataProvider, BodyLayerStack bodyLayer) {
        CustomDataLayer dataLayer = new CustomDataLayer(dataProvider, 150, DEFAULT_ROW_HEIGHT);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)bodyLayer, new SelectionLayer((IUniqueIndexLayer)dataLayer), false);
        rowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowResizeBindingsConfiguration());
        rowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowHeaderStyleConfiguration());
        this.setUnderlyingLayer((ILayer)rowHeaderLayer);
        this.setRegionName("ROW_HEADER");
        this.labelRowHeaderLayer = null;
        this.indexRowHeaderLayer = null;
        this.tableManager = null;
        this.labelDataProvider = null;
        this.indexDataProvider = null;
        this.indexDataLayer = null;
        this.labelDataLayer = null;
        this.compositeLayer = null;
    }

    public RowHeaderLayerStack(BodyLayerStack bodyLayerStack, INattableModelManager tableManager) {
        this.tableManager = tableManager;
        this.indexDataProvider = this.createIndexDataProvider();
        this.labelDataProvider = this.createLabelDataProvider();
        this.indexDataLayer = this.createIndexDataLayer();
        this.labelDataLayer = this.createLabelDataLayer();
        this.indexRowHeaderLayer = this.createIndexRowHeaderLayer(bodyLayerStack, tableManager);
        this.labelRowHeaderLayer = this.createLabelRowHeaderLayer(bodyLayerStack, tableManager);
        this.indexRowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowHeaderStyleConfiguration());
        this.indexRowHeaderLayer.setRegionName("ROW_HEADER");
        this.labelRowHeaderLayer.setRegionName("ROW_HEADER");
        this.compositeLayer = new CompositeLayer(2, 1);
        this.compositeLayer.setChildLayer("ROW_HEADER", (ILayer)this.indexRowHeaderLayer, 0, 0);
        this.compositeLayer.setChildLayer("ROW_HEADER", (ILayer)this.labelRowHeaderLayer, 1, 0);
        this.indexRowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowResizeBindingsConfiguration());
        this.compositeLayer.addConfiguration((IConfiguration)new PapyrusRowResizeBindingsConfiguration());
        this.compositeLayer.setRegionName("ROW_HEADER");
        this.setUnderlyingLayer((ILayer)this.compositeLayer);
        this.setRegionName("ROW_HEADER");
    }

    protected IDataProvider createLabelDataProvider() {
        return new RowLabelHeaderDataProvider(this.tableManager);
    }

    protected IDataProvider createIndexDataProvider() {
        return new RowIndexHeaderDataProvider(this.tableManager);
    }

    public IDataProvider getLabelDataProvider() {
        return this.labelDataProvider;
    }

    public IDataProvider getIndexDataProvider() {
        return this.indexDataProvider;
    }

    protected AbstractLayer createIndexRowHeaderLayer(BodyLayerStack bodyLayerStack, INattableModelManager tableManager) {
        RowHeaderLayer layer = new RowHeaderLayer((IUniqueIndexLayer)this.getIndexDataLayer(), (ILayer)bodyLayerStack, bodyLayerStack.getSelectionLayer(), false);
        return layer;
    }

    protected AbstractLayer createLabelRowHeaderLayer(BodyLayerStack bodyLayerStack, INattableModelManager tableManager) {
        return new RowHeaderLayer((IUniqueIndexLayer)this.getLabelDataLayer(), (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer(), false);
    }

    public final AbstractLayer getIndexRowHeaderLayer() {
        return this.indexRowHeaderLayer;
    }

    public final AbstractLayer getLabelRowHeaderLayer() {
        return this.labelRowHeaderLayer;
    }

    protected DataLayer createLabelDataLayer() {
        return new CustomDataLayer(this.getLabelDataProvider(), 150, DEFAULT_ROW_HEIGHT);
    }

    public final DataLayer getLabelDataLayer() {
        return this.labelDataLayer;
    }

    protected DataLayer createIndexDataLayer() {
        return new CustomDataLayer(this.getIndexDataProvider(), 150, DEFAULT_ROW_HEIGHT);
    }

    public final DataLayer getIndexDataLayer() {
        return this.indexDataLayer;
    }

    public DataLayer getRowIndexDataLayer() {
        return this.indexDataLayer;
    }

    public DataLayer getRowLabelDataLayer() {
        return this.labelDataLayer;
    }

    public AbstractLayer getRowHeaderLayerIndex() {
        return this.indexRowHeaderLayer;
    }

    public AbstractLayer getRowHeaderLayerLabel() {
        return this.labelRowHeaderLayer;
    }

    public CompositeLayer getCompositeLayer() {
        return this.compositeLayer;
    }

    public static class CustomConfig
    extends DefaultSelectionBindings {
        protected void configureRowHeaderMouseClickBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), (IMouseAction)new MouseEditAction());
        }
    }
}

