/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.ObservableGradientData;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.GMFModelElement;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.GradientDataModelElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractEMFModelElementFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElementFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;

public class NotationModelElementFactory
extends AbstractModelElementFactory<AbstractModelElement> {
    protected AbstractModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        if (sourceElement instanceof ObservableGradientData) {
            ObservableGradientData gradientData = (ObservableGradientData)((Object)sourceElement);
            return new GradientDataModelElement(gradientData, gradientData.getOwner());
        }
        if (sourceElement instanceof GradientData) {
            return new GradientDataModelElement((GradientData)sourceElement);
        }
        View view = NotationHelper.findView((Object)sourceElement);
        if (view != null) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)view);
            return new GMFModelElement((EObject)view, domain);
        }
        Activator.log.warn("The selected element cannot be resolved to a GMF View");
        return null;
    }

    protected void updateModelElement(AbstractModelElement modelElement, Object newSourceElement) {
        if (modelElement instanceof GMFModelElement) {
            this.updateModelElement((GMFModelElement)modelElement, newSourceElement);
        } else if (modelElement instanceof GradientDataModelElement) {
            this.updateModelElement((GradientDataModelElement)modelElement, newSourceElement);
        }
    }

    void updateModelElement(GradientDataModelElement modelElement, Object newSourceElement) {
        if (newSourceElement instanceof ObservableGradientData) {
            ObservableGradientData ogd = (ObservableGradientData)((Object)newSourceElement);
            modelElement.sourceElement = ogd;
            modelElement.owner = ogd.getOwner();
        } else if (newSourceElement instanceof GradientData) {
            modelElement.sourceElement = (GradientData)newSourceElement;
            modelElement.owner = null;
        } else {
            throw new IllegalArgumentException("Cannot resolve GradientData selection: " + String.valueOf(newSourceElement));
        }
    }

    void updateModelElement(GMFModelElement modelElement, Object newSourceElement) {
        View view = NotationHelper.findView((Object)newSourceElement);
        if (view == null) {
            throw new IllegalArgumentException("Cannot resolve View selection: " + String.valueOf(newSourceElement));
        }
        AbstractEMFModelElementFactory.updateEMFModelElement((EMFModelElement)modelElement, (EObject)view);
    }
}

