/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.IPaletteDescription;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.IPapyrusPaletteConstant;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteDescription;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PapyrusPalettePreferences
implements IPapyrusPaletteConstant {
    public static List<IPaletteDescription> getWorkspaceExtendedPalettes() {
        ArrayList<IPaletteDescription> paletteDescriptions = new ArrayList<IPaletteDescription>();
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes();
        if (rootMemento == null) {
            return paletteDescriptions;
        }
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            IPaletteDescription description = PapyrusPaletteDescription.create(memento);
            paletteDescriptions.add(description);
            ++n2;
        }
        return paletteDescriptions;
    }

    public static List<IPaletteDescription> getLocalExtendedPalettes() {
        ArrayList<IPaletteDescription> paletteDescriptions = new ArrayList<IPaletteDescription>();
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalExtendedPalettes();
        if (rootMemento == null) {
            return paletteDescriptions;
        }
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            IPaletteDescription description = PapyrusPaletteDescription.create(memento);
            paletteDescriptions.add(description);
            ++n2;
        }
        return paletteDescriptions;
    }

    protected static IPreferenceStore getPreferenceStore() {
        return Activator.getInstance().getPreferenceStore();
    }

    protected static XMLMemento getExistingCustomizations() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("paletteCustomization");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"paletteCustomization");
        }
        catch (WorkbenchException e) {
            Activator.getInstance().logError("Impossible to read preferences", e);
            return null;
        }
    }

    protected static XMLMemento getLocalRedefinitions() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("paletteRedefinitions");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"paletteRedefinitions");
        }
        catch (WorkbenchException e) {
            Activator.getInstance().logError("Impossible to read preferences for palette local redefinitions", e);
            return null;
        }
    }

    public static IMemento registerLocalRedefinition(String paletteID, String path) {
        IMemento memento = PapyrusPalettePreferences.getPaletteRedefinitionNode(paletteID);
        if (memento != null) {
            PapyrusPalettePreferences.unregisterLocalRedefinition(paletteID);
        }
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        IMemento newMemento = rootMemento.createChild("paletteRedefinition");
        newMemento.putString("id", paletteID);
        newMemento.putString("path", path);
        PapyrusPalettePreferences.saveLocalRedefinitions(rootMemento);
        return newMemento;
    }

    public static void unregisterLocalRedefinition(String paletteID) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)"paletteRedefinitions");
        IMemento[] iMementoArray = rootMemento.getChildren("paletteRedefinition");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString("id").equals(paletteID)) {
                newRootMemento.putMemento(memento);
            }
            ++n2;
        }
        PapyrusPalettePreferences.saveLocalRedefinitions(newRootMemento);
    }

    private static void saveMemento(XMLMemento xmlMemento, String key) {
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save((Writer)writer);
            if (PapyrusPalettePreferences.getPreferenceStore() != null) {
                PapyrusPalettePreferences.getPreferenceStore().setValue(key, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("input/ouput exception", e);
        }
    }

    public static void saveLocalRedefinitions(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "paletteRedefinitions");
    }

    public static void saveCustomizations(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "paletteCustomization");
    }

    public static void saveWorkspaceExtendedPalettes(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "workspaceExtendedPaletteDefinition");
    }

    public static void saveLocalExtendedPalettes(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "extendedPaletteDefinition");
    }

    protected static IMemento getEditorMemento(XMLMemento rootMemento, String currentEditorClass) {
        IMemento[] editorsMementos;
        IMemento[] iMementoArray = editorsMementos = rootMemento.getChildren("editor");
        int n = editorsMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento editorMemento = iMementoArray[n2];
            String editorClass = editorMemento.getString("class");
            if (currentEditorClass.equals(editorClass)) {
                return editorMemento;
            }
            ++n2;
        }
        IMemento memento = rootMemento.createChild("editor");
        memento.putString("class", currentEditorClass);
        return memento;
    }

    public static IMemento getEditorHiddenPalettesMemento(IMemento editorMemento) {
        IMemento hiddenPaletteMemento = editorMemento.getChild("hiddenPalettes");
        if (hiddenPaletteMemento == null) {
            hiddenPaletteMemento = editorMemento.createChild("hiddenPalettes");
        }
        return hiddenPaletteMemento;
    }

    public static String getHiddenPalettes(IMemento hiddenPalettesMemento) {
        return hiddenPalettesMemento.getString("id");
    }

    public static String getPaletteRedefinition(String paletteID) {
        IMemento memento;
        if (paletteID == null) {
            Activator.log.debug("Trying to find preferences for a null palette identifier");
        }
        if ((memento = PapyrusPalettePreferences.getPaletteRedefinitionNode(paletteID)) != null) {
            return memento.getString("path");
        }
        return null;
    }

    private static IMemento getPaletteRedefinitionNode(String paletteID) {
        IMemento[] redefinitions;
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        IMemento[] iMementoArray = redefinitions = rootMemento.getChildren("paletteRedefinition");
        int n = redefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento redefinitionMemento = iMementoArray[n2];
            String paletteNodeID = redefinitionMemento.getString("id");
            if (paletteID.equals(paletteNodeID)) {
                return redefinitionMemento;
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getHiddenPalettesList(IMemento hiddenPalettesMemento) {
        String hiddenPalettes = hiddenPalettesMemento.getString("id");
        ArrayList<String> ids = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(hiddenPalettes != null ? hiddenPalettes : "", ";");
        while (tokenizer.hasMoreTokens()) {
            ids.add(tokenizer.nextToken());
        }
        return ids;
    }

    public static void changePaletteVisibility(String providerID, IEditorPart editorClass, boolean visible) {
        PapyrusPalettePreferences.changePaletteVisibility(providerID, PapyrusPalettePreferences.getEditorClassName(editorClass), visible);
    }

    protected static String getEditorClassName(IEditorPart editorClass) {
        return editorClass.getClass().getName();
    }

    public static void changePaletteVisibility(String providerID, String editorClass, boolean visible) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingCustomizations();
        IMemento editorMemento = PapyrusPalettePreferences.getEditorMemento(rootMemento, editorClass);
        IMemento hiddenPalettesMemento = PapyrusPalettePreferences.getEditorHiddenPalettesMemento(editorMemento);
        List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettesList(hiddenPalettesMemento);
        if (hiddenPalettes.contains(providerID) && visible) {
            hiddenPalettes.remove(providerID);
        } else if (!hiddenPalettes.contains(providerID) && !visible) {
            hiddenPalettes.add(providerID);
        }
        String newIDs = PapyrusPalettePreferences.serializeHiddenPalettes(hiddenPalettes);
        hiddenPalettesMemento.putString("id", newIDs);
        PapyrusPalettePreferences.saveCustomizations(rootMemento);
    }

    public static List<String> getHiddenPalettes(IEditorPart part) {
        IMemento editorIDMemento;
        IMemento hiddenPalettesMementoEditorID;
        List<String> hiddenPalettesEditorId;
        String editorID;
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingCustomizations();
        IMemento editorMemento = PapyrusPalettePreferences.getEditorMemento(rootMemento, part.getClass().getName());
        IMemento hiddenPalettesMemento = PapyrusPalettePreferences.getEditorHiddenPalettesMemento(editorMemento);
        List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettesList(hiddenPalettesMemento);
        if (part instanceof DiagramEditorWithFlyOutPalette && (editorID = ((DiagramEditorWithFlyOutPalette)part).getContributorId()) != null && (hiddenPalettesEditorId = PapyrusPalettePreferences.getHiddenPalettesList(hiddenPalettesMementoEditorID = PapyrusPalettePreferences.getEditorHiddenPalettesMemento(editorIDMemento = PapyrusPalettePreferences.getEditorMemento(rootMemento, editorID)))) != null) {
            if (hiddenPalettes != null) {
                hiddenPalettes.addAll(hiddenPalettesEditorId);
            } else {
                hiddenPalettes = hiddenPalettesEditorId;
            }
        }
        return hiddenPalettes;
    }

    protected static String serializeHiddenPalettes(List<String> hiddenPalettes) {
        return PaletteUtil.convertToFlatRepresentation(hiddenPalettes, ";");
    }

    public static XMLMemento getExistingWorkspaceExtendedPalettes() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("workspaceExtendedPaletteDefinition");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"workspaceExtendedPaletteDefinition");
        }
        catch (WorkbenchException e) {
            Activator.getInstance().logError(Messages.PapyrusPalettePreferences_Error_ImpossibleToReadPreferences, e);
            return null;
        }
    }

    public static XMLMemento getExistingLocalExtendedPalettes() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("extendedPaletteDefinition");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"extendedPaletteDefinition");
        }
        catch (WorkbenchException e) {
            Activator.getInstance().logError(Messages.PapyrusPalettePreferences_Error_ImpossibleToReadPreferences, e);
            return null;
        }
    }

    public static void addWorkspaceExtendedPalette(String paletteID, String paletteName, String path, ProviderPriority priority, String editorID, Set<String> requiredProfiles) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        paletteMemento.putString("name", paletteName);
        paletteMemento.putString("priority", priority.getName());
        paletteMemento.putString("editorID", editorID);
        paletteMemento.putString("path", path);
        IMemento propertiesMemento = paletteMemento.createChild("properties");
        propertiesMemento.putString("requiredProfiles", PaletteUtil.getSerializedProfileList(requiredProfiles));
        PapyrusPalettePreferences.saveWorkspaceExtendedPalettes(rootMemento);
    }

    public static ProviderPriority getLocalExtendedPalettePriority(String paletteID) {
        return PapyrusPalettePreferences.getPalettePriority(paletteID, PapyrusPalettePreferences.getExistingLocalExtendedPalettes());
    }

    public static ProviderPriority getWorkspaceExtendedPalettePriority(String paletteID) {
        return PapyrusPalettePreferences.getPalettePriority(paletteID, PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes());
    }

    public static ProviderPriority getPalettePriority(String paletteID, XMLMemento rootMemento) {
        String palettePriority;
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        if ((palettePriority = paletteMemento.getString("priority")) != null) {
            return ProviderPriority.parse((String)palettePriority);
        }
        return null;
    }

    public static String getEditorID(String paletteID, XMLMemento rootMemento) {
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        String editorID = paletteMemento.getString("editorID");
        return editorID;
    }

    public static String getWorkspaceExtendedEditorID(String paletteID) {
        return PapyrusPalettePreferences.getEditorID(paletteID, PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes());
    }

    public static String getPaletteName(String paletteID, XMLMemento rootMemento) {
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        String paletteName = paletteMemento.getString("name");
        return paletteName;
    }

    public static String getWorkspaceExtendedPaletteName(String paletteID) {
        return PapyrusPalettePreferences.getPaletteName(paletteID, PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes());
    }

    public static String getPalettePath(String paletteID, XMLMemento rootMemento) {
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        String path = paletteMemento.getString("path");
        return path;
    }

    public static String getWorkspaceExtendedPalettePath(String paletteID) {
        return PapyrusPalettePreferences.getPalettePath(paletteID, PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes());
    }

    public static Set<String> getRequiredProfiles(String paletteID, XMLMemento rootMemento) {
        String profilesSerializedList;
        IMemento propertiesMemento;
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        if ((propertiesMemento = paletteMemento.getChild("properties")) != null && (profilesSerializedList = propertiesMemento.getString("requiredProfiles")) != null && profilesSerializedList.length() > 0) {
            return PaletteUtil.getProfileSetFromString(profilesSerializedList);
        }
        return null;
    }

    public static Set<String> getRequiredProfilesExtendedPalette(String paletteID) {
        return PapyrusPalettePreferences.getRequiredProfiles(paletteID, PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes());
    }

    public static void deleteWorkspaceExtendedPalette(String id) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingWorkspaceExtendedPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, id);
        if (paletteMemento == null) {
            Activator.log.warn(Messages.PapyrusPalettePreferences_Error_ImpossibleToFindPaletteInWS + id);
            return;
        }
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)"workspaceExtendedPaletteDefinition");
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString("id").equals(paletteMemento.getString("id"))) {
                IMemento newChild = newRootMemento.createChild("palette");
                newChild.putMemento(memento);
            }
            ++n2;
        }
        PapyrusPalettePreferences.saveWorkspaceExtendedPalettes(newRootMemento);
    }

    public static void deleteLocalExtendedPalette(String id) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalExtendedPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, id);
        if (paletteMemento == null) {
            Activator.log.warn(Messages.PapyrusPalettePreferences_Error_ImpossibleToFindPalette + id);
            return;
        }
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)"extendedPaletteDefinition");
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString("id").equals(paletteMemento.getString("id"))) {
                IMemento newChild = newRootMemento.createChild("palette");
                newChild.putMemento(memento);
            }
            ++n2;
        }
        PapyrusPalettePreferences.saveLocalExtendedPalettes(newRootMemento);
    }

    public static String getPalettePathFromID(String paletteID) {
        return "Palette_" + paletteID + ".xml";
    }

    protected static IMemento createMemento(XMLMemento rootMemento, String paletteID) {
        IMemento memento = rootMemento.createChild("palette");
        memento.putString("id", paletteID);
        return memento;
    }

    protected static IMemento searchPaletteMemento(XMLMemento rootMemento, String paletteID) {
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            String id = memento.getString("id");
            if (paletteID.equals(id)) {
                return memento;
            }
            ++n2;
        }
        return null;
    }

    public static void createPaletteRedefinition(PapyrusPaletteService.ExtendedProviderDescriptor descriptor) {
        String path = null;
        path = descriptor.createLocalRedefinition();
        if (path == null) {
            Activator.log.error(Messages.PapyrusPalettePreferences_ErrorDuringCreation, null);
            return;
        }
        PapyrusPalettePreferences.registerLocalRedefinition(descriptor.getContributionID(), path);
    }

    public static void addLocalExtendedPalette(String paletteID, String paletteName, ProviderPriority priority, String editorID, HashSet requiredProfiles) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalExtendedPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        paletteMemento.putString("name", paletteName);
        paletteMemento.putString("priority", priority.getName());
        paletteMemento.putString("editorID", editorID);
        paletteMemento.putString("path", paletteID + ".paletteconfiguration");
        IMemento propertiesMemento = paletteMemento.createChild("properties");
        propertiesMemento.putString("requiredProfiles", PaletteUtil.getSerializedProfileList(requiredProfiles));
        PapyrusPalettePreferences.saveLocalExtendedPalettes(rootMemento);
    }
}

