/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class AbstractManifest {
    private final Collection<String> existingExportedPackages = new TreeSet<String>();
    private final TreeMap<String, IRequiredBundleDescription> existingBundleDependencies = new TreeMap();
    private final TreeMap<String, IPackageImportDescription> existingImportPackages = new TreeMap();
    private String bundleDescription = null;
    private boolean isEclipseLazyStart = false;
    private IProject project;

    protected void init(String projectName) {
        if (projectName != null && !projectName.isEmpty()) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.initFields();
        }
    }

    protected boolean hasBundleDescription() {
        return this.bundleDescription != null && !this.bundleDescription.isEmpty();
    }

    protected String getBundleDescription() {
        return this.bundleDescription;
    }

    protected boolean isEclipseLazyStart() {
        return this.isEclipseLazyStart;
    }

    private void initFields() {
        try {
            ManifestEditor manifestEditor = new ManifestEditor(this.project);
            manifestEditor.init();
            this.initExportPackageField((IManifestEditor)manifestEditor);
            this.initRequiredBundleField((IManifestEditor)manifestEditor);
            this.initImportedPackageField((IManifestEditor)manifestEditor);
            this.initBundleDescription((IManifestEditor)manifestEditor);
            this.initEclipseLazyStart((IManifestEditor)manifestEditor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initExportPackageField(IManifestEditor editor) {
        String exportedPackage = editor.getValue("Export-Package");
        if (exportedPackage != null) {
            String[] packages = exportedPackage.split(",");
            this.existingExportedPackages.addAll(Arrays.asList(packages));
        }
    }

    private void initRequiredBundleField(IManifestEditor editor) {
        for (IRequiredBundleDescription current : editor.getRequiredBundles()) {
            this.existingBundleDependencies.put(current.getName(), current);
        }
    }

    private void initImportedPackageField(IManifestEditor editor) {
        for (IPackageImportDescription current : editor.getImportedPackages()) {
            this.existingImportPackages.put(current.getName(), current);
        }
    }

    private void initBundleDescription(IManifestEditor editor) {
        this.bundleDescription = editor.getValue("Bundle-Description");
    }

    private void initEclipseLazyStart(IManifestEditor editor) {
        String value = editor.getValue("Eclipse-LazyStart");
        this.isEclipseLazyStart = value != null && Boolean.valueOf(value) != false;
    }

    protected String getOrCreateBundleVersionRange(String bundleID) {
        IRequiredBundleDescription bundleDesc = this.existingBundleDependencies.get(bundleID);
        StringBuilder builder = new StringBuilder("bundle-version=\"[");
        String minVersion = null;
        String maxVersion = null;
        Version leftVersion = null;
        Version rightVersion = null;
        if (bundleDesc != null) {
            VersionRange range = bundleDesc.getVersionRange();
            leftVersion = range != null ? range.getLeft() : null;
            Version version = rightVersion = range != null ? range.getRight() : null;
        }
        if (leftVersion != null) {
            minVersion = leftVersion.toString();
        } else {
            Bundle bundle = Platform.getBundle((String)bundleID);
            leftVersion = bundle.getVersion();
            minVersion = this.buildVersion(leftVersion.getMajor(), leftVersion.getMinor(), 0);
        }
        maxVersion = rightVersion != null ? rightVersion.toString() : this.buildVersion(leftVersion.getMajor() + 1, 0, 0);
        builder.append(minVersion);
        builder.append(",");
        builder.append(maxVersion);
        builder.append(")\"");
        return builder.toString();
    }

    private final String buildVersion(int major, int minor, int micro) {
        StringBuilder builder = new StringBuilder();
        builder.append(major);
        builder.append(".");
        builder.append(minor);
        builder.append(".");
        builder.append(micro);
        return builder.toString();
    }

    protected Collection<String> getRequiredDependencies() {
        TreeSet<String> dependencies = new TreeSet<String>();
        dependencies.addAll(this.getGMFGenerationDependencies());
        dependencies.addAll(this.existingBundleDependencies.keySet());
        return dependencies;
    }

    private Collection<String> getGMFGenerationDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("com.google.guava");
        dependencies.add("org.eclipse.core.expressions");
        dependencies.add("org.eclipse.emf.databinding");
        dependencies.add("org.eclipse.gmf.runtime.diagram.ui.properties");
        dependencies.add("org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide");
        dependencies.add("org.eclipse.ocl.ecore");
        dependencies.add("org.eclipse.papyrus.infra.architecture");
        dependencies.add("org.eclipse.papyrus.infra.core.architecture");
        dependencies.add("org.eclipse.papyrus.infra.core.log");
        dependencies.add("org.eclipse.papyrus.infra.core.sasheditor");
        dependencies.add("org.eclipse.papyrus.infra.core.sashwindows.di");
        dependencies.add("org.eclipse.papyrus.infra.core");
        dependencies.add("org.eclipse.papyrus.infra.emf.appearance");
        dependencies.add("org.eclipse.papyrus.infra.emf.gmf");
        dependencies.add("org.eclipse.papyrus.infra.emf");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.commands");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.common");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.hyperlink");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.preferences");
        dependencies.add("org.eclipse.papyrus.infra.gmfdiag.tooling.runtime");
        dependencies.add("org.eclipse.papyrus.infra.hyperlink");
        dependencies.add("org.eclipse.papyrus.infra.internationalization.common");
        dependencies.add("org.eclipse.papyrus.infra.internationalization.utils");
        dependencies.add("org.eclipse.papyrus.infra.services.edit");
        dependencies.add("org.eclipse.papyrus.infra.services.viewersearch");
        dependencies.add("org.eclipse.papyrus.infra.ui");
        dependencies.add("org.eclipse.papyrus.infra.viewpoints.policy");
        dependencies.add("org.eclipse.papyrus.infra.widgets");
        dependencies.add("org.eclipse.papyrus.uml.appearance");
        dependencies.add("org.eclipse.papyrus.uml.diagram.common");
        dependencies.add("org.eclipse.papyrus.uml.internationalization.utils");
        dependencies.add("org.eclipse.papyrus.uml.tools.utils");
        dependencies.add("org.eclipse.ui.navigator.resources");
        dependencies.add("org.eclipse.ui.navigator");
        dependencies.add("org.eclipse.uml2.uml.editor");
        return dependencies;
    }

    protected final Collection<String> getExistingExportedPackages() {
        return new TreeSet<String>(this.existingExportedPackages);
    }

    protected final String declareImportPackage() {
        StringBuilder builder = new StringBuilder();
        if (!this.existingImportPackages.isEmpty()) {
            Iterator<Map.Entry<String, IPackageImportDescription>> iter = this.existingImportPackages.entrySet().iterator();
            builder.append("Import-Package:");
            while (iter.hasNext()) {
                Map.Entry<String, IPackageImportDescription> current = iter.next();
                builder.append(" ");
                builder.append(current.getKey());
                IPackageImportDescription packDesc = current.getValue();
                String vRange = packDesc.getVersionRange().toString();
                if (vRange != null) {
                    builder.append(";version=\"");
                    builder.append(vRange);
                    builder.append("\"");
                }
                if (iter.hasNext()) {
                    builder.append(",");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    protected final String buildRequiredBundle() {
        StringBuilder builder = new StringBuilder();
        builder.append("Require-Bundle:");
        Iterator<String> iter = this.getRequiredDependencies().iterator();
        while (iter.hasNext()) {
            String next = iter.next();
            builder.append(" ");
            builder.append(next);
            builder.append(";");
            builder.append(this.getOrCreateBundleVersionRange(next));
            if (iter.hasNext()) {
                builder.append(",");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

