/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.profile.index.ProfileWorkspaceModelIndex;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeExplorerDialog
extends SelectionStatusDialog {
    protected final boolean allowMultiple;
    protected String initialValue;
    protected ResourceSet resourceSet = new ResourceSetImpl();
    protected TreeViewer stereotypeTreeViewer;
    protected PatternViewerFilterEx viewerFilter = new PatternViewerFilterEx();
    private boolean onlyApplicableStereotypes = true;
    private Element sourceUMLElement;
    private StyledText informationText;
    private static final String ICONS_EXPAND_ALL = "/icons/expandAll.png";
    private static final String ICONS_COLLAPSE_ALL = "/icons/collapseAll.png";
    List<IRegisteredProfile> registeredProfiles = RegisteredProfile.getRegisteredProfiles();

    public StereotypeExplorerDialog(Shell parentShell, boolean allowMultiple, String initialQualifyName) {
        super(parentShell);
        this.allowMultiple = allowMultiple;
        this.initialValue = initialQualifyName;
        this.setTitle(Messages.StereotypeExplorerDialog_Title);
        this.setMessage(Messages.StereotypeExplorerDialog_Message);
    }

    public StereotypeExplorerDialog(Shell parentShell, String initialValue) {
        this(parentShell, false, initialValue);
    }

    public StereotypeExplorerDialog(Shell parentShell) {
        this(parentShell, false, "");
    }

    public boolean close() {
        for (Resource resource : this.resourceSet.getResources()) {
            if (!resource.isLoaded()) continue;
            resource.unload();
        }
        return super.close();
    }

    protected void computeResult() {
        Object selectedElements = this.getSelectedElements();
        if (selectedElements instanceof Stereotype) {
            this.setResult(Arrays.asList((Stereotype)selectedElements));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        Composite topComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(topComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)topComposite);
        this.createFilterText(topComposite);
        Label separator = new Label(topComposite, 514);
        GridDataFactory.fillDefaults().hint(-1, 10).grab(false, false).applyTo((Control)separator);
        this.createExpandCollapseButtons(topComposite);
        this.createStereotypeFilteredList(composite);
        this.createInformationText(composite);
        this.createFilterOnSourceElementButton(composite);
        this.selectInitialValue();
        this.refreshOkButton();
        return composite;
    }

    protected void createExpandCollapseButtons(Composite composite) {
        ToolBar container = new ToolBar(composite, 0);
        ToolItem buttonExpand = new ToolItem(container, 0);
        Image imageExpand = org.eclipse.papyrus.uml.diagram.common.Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICONS_EXPAND_ALL);
        buttonExpand.setImage(imageExpand);
        buttonExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = StereotypeExplorerDialog.this.stereotypeTreeViewer.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        StereotypeExplorerDialog.this.stereotypeTreeViewer.expandToLevel(object, Activator.getMaxLevelToExpandValue());
                        ++n2;
                    }
                } else {
                    StereotypeExplorerDialog.this.stereotypeTreeViewer.expandToLevel(Activator.getMaxLevelToExpandValue());
                }
                StereotypeExplorerDialog.this.stereotypeTreeViewer.refresh();
            }
        });
        ToolItem buttonCollapse = new ToolItem(container, 0);
        Image imageCollapse = org.eclipse.papyrus.uml.diagram.common.Activator.getPluginIconImage((String)"org.eclipse.papyrus.infra.widgets", (String)ICONS_COLLAPSE_ALL);
        buttonCollapse.setImage(imageCollapse);
        buttonCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = StereotypeExplorerDialog.this.stereotypeTreeViewer.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        StereotypeExplorerDialog.this.stereotypeTreeViewer.collapseToLevel(object, -1);
                        ++n2;
                    }
                } else {
                    StereotypeExplorerDialog.this.stereotypeTreeViewer.collapseAll();
                }
            }
        });
    }

    protected void selectInitialValue() {
        if (!this.initialValue.isEmpty()) {
            Object[] roots;
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.stereotypeTreeViewer.getContentProvider();
            Object[] objectArray = roots = contentProvider.getElements(null);
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] profiles;
                Object root = objectArray[n2];
                Object[] objectArray2 = profiles = contentProvider.getChildren(root);
                int n3 = profiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object[] stereotypes;
                    Object profile = objectArray2[n4];
                    Object[] objectArray3 = stereotypes = contentProvider.getChildren(profile);
                    int n5 = stereotypes.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Object stereotype = objectArray3[n6];
                        if (stereotype instanceof Stereotype && this.initialValue.equals(((Stereotype)stereotype).getQualifiedName())) {
                            this.stereotypeTreeViewer.expandToLevel(profile, 1);
                            this.stereotypeTreeViewer.setSelection((ISelection)new StructuredSelection(stereotype), true);
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void createInformationText(Composite composite) {
        this.informationText = new StyledText(composite, 2314);
        this.informationText.setLayoutData((Object)new GridData(4, 64, true, false));
        this.informationText.setAlwaysShowScrollBars(false);
    }

    protected void createFilterOnSourceElementButton(Composite composite) {
        if (this.sourceUMLElement != null) {
            Button button = new Button(composite, 32);
            button.setText(Messages.StereotypeExplorerDialog_OnlyApplicableStereotypesLabel);
            button.setSelection(true);
            button.setEnabled(true);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StereotypeExplorerDialog.this.onlyApplicableStereotypes = ((Button)event.getSource()).getSelection();
                    StereotypeExplorerDialog.this.viewerFilter.clearCache();
                    StereotypeExplorerDialog.this.stereotypeTreeViewer.refresh();
                }
            });
        }
    }

    protected TreeViewer createStereotypeFilteredList(Composite parent) {
        Tree tree = new Tree(parent, 2816);
        GridLayout filterLayout = new GridLayout();
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        tree.setLayout((Layout)filterLayout);
        GridData gridData = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gridData);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new StereotypeListContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new StereotypeStyledListLabelProvider());
        treeViewer.setFilters(new ViewerFilter[]{this.viewerFilter});
        treeViewer.setInput(new Object());
        treeViewer.expandToLevel(2);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StereotypeExplorerDialog.this.refreshOkButton();
                StereotypeExplorerDialog.this.refreshInformationText();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (StereotypeExplorerDialog.this.getOkButton().isEnabled()) {
                    StereotypeExplorerDialog.this.okPressed();
                }
            }
        });
        treeViewer.refresh();
        this.stereotypeTreeViewer = treeViewer;
        return treeViewer;
    }

    protected void createFilterText(Composite parent) {
        final StringWithClearEditor filterText = new StringWithClearEditor(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterText);
        filterText.setValue((Object)"");
        filterText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = filterText.getValue();
                StereotypeExplorerDialog.this.viewerFilter.setPattern(value);
                StereotypeExplorerDialog.this.stereotypeTreeViewer.refresh();
                StereotypeExplorerDialog.this.stereotypeTreeViewer.collapseAll();
                StereotypeExplorerDialog.this.stereotypeTreeViewer.expandToLevel(value.isEmpty() ? 2 : 3);
            }
        });
        filterText.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    StereotypeExplorerDialog.this.stereotypeTreeViewer.getControl().setFocus();
                }
            }
        });
    }

    protected Profile getProfile(IRegisteredProfile registeredProfile) {
        URI uri = registeredProfile.getUri();
        Resource resource = null;
        try {
            resource = this.resourceSet.getResource(uri, true);
        }
        catch (Exception e) {
            org.eclipse.papyrus.uml.diagram.common.Activator.log.error((Throwable)e);
        }
        Profile profile = null;
        if (resource != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Profile) {
            profile = (Profile)resource.getContents().get(0);
        }
        return profile;
    }

    protected List<Object> getRoot() {
        ArrayList<Object> element = new ArrayList<Object>();
        element.add(new String(Messages.StereotypeExplorerDialog_PluginContributionSeparatorLabel));
        element.add(new String(Messages.StereotypeExplorerDialog_WokspaceContributionSeparator));
        return element;
    }

    protected Object getSelectedElements() {
        Assert.isNotNull((Object)this.stereotypeTreeViewer);
        return this.stereotypeTreeViewer.getStructuredSelection().getFirstElement();
    }

    public Collection<Profile> getWorkspaceProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        Collection workspaceProfilesURIs = ProfileWorkspaceModelIndex.getInstance().getWorkspaceProfilesURIs();
        for (URI uri : workspaceProfilesURIs) {
            Resource createResource = this.resourceSet.getResource(uri, true);
            if (!createResource.getContents().isEmpty() && createResource.getContents().get(0) instanceof Profile) {
                profiles.add((Profile)createResource.getContents().get(0));
                continue;
            }
            createResource.unload();
        }
        return profiles;
    }

    protected void refreshOkButton() {
        Object selectedElements = this.getSelectedElements();
        if (selectedElements instanceof Stereotype) {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.papyrus.uml.diagram.common", ""));
        } else {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", ""));
        }
    }

    protected void refreshInformationText() {
        Object selectedElements = this.getSelectedElements();
        String label = "";
        if (selectedElements instanceof Stereotype) {
            EList comments = ((Stereotype)selectedElements).getProfile().getOwnedComments();
            String cr = "";
            for (Comment comment : comments) {
                if (!comment.getAnnotatedElements().contains(selectedElements)) continue;
                label = String.valueOf(label) + cr + comment.getBody();
                cr = "\n";
            }
        } else if (selectedElements instanceof Profile) {
            EList comments = ((Element)selectedElements).getOwnedComments();
            String cr = "";
            for (Comment comment : comments) {
                if (!comment.getAnnotatedElements().contains(selectedElements)) continue;
                label = String.valueOf(label) + cr + comment.getBody();
                cr = " \n";
            }
        } else if (selectedElements instanceof IRegisteredProfile) {
            label = ((IRegisteredProfile)selectedElements).getDescription();
        }
        this.informationText.setText(label);
        this.informationText.pack();
        this.informationText.getParent().layout();
    }

    public void setElementToApplyStereotype(Element sourceUMLElement) {
        this.sourceUMLElement = sourceUMLElement;
    }

    protected List<Stereotype> getAllStereotypes(Profile profile) {
        return StereotypeUtil.getAllStereotypes((Profile)profile);
    }

    protected boolean isVisible(Object element) {
        boolean visible = true;
        if (element instanceof IRegisteredProfile | element instanceof Profile | element instanceof String) {
            visible = false;
        } else if (element instanceof String) {
            visible = true;
        } else if (this.onlyApplicableStereotypes && element instanceof Stereotype && this.sourceUMLElement instanceof Element) {
            visible = this.isApplicableToSourceElement((Stereotype)element);
        }
        return visible;
    }

    private boolean isApplicableToSourceElement(Stereotype element) {
        boolean isApplicable = false;
        List eClasses = ProfileUtil.getAllExtendedMetaclasses((Stereotype)element, (boolean)true);
        for (EClass eClass : eClasses) {
            isApplicable |= eClass.getName().equals(this.sourceUMLElement.eClass().getName());
        }
        return isApplicable;
    }

    private class PatternViewerFilterEx
    extends PatternViewerFilter {
        private PatternViewerFilterEx() {
        }

        public boolean isVisible(Viewer viewer, Object parentElement, Object element) {
            boolean visible = super.isVisible(viewer, parentElement, element);
            return visible &= StereotypeExplorerDialog.this.isVisible(element);
        }

        public void clearCache() {
            super.clearCache();
        }
    }

    public class StereotypeListContentProvider
    extends AbstractStaticContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parentElement instanceof String) {
                if (Messages.StereotypeExplorerDialog_PluginContributionSeparatorLabel.equals(parentElement)) {
                    children.addAll(StereotypeExplorerDialog.this.registeredProfiles);
                } else if (Messages.StereotypeExplorerDialog_WokspaceContributionSeparator.equals(parentElement)) {
                    children.addAll(StereotypeExplorerDialog.this.getWorkspaceProfiles());
                }
            } else {
                Profile profile = null;
                if (parentElement instanceof IRegisteredProfile) {
                    profile = StereotypeExplorerDialog.this.getProfile((IRegisteredProfile)parentElement);
                } else if (parentElement instanceof Profile) {
                    profile = (Profile)parentElement;
                }
                if (profile != null) {
                    children.addAll(StereotypeExplorerDialog.this.getAllStereotypes(profile));
                }
            }
            return children.toArray();
        }

        public Object[] getElements() {
            List<Object> element = StereotypeExplorerDialog.this.getRoot();
            return element.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }
    }

    public class StereotypeListLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final String ICONS_PROFILE_GIF = "/icons/profile.gif";
        private static final String ICONS_STEREOTYPE_GIF = "/icons/stereotype.gif";

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof IRegisteredProfile) {
                image = ((IRegisteredProfile)element).getImage();
                if (image == null) {
                    image = org.eclipse.papyrus.uml.diagram.common.Activator.getImage((String)ICONS_PROFILE_GIF);
                }
            } else if (element instanceof Stereotype) {
                image = org.eclipse.papyrus.uml.diagram.common.Activator.getImage((String)ICONS_STEREOTYPE_GIF);
            } else if (element instanceof Profile) {
                image = org.eclipse.papyrus.uml.diagram.common.Activator.getImage((String)ICONS_PROFILE_GIF);
            }
            return image;
        }

        public String getText(Object element) {
            String label = null;
            if (element instanceof IRegisteredProfile) {
                label = ((IRegisteredProfile)element).getName();
            } else if (element instanceof Stereotype) {
                label = ((Stereotype)element).getName();
            } else if (element instanceof Profile) {
                label = ((Profile)element).getName();
            } else if (element instanceof String) {
                label = "------ " + element + " -----";
            }
            return label;
        }

        public StyledString getStyledText(Object element) {
            String text = this.getText(element);
            StyledString styledString = new StyledString(text);
            if (element instanceof String) {
                styledString.setStyle(0, text.length(), StyledString.COUNTER_STYLER);
            } else if (element instanceof Profile) {
                URI uri = EcoreUtil.getURI((EObject)((EObject)element)).trimFragment();
                String path = " - " + uri.toPlatformString(true).substring(1);
                styledString.append(path, StyledString.QUALIFIER_STYLER);
            } else if (element instanceof Stereotype) {
                String path = " - " + ((Stereotype)element).getQualifiedName();
                styledString.append(path, StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }
    }

    public class StereotypeStyledListLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        public StereotypeStyledListLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StereotypeListLabelProvider());
        }

        public String getText(Object element) {
            return this.getStyledStringProvider().getStyledText(element).getString();
        }
    }
}

