/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ProjectManagementUtils {
    public static IPluginModelBase getPluginModelBase(IProject project) {
        return PluginRegistry.findModel((IProject)project);
    }

    public static List<IPluginExtension> getPluginExtensions(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        return pluginModelBase != null ? Arrays.asList(pluginModelBase.getExtensions().getExtensions()) : Collections.emptyList();
    }

    public static List<BundleSpecification> getPluginDependencies(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        return pluginModelBase != null ? Arrays.asList(pluginModelBase.getBundleDescription().getRequiredBundles()) : Collections.emptyList();
    }

    public static IBuildModel getPluginBuild(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        if (pluginModelBase != null) {
            try {
                return PluginRegistry.createBuildModel((IPluginModelBase)pluginModelBase);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean existFileFromProject(IContainer container, String foundFile, boolean isExtensionCheck) {
        boolean[] result = new boolean[1];
        if (container.isAccessible()) {
            try {
                container.accept(resource -> {
                    switch (resource.getType()) {
                        case 1: {
                            blArray[0] = result[0] || ProjectManagementUtils.isCorrespondingFile((IFile)resource, foundFile, isExtensionCheck);
                            break;
                        }
                    }
                    return !result[0];
                });
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return result[0];
    }

    public static Collection<IFile> getFilesFromProject(IContainer container, String foundFile, boolean isExtensionCheck) {
        HashSet<IFile> result = new HashSet<IFile>();
        if (container.isAccessible()) {
            try {
                container.accept(resource -> {
                    switch (resource.getType()) {
                        case 1: {
                            if (!ProjectManagementUtils.isCorrespondingFile((IFile)resource, foundFile, isExtensionCheck)) break;
                            result.add((IFile)resource);
                            break;
                        }
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return result;
    }

    public static IFile getManifestFile(IContainer container) {
        Collection<IFile> manifestFiles = ProjectManagementUtils.getFilesFromProject(container, "MANIFEST.MF", false);
        return manifestFiles.isEmpty() ? null : manifestFiles.iterator().next();
    }

    public static IFile getPluginXMLFile(IContainer container) {
        Collection<IFile> pluginXMLFiles = ProjectManagementUtils.getFilesFromProject(container, "plugin.xml", false);
        return pluginXMLFiles.isEmpty() ? null : pluginXMLFiles.iterator().next();
    }

    public static IFile getBuildFile(IContainer container) {
        Collection<IFile> buildPropertiesFiles = ProjectManagementUtils.getFilesFromProject(container, "build.properties", false);
        return buildPropertiesFiles.isEmpty() ? null : buildPropertiesFiles.iterator().next();
    }

    private static boolean isCorrespondingFile(IFile file, String foundFile, boolean isExtensionCheck) {
        return isExtensionCheck ? file.getName().endsWith("." + foundFile) : file.getName().equals(foundFile);
    }

    public static Optional<IPluginElement> findExtensionElement(String extensionPoint, String elementName, String ... attributes) {
        return ProjectManagementUtils.getExtensionElements(extensionPoint, elementName, attributes).findAny();
    }

    public static Stream<IPluginElement> getExtensionElements(String extensionPoint, String elementName, String ... attributes) {
        Predicate<IPluginElement> elementFilter = element -> elementName.equals(element.getName());
        if (attributes.length > 0) {
            elementFilter = elementFilter.and(ProjectManagementUtils.hasAttributes(attributes));
        }
        return Stream.of(PluginRegistry.getActiveModels()).map(ISharedExtensionsModel::getExtensions).map(IExtensions::getExtensions).flatMap(iPluginExtensionArray -> Stream.of(iPluginExtensionArray)).filter(ext -> extensionPoint.equals(ext.getPoint())).map(IPluginParent::getChildren).flatMap(iPluginObjectArray -> Stream.of(iPluginObjectArray)).filter(IPluginElement.class::isInstance).map(IPluginElement.class::cast).filter(elementFilter);
    }

    public static Predicate<IPluginElement> hasAttributes(String ... attributes) {
        Predicate<IPluginElement> result = __ -> true;
        int i = 0;
        while (i < attributes.length) {
            String name = attributes[i];
            String value = attributes[i + 1];
            Predicate<IPluginElement> next = element -> value.equals(element.getAttribute(name).getValue());
            result = i > 0 ? result.and(next) : next;
            i += 2;
        }
        return result;
    }

    public static Predicate<IPluginElement> hasAttribute(String attribute, Predicate<? super String> predicate) {
        return element -> Optional.ofNullable(element.getAttribute(attribute)).map(IPluginAttribute::getValue).filter(predicate).isPresent();
    }

    public static Predicate<IPluginElement> resourcePathIs(String pathAttribute, URI uri) {
        return element -> Optional.ofNullable(element.getAttribute(pathAttribute)).map(attr -> ProjectManagementUtils.resourcePathMatches(attr, uri)).orElse(false);
    }

    private static boolean resourcePathMatches(IPluginAttribute attribute, URI uri) {
        String path = attribute.getValue();
        if (path == null || path.isBlank()) {
            return false;
        }
        try {
            URI pathURI = URI.createURI((String)path, (boolean)true);
            if (pathURI.isRelative()) {
                pathURI = URI.createPlatformPluginURI((String)String.format("%s/%s", attribute.getPluginBase().getId(), pathURI), (boolean)false);
            }
            return pathURI.equals(uri) || pathURI.isPlatform() && uri.isPlatform() && pathURI.toPlatformString(false).equals(uri.toPlatformString(false));
        }
        catch (Exception e) {
            return false;
        }
    }
}

