/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests.apireport;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class API2HTML
extends DefaultHandler {
    private static final String ANNOTATION = "annotation";
    private static final String ENUM = "enum";
    private static final String INTERFACE = "interface";
    private static final String CLASS = "class";
    private static final String PLUS = "plus.gif";
    private static final String MINUS = "minus.gif";
    private static final Pattern VERSION_CHANGED = Pattern.compile("The ([^ ]+) version has been changed for the api component ([^ ]+) \\(from version ([^ ]+) to ([^ ]+)\\)");
    private int lastNodeID;
    private Category breaking = new Category(CategoryKind.BREAKING, "Breaking API Changes");
    private Category compatible = new Category(CategoryKind.COMPATIBLE, "Compatible API Changes");
    private Category reexports = new Category(CategoryKind.REEXPORTS, "Re-exported API Changes");
    private String buildQualifier;

    public API2HTML(File inputXML, String buildQualifier) throws Exception {
        this.buildQualifier = buildQualifier;
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream in = new FileInputStream(inputXML);){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)in, (DefaultHandler)this);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        if ("delta".equalsIgnoreCase(qName)) {
            try {
                Category category;
                int pos;
                Matcher matcher;
                String componentVersion = null;
                String componentChange = null;
                String componentID = attributes.getValue("componentId");
                String typeName = attributes.getValue("type_name");
                String elementType = attributes.getValue("element_type");
                String kind = attributes.getValue("kind");
                String message = attributes.getValue("message");
                if ((componentID == null || componentID.length() == 0) && message.startsWith("The API component ")) {
                    componentID = message.substring("The API component ".length());
                    componentID = componentID.substring(0, componentID.indexOf(32));
                    if (message.endsWith("added")) {
                        componentChange = "The plugin has been added";
                        componentVersion = this.readComponentVersion(componentID);
                    } else if (message.endsWith("removed")) {
                        componentChange = "The plugin has been removed";
                    } else {
                        System.out.println("No componentID: " + message);
                        return;
                    }
                }
                if (componentChange == null && (typeName == null || typeName.length() == 0) && (matcher = VERSION_CHANGED.matcher(message)).matches()) {
                    componentChange = "The " + matcher.group(1) + " version has been changed from " + matcher.group(3) + " to " + matcher.group(4);
                }
                if ((pos = componentID.indexOf(40)) != -1) {
                    componentVersion = componentID.substring(pos + 1, componentID.length() - 1);
                    componentID = componentID.substring(0, pos);
                }
                message = this.remove(message, String.valueOf(typeName) + ".");
                message = this.remove(message, " in an interface that is tagged with '@noimplement'");
                message = this.remove(message, " for interface " + typeName);
                if (!(message = this.remove(message, " for class " + typeName)).contains("modifier has been")) {
                    message = this.remove(message, " to " + typeName);
                }
                if (message != null && message.startsWith("The deprecation modifiers has")) {
                    message = "The deprecation modifier has" + message.substring("The deprecation modifiers has".length());
                }
                if (message.startsWith("The re-exported type")) {
                    componentChange = message;
                    category = this.reexports;
                } else {
                    category = "true".equals(attributes.getValue("compatible")) ? this.compatible : this.breaking;
                }
                Map<String, Component> components = category.getComponents();
                Component component = components.get(componentID);
                if (component == null) {
                    component = new Component(category, componentID);
                    components.put(componentID, component);
                }
                if (componentVersion != null) {
                    component.setComponentVersion(componentVersion);
                }
                if (componentChange != null) {
                    component.getChanges().add(new Change(component, componentChange, kind));
                } else {
                    if (typeName == null || typeName.length() == 0) {
                        System.out.println("No typeName: " + message);
                        return;
                    }
                    Type type = component.getTypes().get(typeName);
                    if (type == null) {
                        type = new Type(component, typeName);
                        component.getTypes().put(typeName, type);
                    }
                    type.setElementType(elementType);
                    type.getChanges().add(new Change(type, message, kind));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String readComponentVersion(String componentID) throws Exception {
        IFile manifestFile;
        IFolder metaInf;
        String result = null;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(componentID);
        if (project != null && project.isAccessible() && (metaInf = project.getFolder("META-INF")) != null && metaInf.isAccessible() && (manifestFile = metaInf.getFile("MANIFEST.MF")) != null && manifestFile.isAccessible()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream in = manifestFile.getContents();){
                Manifest manifest = new Manifest(in);
                Attributes attributes = manifest.getMainAttributes();
                result = attributes.getValue("Bundle-Version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return result;
    }

    public void generate(File htmlFile) throws Exception {
        try (PrintStream out = new PrintStream(htmlFile);){
            out.println("<!DOCTYPE HTML>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>API Evolution Report for Papyrus " + this.buildQualifier + "</title>");
            out.println("<link rel=stylesheet type='text/css' href='api.css'>");
            out.println("<base href='images/'>");
            out.println("<script type='text/javascript'>");
            out.println("  function toggle(id)");
            out.println("  {");
            out.println("    e = document.getElementById(id);");
            out.println("    e.style.display = (e.style.display == '' ? 'none' : '');");
            out.println("    img = document.getElementById('img_' + id);");
            out.println("    img.src = (e.style.display == 'none' ? 'plus.gif' : 'minus.gif');");
            out.println("  }");
            out.println("</script>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>API Evolution Report for Papyrus " + this.buildQualifier + "</h1>");
            this.breaking.generate(out, "");
            out.println("<p/>");
            this.compatible.generate(out, "");
            out.println("<p/>");
            this.reexports.generate(out, "");
            out.println("</body>");
            out.println("</html>");
        }
    }

    private List<String> sortedKeys(Map<String, ?> map) {
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        return list;
    }

    private String remove(String string, String remove) {
        int pos;
        if (string != null && (pos = string.indexOf(remove)) != -1) {
            string = String.valueOf(string.substring(0, pos)) + string.substring(pos + remove.length());
        }
        return string;
    }

    public static void main(String[] args) throws Exception {
        new API2HTML(new File(args[0]), args[2]).generate(new File(args[1]));
    }

    protected abstract class AbstractNode {
        private final AbstractNode parent;
        private final String text;

        public AbstractNode(AbstractNode parent, String text) {
            this.parent = parent;
            this.text = text;
        }

        public String getText() {
            return this.text.replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
        }

        public String getIcon() {
            return "";
        }

        public void generate(PrintStream out, String indent) throws Exception {
            out.print(String.valueOf(indent) + this.getIcon() + " ");
            String href = this.getHref();
            if (href == null) {
                out.print(this.getText());
            } else {
                out.print("<a href='" + href + "' target='_blank'>");
                out.print(this.getText());
                out.print("</a>");
            }
        }

        protected String getHref() throws Exception {
            return null;
        }

        AbstractNode getParent() {
            return this.parent;
        }

        <N extends AbstractNode> N getAncestor(Class<N> type) {
            AbstractNode result = null;
            AbstractNode node = this;
            while (node != null) {
                if (type.isInstance(node)) {
                    result = (AbstractNode)type.cast(node);
                    break;
                }
                node = node.getParent();
            }
            return (N)result;
        }

        Category getCategory() {
            return this.getAncestor(Category.class);
        }
    }

    protected abstract class AbstractTreeNode
    extends AbstractNode {
        private int id;

        public AbstractTreeNode(AbstractNode parent, String text) {
            super(parent, text);
            this.id = ++API2HTML.this.lastNodeID;
        }

        @Override
        public void generate(PrintStream out, String indent) throws Exception {
            out.print(String.valueOf(indent) + "<div class='" + this.getClass().getSimpleName().toLowerCase() + "'>");
            if (this.isCollapsible()) {
                out.print("<a href=\"javascript:toggle('node" + this.id + "')\">");
                out.print("<img src='" + (this.isCollapsed() ? API2HTML.PLUS : API2HTML.MINUS) + "' id='img_node" + this.id + "'>");
                out.print("</a>");
            }
            super.generate(out, "");
            out.println("</div>");
            out.println(String.valueOf(indent) + "<div id=\"node" + this.id + "\" style='" + (this.isCollapsed() ? "display:none; " : "") + "margin-left:20px;'>");
            this.generateChildren(out, String.valueOf(indent) + "  ");
            out.println(String.valueOf(indent) + "</div>");
        }

        protected abstract void generateChildren(PrintStream var1, String var2) throws Exception;

        protected boolean isCollapsible() {
            return false;
        }

        protected boolean isCollapsed() {
            return this.isCollapsible();
        }
    }

    private final class Category
    extends AbstractTreeNode {
        private final Map<String, Component> components;
        private final CategoryKind kind;

        public Category(CategoryKind kind, String text) {
            super(null, text);
            this.components = new HashMap<String, Component>();
            this.kind = kind;
        }

        CategoryKind kind() {
            return this.kind;
        }

        public Map<String, Component> getComponents() {
            return this.components;
        }

        @Override
        protected void generateChildren(PrintStream out, String indent) throws Exception {
            if (this.components.isEmpty()) {
                out.println(String.valueOf(indent) + "<em>There are no " + this.getText().toLowerCase() + ".</em>");
            } else {
                for (String key : API2HTML.this.sortedKeys(this.components)) {
                    Component component = this.components.get(key);
                    component.generate(out, indent);
                }
            }
        }

        @Override
        protected boolean isCollapsible() {
            return true;
        }

        @Override
        protected boolean isCollapsed() {
            return this.kind() != CategoryKind.BREAKING;
        }
    }

    private static enum CategoryKind {
        BREAKING,
        COMPATIBLE,
        REEXPORTS;

    }

    private final class Change
    extends AbstractNode {
        private final String kind;

        public Change(AbstractNode parent, String text, String kind) {
            super(parent, text);
            this.kind = "REMOVED".equals(kind) ? "removal" : ("ADDED".equals(kind) ? "addition" : "change");
        }

        @Override
        public String getIcon() {
            try {
                return "<img src='" + this.kind + ".gif'>";
            }
            catch (Exception ex) {
                return super.getIcon();
            }
        }

        @Override
        public String getText() {
            String result = super.getText();
            result = result.replaceAll("type ([A-Z]\\w+|[a-zA-Z0-9_]+\\.[a-zA-Z0-9_.]+)", "type <span class=\"apiname\">$1</span>");
            result = result.replaceAll("(field|interface) (?!that)(\\S+)", "$1 <span class=\"apiname\">$2</span>");
            result = result.replaceAll("constant value (.*?) of the field", "constant value <span class=\"apiname\">$1</span> of the field");
            result = result.replaceAll("(constructor|method) (\\S+\\([^)]*\\))", "$1 <span class=\"apiname\">$2</span>");
            result = result.replaceAll("(@\\w+)", "<span class=\"apiname\">$1</span>");
            result = result.replaceAll("'(\\w+)' keyword", "'<span class=\"apiname\">$1</span>' keyword");
            result = result.replaceAll("The type argument have been changed for (\\S+); was (\\S+) and is now (\\S+)", "A type argument as been changed for <span class=\"apiname\">$1</span>; was <span class=\"apiname\">$2</span> and is now <span class=\"apiname\">$3</span>");
            return result;
        }

        @Override
        public void generate(PrintStream out, String indent) throws Exception {
            out.print(String.valueOf(indent) + "<img src='empty.gif'>");
            super.generate(out, "");
            out.println("<br>");
        }
    }

    private final class Component
    extends AbstractTreeNode {
        private final List<Change> changes;
        private final Map<String, Type> types;
        private Version componentVersion;

        public Component(AbstractNode parent, String componentID) {
            super(parent, componentID);
            this.changes = new ArrayList<Change>();
            this.types = new HashMap<String, Type>();
        }

        public String getComponentID() {
            return super.getText();
        }

        public void setComponentVersion(String componentVersion) {
            Version version = new Version(componentVersion);
            if (this.componentVersion == null || this.componentVersion.compareTo(version) < 0) {
                this.componentVersion = version;
            }
        }

        @Override
        public String getText() {
            String componentID = this.getComponentID();
            if (this.componentVersion != null) {
                componentID = String.valueOf(componentID) + "&nbsp;" + this.componentVersion;
            }
            return componentID;
        }

        @Override
        public String getIcon() {
            return "<img src='plugin.gif'>";
        }

        public List<Change> getChanges() {
            return this.changes;
        }

        public Map<String, Type> getTypes() {
            return this.types;
        }

        @Override
        protected void generateChildren(PrintStream out, String indent) throws Exception {
            for (Change change : this.changes) {
                change.generate(out, indent);
            }
            for (String key : API2HTML.this.sortedKeys(this.types)) {
                Type type = this.types.get(key);
                type.generate(out, indent);
            }
        }

        @Override
        protected String getHref() throws Exception {
            return null;
        }

        @Override
        protected boolean isCollapsible() {
            return true;
        }

        @Override
        protected boolean isCollapsed() {
            return this.getCategory().isCollapsed();
        }
    }

    private final class Type
    extends AbstractTreeNode {
        private final List<Change> changes;
        private final Component component;
        private String elementType;

        public Type(Component component, String text) {
            super(component, text);
            this.changes = new ArrayList<Change>();
            this.component = component;
        }

        public String getTypeName() {
            return super.getText();
        }

        @Override
        public String getText() {
            String typeName = this.getTypeName();
            return typeName.replace('$', '.');
        }

        @Override
        public String getIcon() {
            try {
                return "<img src='" + this.getElementType() + ".gif'>";
            }
            catch (Exception ex) {
                return super.getIcon();
            }
        }

        public List<Change> getChanges() {
            return this.changes;
        }

        public void setElementType(String elementType) {
            if ("CLASS_ELEMENT_TYPE".equals(elementType)) {
                this.elementType = API2HTML.CLASS;
            } else if ("INTERFACE_ELEMENT_TYPE".equals(elementType)) {
                this.elementType = API2HTML.INTERFACE;
            } else if ("ENUM_ELEMENT_TYPE".equals(elementType)) {
                this.elementType = API2HTML.ENUM;
            } else if ("ANNOTATION_ELEMENT_TYPE".equals(elementType)) {
                this.elementType = API2HTML.ANNOTATION;
            }
        }

        public String getElementType() throws Exception {
            if (this.elementType == null) {
                String typeName = this.getTypeName();
                this.elementType = this.determineElementType(typeName);
            }
            return this.elementType;
        }

        @Override
        protected void generateChildren(PrintStream out, String indent) throws Exception {
            for (Change change : this.changes) {
                change.generate(out, indent);
            }
        }

        @Override
        protected String getHref() throws Exception {
            return null;
        }

        private String determineElementType(String typeName) throws MalformedURLException {
            final String[] result = new String[1];
            int lastDot = typeName.lastIndexOf(46);
            String packageName = typeName.substring(0, lastDot);
            typeName = typeName.substring(lastDot + 1).replace('$', '.');
            TypeNameRequestor requestor = new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if (result[0] == null) {
                        result[0] = Flags.isAnnotation((int)modifiers) ? API2HTML.ANNOTATION : (Flags.isInterface((int)modifiers) ? API2HTML.INTERFACE : (Flags.isEnum((int)modifiers) ? API2HTML.ENUM : API2HTML.CLASS));
                    }
                }
            };
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            SearchEngine engine = new SearchEngine();
            try {
                engine.searchAllTypeNames(packageName.toCharArray(), 8, typeName.toCharArray(), 8, 0, scope, requestor, 3, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                result[0] = API2HTML.CLASS;
            }
            return result[0] == null ? API2HTML.CLASS : result[0];
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private static final String SEPARATOR = ".";
        private int major = 0;
        private int minor = 0;
        private int micro = 0;

        public Version(String version) {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            this.major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                this.minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.micro = Integer.parseInt(st.nextToken());
                }
            }
        }

        public String toString() {
            return String.valueOf(this.major) + SEPARATOR + this.minor + SEPARATOR + this.micro;
        }

        @Override
        public int compareTo(Version o) {
            if (o == this) {
                return 0;
            }
            int result = this.major - o.major;
            if (result != 0) {
                return result;
            }
            result = this.minor - o.minor;
            if (result != 0) {
                return result;
            }
            result = this.micro - o.micro;
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }
}

