/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.preferences;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.languagepreferences.Editor;
import org.eclipse.papyrus.uml.properties.languagepreferences.Language;
import org.eclipse.papyrus.uml.properties.languagepreferences.Preferences;
import org.eclipse.papyrus.uml.properties.languagepreferences.languagepreferencesFactory;
import org.eclipse.papyrus.uml.properties.widgets.BodyEditor;

public class LanguageRegistry {
    private Map<String, List<Editor>> languageMapping = new HashMap<String, List<Editor>>();
    private Preferences preferences;
    public static final LanguageRegistry instance = new LanguageRegistry();

    private LanguageRegistry() {
        IPath path = Activator.getDefault().getPreferencesPath();
        String preferencesPath = String.valueOf(path.toString()) + "/languagePreferences.xmi";
        URI preferencesURI = URI.createFileURI((String)preferencesPath);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            EObject preferencesObject = EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)preferencesURI);
            if (preferencesObject instanceof Preferences) {
                this.preferences = (Preferences)preferencesObject;
            } else {
                this.createPreferences((ResourceSet)resourceSet, preferencesURI);
            }
        }
        catch (IOException e) {
            this.createPreferences((ResourceSet)resourceSet, preferencesURI);
        }
    }

    private void createPreferences(ResourceSet resourceSet, URI preferencesURI) {
        this.preferences = languagepreferencesFactory.eINSTANCE.createPreferences();
        Editor defaultEditor = languagepreferencesFactory.eINSTANCE.createEditor();
        defaultEditor.setClass("org.eclipse.papyrus.uml.properties.widgets.NaturalLanguageEditor");
        defaultEditor.setBundleId("org.eclipse.papyrus.uml.properties");
        this.preferences.getEditors().add((Object)defaultEditor);
        this.preferences.setDefaultEditor(defaultEditor);
        Resource resource = resourceSet.createResource(preferencesURI);
        resource.getContents().add((Object)this.preferences);
        this.persist();
    }

    private void persist() {
        try {
            this.preferences.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public BodyEditor getEditorFor(String language) {
        List<Editor> editors;
        if (this.languageMapping.containsKey(language) && (editors = this.languageMapping.get(language)) != null && !editors.isEmpty()) {
            return this.getInstance(editors.get(0));
        }
        return this.getEditorFor("");
    }

    public void setDefaultEditorFor(String languageName, Editor editor) {
        if (!this.languageMapping.containsKey(languageName)) {
            this.languageMapping.put(languageName, new LinkedList());
        }
        List<Editor> availableEditors = this.languageMapping.get(languageName);
        availableEditors.removeAll(Collections.singleton(editor));
        availableEditors.add(0, editor);
        Language language = this.getLanguage(languageName);
        language.setPreferedEditor(editor);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void registerEditor(String language, Editor editor) {
        List<Editor> editors;
        if (language == null) {
            language = "";
        }
        if (!this.languageMapping.containsKey(language)) {
            this.languageMapping.put(language, new LinkedList());
        }
        if (!(editors = this.languageMapping.get(language)).contains(editor)) {
            editors.add(editor);
        }
    }

    private Language getLanguage(String name) {
        Language language2;
        for (Language language2 : this.preferences.getLanguages()) {
            if (!language2.getName().equals(name)) continue;
            return language2;
        }
        language2 = languagepreferencesFactory.eINSTANCE.createLanguage();
        language2.setName(name);
        this.preferences.getLanguages().add((Object)language2);
        return language2;
    }

    private BodyEditor getInstance(Editor editor) {
        return (BodyEditor)ClassLoaderHelper.newInstance((String)editor.getClass_(), BodyEditor.class, (String)editor.getBundleId());
    }

    public List<String> getLanguages() {
        LinkedList<String> result = new LinkedList<String>(this.languageMapping.keySet());
        result.remove("");
        Collections.sort(result);
        return result;
    }
}

