/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.EObjectTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLElementTreeAxisManagerForEventList
extends EObjectTreeAxisManagerForEventList {
    public boolean isAllowedContents(Object objectToTest, Object semanticParent, TreeFillingConfiguration conf, int depth) {
        return objectToTest instanceof Element && super.isAllowedContents(objectToTest, semanticParent, conf, depth);
    }

    public boolean canCreateAxisElement(String elementId) {
        if (elementId == null) {
            return false;
        }
        IElementType types = ElementTypeRegistry.getInstance().getType(elementId);
        if (types == null || types instanceof SpecializationType && ((SpecializationType)types).getMetamodelType() == null) {
            return false;
        }
        EClass eClass = types.getEClass();
        return eClass != null && eClass.getEPackage() == UMLPackage.eINSTANCE;
    }

    protected void manageSetNotification(Notification notification) {
        if (this.isStereotypeApplicationNotification(notification)) {
            this.manageStereotypeApplication(notification);
            return;
        }
        super.manageSetNotification(notification);
    }

    protected void manageUnsetNotification(Notification notification) {
        if (this.isStereotypeApplicationNotification(notification)) {
            this.manageStereotypeApplication(notification);
            return;
        }
        super.manageUnsetNotification(notification);
    }

    protected boolean ignoreEvent(Notification notification) {
        int event = notification.getEventType();
        Object notifier = notification.getNotifier();
        switch (event) {
            case 3: 
            case 4: {
                return notifier instanceof Resource && this.isStereotypeApplicationNotification(notification);
            }
        }
        return super.ignoreEvent(notification);
    }

    protected void manageStereotypeApplication(Notification notification) {
        Object feature = notification.getFeature();
        if (!(feature instanceof EReference)) {
            return;
        }
        EReference ref = (EReference)feature;
        if (ref.isContainment() || ref.isMany()) {
            return;
        }
        Object notifier = notification.getNotifier();
        if (!(notifier instanceof EObject)) {
            return;
        }
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        Element baseElement = null;
        if (oldValue instanceof Element) {
            baseElement = (Element)oldValue;
        } else if (newValue instanceof Element) {
            baseElement = (Element)newValue;
        }
        if (baseElement == null) {
            return;
        }
        Element owner = baseElement.getOwner();
        if (this.managedElements.containsKey(owner)) {
            Set parentRepresentation = (Set)this.managedElements.get(owner);
            for (ITreeItemAxis curr : parentRepresentation) {
                this.manageStereotypeApplication(curr, baseElement);
            }
        }
        if (FillingConfigurationUtils.hasTreeFillingConfigurationForDepth((Table)this.getTable(), (int)0)) {
            this.manageStereotypeApplication(null, baseElement);
        }
    }

    protected void manageStereotypeApplication(ITreeItemAxis semanticParent, Element baseElement) {
        Object context;
        int nextDepth = 0;
        if (semanticParent != null) {
            context = semanticParent.getElement();
            nextDepth = this.getSemanticDepth(semanticParent) + 1;
        } else {
            context = this.getTableContext();
        }
        List fillingConf = FillingConfigurationUtils.getTreeFillingConfigurationForDepth((Table)this.getTable(), (AxisManagerRepresentation)this.representedAxisManager, (int)nextDepth);
        for (TreeFillingConfiguration curr : fillingConf) {
            ITreeItemAxis toDestroy;
            Collection values = this.getFilteredValueAsCollection(curr, context, 0);
            ITreeItemAxis confRep = null;
            if (this.managedElements.containsKey(curr)) {
                Iterator iter = ((Set)this.managedElements.get(curr)).iterator();
                while (iter.hasNext() && confRep == null) {
                    ITreeItemAxis axis = (ITreeItemAxis)iter.next();
                    if (axis.getParent() != semanticParent) continue;
                    confRep = axis;
                }
            }
            if (values.isEmpty()) {
                if (confRep == null || (toDestroy = UMLElementTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection)confRep.getChildren(), (Object)baseElement)) == null) continue;
                this.removeObject(toDestroy);
                continue;
            }
            if (values.contains(baseElement)) {
                ITreeItemAxis stereotypedElementRep;
                if (confRep == null && (nextDepth == 0 || this.alreadyExpanded.contains(semanticParent))) {
                    confRep = this.addObject(null, curr);
                }
                if (nextDepth != 0 && !this.alreadyExpanded.contains(confRep) || (stereotypedElementRep = UMLElementTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection)confRep.getChildren(), (Object)baseElement)) != null) continue;
                ITreeItemAxis newAxis = this.addObject(confRep, baseElement);
                if (this.managedElements.containsKey(baseElement) || !this.alreadyExpanded.contains(confRep) && confRep.getParent() != null) continue;
                this.fillChildrenForSemanticElement(newAxis);
                continue;
            }
            toDestroy = UMLElementTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection)confRep.getChildren(), (Object)baseElement);
            if (toDestroy == null) continue;
            this.removeObject(toDestroy);
        }
    }

    protected boolean isStereotypeApplicationNotification(Notification notification) {
        Object feature;
        Object notifier = notification.getNotifier();
        return notifier instanceof EObject && (feature = notification.getFeature()) instanceof EReference && !((EReference)feature).isContainment() && ((EReference)feature).getName().startsWith("base_");
    }
}

