/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.WorkspaceCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.creation.ThemePropertyEditorFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.fieldeditor.IDynamicFieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.fieldeditor.InputComboFieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.ThemeManager;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFContentProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ThemePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String ICON_SELECTION_DIALOG_TITLE = "Icon selection";
    private static final String WORKSPACE_MENU_LABEL = "Workspace";
    private static final String FILE_SYSTEM_MENU_LABEL = "File System";
    private static final int WORKSPACE_MENU_ID = 12;
    private static final int FILESYSTEM_MENU_ID = 25;
    private static final String CURRENT_THEME_FIELD_LABEL = "Current theme:";
    private static final String PAGE_TITLE = "CSS Theme";
    private static final int DELETE_THEME_BUTTON_ID = 46;
    private static final int NEW_THEME_BUTTON_ID = 45;
    private static final int EDIT_BUTTON_ID = 19;
    private static final int DOWN_BUTTON_ID = 18;
    private static final int UP_BUTTON_ID = 17;
    private static final int DELETE_BUTTON_ID = 15;
    private static final int ADD_BUTTON_ID = 14;
    private static final int BROWSE_BUTTON_ID = 16;
    private static final String ADD_DIALOG_TITLE = "Style sheets selection";
    private static final Image EDIT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Edit_12x12.gif").createImage();
    private static final Image DELETE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Delete_12x12.gif").createImage();
    private static final Image ADD_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Add_12x12.gif").createImage();
    private static final Image UP_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Up_12x12.gif").createImage();
    private static final Image DOWN_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Down_12x12.gif").createImage();
    private static final String STYLE_SHEETS_LABEL = "Style sheets";
    private static final String BROWSE_BUTTON_LABEL = "Browse...";
    private static final String THEME_ICON_LABEL = "Icon";
    private static final String THEME_NAME_LABEL = "Label";
    private List<String> filterExtensions = Arrays.asList("*.gif;*.png;*.jpeg;*.jpg;*.bmp", "*.gif", "*.png", "*.jpeg;*.jpg", "*.*");
    private List<String> filterNames = Arrays.asList("All images", "GIF Icon", "PNG Icon", "JPEG Icon", "All");
    public boolean needsRefresh = false;
    private Composite mainContainer = null;
    private Text themeLabelField = null;
    protected Theme currentTheme = null;
    private Text iconPathfield = null;
    private TreeViewer themeStyleSheetsViewer = null;
    private LabelProvider labelProvider = null;
    private IDynamicFieldEditor themesCombo = null;
    private Map<Integer, Button> buttonsMap = new HashMap<Integer, Button>();
    private EcorePropertyEditorFactory editorFactory = new ThemePropertyEditorFactory(StylesheetsPackage.Literals.WORKSPACE_THEMES__THEMES);
    private Menu browseMenu = null;

    public ThemePreferencesPage() {
        super(PAGE_TITLE, org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageDescriptor("/icons/papyrus.png"), 1);
        this.initialiseFilterLabels(this.filterNames, this.filterExtensions);
    }

    private void initialiseFilterLabels(List<String> filterNames, List<String> filterExtensions) {
        int size = Math.min(filterNames.size(), filterExtensions.size());
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames.get(i)) + " (" + filterExtensions.get(i) + ")";
            ++i;
        }
        this.filterNames = Arrays.asList(filters);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Papyrus Theme preferences");
    }

    protected Control createContents(Composite parent) {
        this.mainContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainContainer.setLayout((Layout)layout);
        this.mainContainer.setFont(parent.getFont());
        this.createPreferenceThemePart(this.mainContainer);
        this.createThemeLabelPart(this.mainContainer);
        this.createThemeIconPart(this.mainContainer);
        this.createTreeActionButtons(this.mainContainer);
        this.createThemeStyleSheetsPart(this.mainContainer);
        this.initialize();
        this.checkState();
        return this.mainContainer;
    }

    private void createPreferenceThemePart(Composite parent) {
        this.createFieldEditors();
        Composite buttonsPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        buttonsPanel.setLayout((Layout)layout);
        buttonsPanel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createButton(buttonsPanel, 45, ADD_ICON, null);
        this.createButton(buttonsPanel, 46, DELETE_ICON, null);
    }

    protected void createFieldEditors() {
        String[][] themes = this.getFieldThemes();
        this.themesCombo = new InputComboFieldEditor("currentTheme", CURRENT_THEME_FIELD_LABEL, themes, this.mainContainer);
        this.addField((FieldEditor)this.themesCombo);
    }

    private void createThemeLabelPart(Composite parent) {
        Label themeNameLabel = new Label(parent, 0);
        themeNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        themeNameLabel.setText(THEME_NAME_LABEL);
        this.themeLabelField = new Text(parent, 2048);
        GridData gd_text = new GridData(4, 0x1000000, true, false, 2, 1);
        this.themeLabelField.setLayoutData((Object)gd_text);
        this.themeLabelField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThemePreferencesPage.this.currentTheme.setLabel(ThemePreferencesPage.this.themeLabelField.getText());
            }
        });
    }

    private void createThemeIconPart(Composite parent) {
        Label iconLabel = new Label(parent, 0);
        iconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        iconLabel.setText(THEME_ICON_LABEL);
        this.iconPathfield = new Text(parent, 2048);
        this.iconPathfield.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.iconPathfield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThemePreferencesPage.this.currentTheme.setIcon(ThemePreferencesPage.this.iconPathfield.getText());
            }
        });
        Button browseButton = this.createButton(parent, 16, null, BROWSE_BUTTON_LABEL);
        this.browseMenu = new Menu((Control)browseButton);
        this.createMenuItem(this.browseMenu, FILE_SYSTEM_MENU_LABEL, 25);
        this.createMenuItem(this.browseMenu, WORKSPACE_MENU_LABEL, 12);
    }

    private void createMenuItem(Menu parentMenu, String label, int menuId) {
        MenuItem menuItem = new MenuItem(parentMenu, 0);
        menuItem.setText(label);
        menuItem.setData((Object)new Integer(menuId));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePreferencesPage.this.menuSelected((Integer)e.widget.getData());
            }
        });
    }

    private void menuSelected(int menuId) {
        switch (menuId) {
            case 12: {
                this.browseWorkspace();
                break;
            }
            case 25: {
                this.browseFileSytem();
                break;
            }
        }
    }

    private void browseFileSytem() {
        File file = this.getFile(this.iconPathfield.getText());
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(ICON_SELECTION_DIALOG_TITLE);
        dialog.setFileName(file.getAbsolutePath());
        dialog.setFilterExtensions(this.filterExtensions.toArray(new String[this.filterExtensions.size()]));
        dialog.setFilterNames(this.filterNames.toArray(new String[this.filterNames.size()]));
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.setResult(result);
    }

    private void browseWorkspace() {
        Object file;
        Object[] result;
        int code;
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        ILabelProvider labelProvider = labelProviderService.getLabelProvider();
        IFile currentFile = this.getIFile(this.iconPathfield.getText());
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle(ICON_SELECTION_DIALOG_TITLE);
        WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
        if (!this.filterExtensions.isEmpty() && !this.filterNames.isEmpty()) {
            contentProvider.setExtensionFilters(new LinkedHashMap());
            int i = 0;
            while (i < Math.min(this.filterNames.size(), this.filterExtensions.size())) {
                contentProvider.addExtensionFilter(this.filterExtensions.get(i), this.filterNames.get(i));
                ++i;
            }
        }
        dialog.setContentProvider((ITreeContentProvider)contentProvider);
        dialog.setLabelProvider(labelProvider);
        if (currentFile != null && currentFile.exists()) {
            dialog.setInitialSelections((Object[])new IFile[]{currentFile});
        }
        if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
            this.setResult((IFile)file);
        }
    }

    protected void setResult(IFile file) {
        this.iconPathfield.setText(file.getFullPath().toString());
    }

    protected void setResult(File file) {
        this.iconPathfield.setText(file.getAbsolutePath());
    }

    protected void setResult(String path) {
        this.iconPathfield.setText(path);
    }

    protected IFile getIFile(String path) {
        return FileUtil.getIFile((String)path);
    }

    protected File getFile(String path) {
        return FileUtil.getFile((String)path);
    }

    private void createThemeStyleSheetsPart(Composite parent) {
        this.themeStyleSheetsViewer = new TreeViewer(parent, 2048);
        this.themeStyleSheetsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.labelProvider = new LabelProvider(){

            public String getText(Object element) {
                String text = super.getText(element);
                if (element instanceof StyleSheetReference) {
                    text = ((StyleSheetReference)element).getPath();
                } else if (element instanceof EmbeddedStyleSheet) {
                    text = ((EmbeddedStyleSheet)element).getLabel();
                }
                return text;
            }
        };
        this.themeStyleSheetsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Tree tree = this.themeStyleSheetsViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
    }

    private void createTreeActionButtons(Composite parent) {
        Label labelViewer = new Label(parent, 0);
        labelViewer.setText(STYLE_SHEETS_LABEL);
        Composite buttonsPanel = new Composite(parent, 0);
        buttonsPanel.setLayout((Layout)new GridLayout());
        buttonsPanel.setLayoutData((Object)new GridData(131072, 4, true, false, 2, 1));
        this.createButton(buttonsPanel, 14, ADD_ICON, null);
        this.createButton(buttonsPanel, 15, DELETE_ICON, null);
        this.createButton(buttonsPanel, 17, UP_ICON, null);
        this.createButton(buttonsPanel, 18, DOWN_ICON, null);
        this.createButton(buttonsPanel, 19, EDIT_ICON, null);
    }

    protected Button createButton(Composite parent, int id, Image icon, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ThemePreferencesPage.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (label != null) {
            button.setText(label);
        }
        if (icon != null) {
            button.setImage(icon);
        }
        this.buttonsMap.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 14: {
                this.addAction();
                break;
            }
            case 15: {
                this.deleteAction();
                break;
            }
            case 16: {
                this.browseMenu.setVisible(true);
                break;
            }
            case 17: {
                this.upAction();
                break;
            }
            case 18: {
                this.downAction();
                break;
            }
            case 19: {
                this.editAction();
                break;
            }
            case 45: {
                this.addThemeAction();
                break;
            }
            case 46: {
                this.deleteThemeAction();
            }
        }
    }

    private void deleteAction() {
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof StyleSheet) {
                this.currentTheme.getStylesheets().remove(selectedElement);
            }
            this.themeStyleSheetsViewer.setInput((Object)this.currentTheme.getStylesheets());
            this.refreshTreeviewer(this.currentTheme);
        }
    }

    private void addAction() {
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)new EMFContentProvider((EObject)this.currentTheme, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getTheme_Stylesheets()){

            protected IStructuredContentProvider getSemanticProvider(final EObject editedEObject, EStructuralFeature feature) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        LinkedList result = new LinkedList();
                        if (editedEObject instanceof Theme) {
                            result.addAll((this).ThemePreferencesPage.this.currentTheme.getStylesheets());
                        }
                        return result.toArray();
                    }
                };
            }
        });
        selector.setLabelProvider((ILabelProvider)this.labelProvider);
        MultipleValueSelectorDialog vDialog = new MultipleValueSelectorDialog(this.getShell(), (IElementSelector)selector, ADD_DIALOG_TITLE);
        vDialog.setContextElement((Object)this.currentTheme);
        vDialog.setLabelProvider((ILabelProvider)this.labelProvider);
        vDialog.setFactory((ReferenceValueFactory)new EcorePropertyEditorFactory(StylesheetsPackage.Literals.THEME__STYLESHEETS));
        int result = vDialog.open();
        if (result == 0) {
            Object[] resultArray = vDialog.getResult();
            this.refreshStyleSheets(resultArray);
        }
    }

    private void refreshStyleSheets(Object[] result) {
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof StyleSheet) {
                this.currentTheme.getStylesheets().add((Object)((StyleSheet)object));
            }
            ++n2;
        }
        this.needsRefresh = true;
        this.refreshTreeviewer(this.currentTheme);
    }

    private void refreshTreeviewer(Theme currentTheme) {
        boolean isEditatble = ThemeManager.instance.isEditable(currentTheme.getId());
        EList themeStyleSheetsList = currentTheme.getStylesheets();
        this.themeStyleSheetsViewer.getTree().setEnabled(isEditatble);
        this.themeStyleSheetsViewer.setInput((Object)themeStyleSheetsList);
        this.updateButtons(currentTheme);
    }

    private void upAction() {
        Object selectedElement;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet) {
            EList stylesheetsList = this.currentTheme.getStylesheets();
            int index = stylesheetsList.indexOf(selectedElement);
            if (index > 0) {
                stylesheetsList.move(--index, (Object)((StyleSheet)selectedElement));
                this.themeStyleSheetsViewer.setInput((Object)stylesheetsList);
            }
            this.needsRefresh = true;
        }
    }

    private void downAction() {
        Object selectedElement;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet) {
            EList stylesheetsList = this.currentTheme.getStylesheets();
            int index = stylesheetsList.indexOf(selectedElement);
            if (index < stylesheetsList.size() - 1) {
                stylesheetsList.move(++index, (Object)((StyleSheet)selectedElement));
                this.themeStyleSheetsViewer.setInput((Object)stylesheetsList);
            }
            this.needsRefresh = true;
        }
    }

    private void editAction() {
        Object selectedObject;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet) {
            this.editorFactory.edit((Control)this.buttonsMap.get(19), selectedObject);
            this.needsRefresh = true;
        }
    }

    private void addThemeAction() {
        ThemeManager themeManager = ThemeManager.instance;
        Object createdObject = this.editorFactory.createObject((Control)this.buttonsMap.get(45), (Object)themeManager.getWorkspaceThemesPreferences());
        if (createdObject instanceof Theme) {
            themeManager.addTemporaryTheme((Theme)createdObject);
            this.currentTheme = (Theme)createdObject;
            this.themesCombo.setInput(this.getFieldThemes());
            this.themesCombo.setSelection(((Theme)createdObject).getId());
        }
    }

    private void deleteThemeAction() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete CSS theme", (String)"WARNING! Deletion will be difinitive.\nDo you really want to delete this theme ?");
        if (confirm) {
            ThemeManager themeManager = ThemeManager.instance;
            themeManager.delete(this.currentTheme);
            String[][] fieldThemes = this.getFieldThemes();
            this.themesCombo.setInput(fieldThemes);
            this.currentTheme = themeManager.getTheme(fieldThemes[0][1]);
            this.themesCombo.setSelection(this.currentTheme.getId());
        }
    }

    private void updateButtons(Theme currentTheme) {
        boolean editionEnable = ThemeManager.instance.isEditable(currentTheme.getId());
        for (int buttonId : this.buttonsMap.keySet()) {
            switch (buttonId) {
                case 14: 
                case 16: {
                    this.buttonsMap.get(buttonId).setEnabled(editionEnable);
                    break;
                }
                case 15: 
                case 19: {
                    this.buttonsMap.get(buttonId).setEnabled(editionEnable && !currentTheme.getStylesheets().isEmpty());
                    break;
                }
                case 17: 
                case 18: {
                    this.buttonsMap.get(buttonId).setEnabled(editionEnable && currentTheme.getStylesheets().size() > 1);
                }
                case 46: {
                    this.buttonsMap.get(buttonId).setEnabled(ThemeManager.instance.isEditable(currentTheme.getId()));
                }
            }
        }
    }

    protected GridData setButtonLayoutData(Button button) {
        GridData layoutData = null;
        Object data = button.getData();
        int buttonId = -1;
        if (data instanceof Integer) {
            buttonId = (Integer)data;
        }
        switch (buttonId) {
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 45: 
            case 46: {
                layoutData = new GridData(4, 4, false, false);
                button.setLayoutData((Object)layoutData);
                break;
            }
            default: {
                layoutData = super.setButtonLayoutData(button);
            }
        }
        return layoutData;
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor fieldEditor;
        super.propertyChange(event);
        if ("currentTheme".equals(event.getProperty())) {
            this.needsRefresh = true;
        }
        if ("field_editor_value".equals(event.getProperty()) && "currentTheme".equals((fieldEditor = (FieldEditor)event.getSource()).getPreferenceName())) {
            Object newValue = event.getNewValue();
            ThemeManager themeManager = ThemeManager.instance;
            this.currentTheme = themeManager.getTheme(String.valueOf(newValue));
            this.refreshPreferencePage();
        }
    }

    protected void refreshPreferencePage() {
        String themeLabel = this.currentTheme.getLabel();
        boolean editableTheme = ThemeManager.instance.isEditable(this.currentTheme.getId());
        this.needsRefresh = true;
        if (themeLabel == null) {
            themeLabel = "";
        }
        this.themeLabelField.setEnabled(editableTheme);
        this.themeLabelField.setText(themeLabel);
        String iconPath = this.currentTheme.getIcon();
        if (iconPath == null) {
            iconPath = "";
        }
        this.iconPathfield.setEnabled(editableTheme);
        this.iconPathfield.setText(iconPath);
        this.refreshTreeviewer(this.currentTheme);
    }

    protected void initialize() {
        String prefrenceValue = this.getPreferenceStore().getString("currentTheme");
        this.currentTheme = ThemeManager.instance.getTheme(prefrenceValue);
        this.refreshPreferencePage();
        super.initialize();
    }

    protected void performApply() {
        super.performApply();
        this.themesCombo.setInput(this.getFieldThemes());
        this.refreshPreferencePage();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.needsRefresh) {
            WorkspaceCSSEngine.instance.reset();
            DiagramHelper.forceRefresh();
        }
        ThemeManager themeManager = ThemeManager.instance;
        themeManager.persist();
        return result;
    }

    public boolean performCancel() {
        ThemeManager.instance.reloadThemes();
        ThemeManager.instance.clearTemporaryThemes();
        ThemeManager.instance.clearDeletedThemes();
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.currentTheme = ThemeManager.instance.getTheme(this.getPreferenceStore().getDefaultString("currentTheme"));
        this.refreshPreferencePage();
    }

    protected String[][] getFieldThemes() {
        ThemeManager themeManager = ThemeManager.instance;
        themeManager.refreshThemes();
        List themes = themeManager.getThemes();
        String[][] result = new String[themes.size()][2];
        int i = 0;
        for (Theme theme : themes) {
            result[i][0] = theme.getLabel();
            result[i][1] = theme.getId();
            ++i;
        }
        return result;
    }
}

