/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ProjectManagementUtils {
    public static IPluginModelBase getPluginModelBase(IProject project) {
        return PluginRegistry.findModel((IProject)project);
    }

    public static List<IPluginExtension> getPluginExtensions(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        return pluginModelBase != null ? Arrays.asList(pluginModelBase.getExtensions().getExtensions()) : Collections.emptyList();
    }

    public static List<BundleSpecification> getPluginDependencies(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        return pluginModelBase != null ? Arrays.asList(pluginModelBase.getBundleDescription().getRequiredBundles()) : Collections.emptyList();
    }

    public static IBuildModel getPluginBuild(IProject project) {
        IPluginModelBase pluginModelBase = ProjectManagementUtils.getPluginModelBase(project);
        if (pluginModelBase != null) {
            try {
                return PluginRegistry.createBuildModel((IPluginModelBase)pluginModelBase);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean existFileFromProject(IContainer container, String foundFile, boolean isExtensionCheck) {
        boolean result = false;
        try {
            Iterator<IResource> members = Arrays.asList(container.members()).iterator();
            while (members.hasNext() && !result) {
                IResource member = members.next();
                if (member instanceof IFile && ProjectManagementUtils.isCorrespondingFile((IFile)member, foundFile, isExtensionCheck)) {
                    result = true;
                    continue;
                }
                if (!(member instanceof IContainer)) continue;
                result = ProjectManagementUtils.existFileFromProject((IContainer)member, foundFile, isExtensionCheck);
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    public static Collection<IFile> getFilesFromProject(IContainer container, String foundFile, boolean isExtensionCheck) {
        HashSet<IFile> result = new HashSet<IFile>();
        try {
            for (IResource member : Arrays.asList(container.members())) {
                if (member instanceof IFile && ProjectManagementUtils.isCorrespondingFile((IFile)member, foundFile, isExtensionCheck)) {
                    result.add((IFile)member);
                    continue;
                }
                if (!(member instanceof IContainer)) continue;
                result.addAll(ProjectManagementUtils.getFilesFromProject((IContainer)member, foundFile, isExtensionCheck));
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    public static IFile getManifestFile(IContainer container) {
        Collection<IFile> manifestFiles = ProjectManagementUtils.getFilesFromProject(container, "MANIFEST.MF", false);
        return manifestFiles.isEmpty() ? null : manifestFiles.iterator().next();
    }

    public static IFile getPluginXMLFile(IContainer container) {
        Collection<IFile> pluginXMLFiles = ProjectManagementUtils.getFilesFromProject(container, "plugin.xml", false);
        return pluginXMLFiles.isEmpty() ? null : pluginXMLFiles.iterator().next();
    }

    public static IFile getBuildFile(IContainer container) {
        Collection<IFile> buildPropertiesFiles = ProjectManagementUtils.getFilesFromProject(container, "build.properties", false);
        return buildPropertiesFiles.isEmpty() ? null : buildPropertiesFiles.iterator().next();
    }

    private static boolean isCorrespondingFile(IFile file, String foundFile, boolean isExtensionCheck) {
        return isExtensionCheck ? file.getName().endsWith("." + foundFile) : file.getName().equals(foundFile);
    }
}

