/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.osgi.framework.Bundle;

public class MDTUtil {
    private static final String[] getNameNames = new String[]{"getName", "getname"};

    public static String getEditorVersion(IEditorPart editor) {
        return MDTUtil.getBundleVersion(editor.getSite().getPluginId());
    }

    public static String getBundleVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        return version;
    }

    public static IPath getWorkspaceLocation() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        catch (NullPointerException ex) {
            Status status = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.common", "Error getting workspace", (Throwable)ex);
            Activator.getInstance().getLog().log((IStatus)status);
            return null;
        }
    }

    public static String fullFilePathToResource(String filePath) {
        String workspaceLocation = MDTUtil.getWorkspaceLocation().toString();
        return filePath.replaceFirst(workspaceLocation, "");
    }

    public static URI fullFilePathToResourceURI(String filePath) {
        String uri = MDTUtil.fullFilePathToResource(filePath);
        return URI.createPlatformResourceURI((String)uri, (boolean)true);
    }

    public static Diagram getDiagramFomEditor(IEditorPart editor) {
        Object adapted;
        if (editor instanceof DiagramEditor) {
            return ((DiagramEditor)editor).getDiagram();
        }
        if (editor != null && (adapted = editor.getAdapter(Diagram.class)) instanceof Diagram) {
            return (Diagram)adapted;
        }
        return null;
    }

    public static Resource getRootElementResource(IEditorPart editorPart) {
        EObject rootElement = MDTUtil.getEditorRootelement(editorPart);
        Resource resource = null;
        if (rootElement != null) {
            resource = rootElement.eResource();
        }
        return resource;
    }

    public static EObject getEditorRootelement(IEditorPart editorPart) {
        EditPart rootEditPart = (EditPart)editorPart.getAdapter(EditPart.class);
        if (rootEditPart == null) {
            return null;
        }
        EObject rootElement = null;
        Object object = ((EditPart)rootEditPart.getChildren().get(0)).getModel();
        if (object instanceof View) {
            rootElement = ((View)object).getElement();
        }
        return rootElement;
    }

    @Deprecated
    public static List<EObject> getRootElementsFromFile(IEditorInput input) {
        assert (false) : "use the getRootElementsFromFile(IEditorInput, ResourceSet) API";
        return MDTUtil.getRootElementsFromFile(input, null);
    }

    public static List<EObject> getRootElementsFromFile(IEditorInput input, ResourceSet resourceSet) {
        Resource resource;
        URI uri = null;
        IURIEditorInput uriEditorInput = (IURIEditorInput)Platform.getAdapterManager().getAdapter((Object)input, IURIEditorInput.class);
        if (uriEditorInput != null) {
            uri = URI.createURI((String)uriEditorInput.getURI().toString());
        } else {
            IFileEditorInput fileEditorInput = (IFileEditorInput)Platform.getAdapterManager().getAdapter((Object)input, IFileEditorInput.class);
            if (fileEditorInput != null) {
                uri = URI.createURI((String)fileEditorInput.getFile().getLocationURI().toString());
            }
        }
        if (uri != null && (resource = resourceSet.getResource(uri, true)) != null) {
            ArrayList<EObject> rootEObjects = new ArrayList<EObject>();
            for (EObject eObject : resource.getContents()) {
                rootEObjects.add(eObject);
            }
            return rootEObjects;
        }
        return Collections.emptyList();
    }

    public static String getObjectNameOrEmptyString(Object object) {
        String name = MDTUtil.getObjectName(object);
        return name == null ? "" : name;
    }

    public static String getObjectName(Object object) {
        if (object == null) {
            return null;
        }
        Method method = null;
        Object o = null;
        String[] stringArray = getNameNames;
        int n = getNameNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            try {
                method = object.getClass().getMethod(methodName, null);
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            if (method != null) break;
            ++n2;
        }
        if (method != null) {
            try {
                o = method.invoke(object, null);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            if (o instanceof String) {
                return (String)o;
            }
        }
        return null;
    }

    public static EObject resolveSemantic(Object object) {
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        }
        if (object instanceof View) {
            object = ((View)object).getElement();
        }
        if (object instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    public static EObject searchEObjectFromFragment(URI uri, ResourceSet resourceSet) {
        if (uri == null) {
            return null;
        }
        String uriFragment = uri.fragment();
        if (uriFragment != null && uriFragment.length() > 0 && resourceSet != null) {
            resourceSet.getResource(uri.trimFragment(), true);
            for (Resource resource : resourceSet.getResources()) {
                EObject eObject = MDTUtil.searchEObjectFromFragment(uriFragment, resource);
                if (eObject == null) continue;
                return eObject;
            }
        }
        return null;
    }

    public static EObject searchEObjectFromFragment(String uriFragment, Resource resource) {
        if (uriFragment != null && uriFragment.length() > 0 && resource != null) {
            return resource.getEObject(uriFragment);
        }
        return null;
    }

    public static Diagram getFirstDiagramFromResource(Resource resource) {
        if (resource != null && resource.getContents().size() > 0) {
            for (EObject eObject : resource.getContents()) {
                Diagram diagram = (Diagram)Platform.getAdapterManager().getAdapter((Object)eObject, Diagram.class);
                if (diagram == null) continue;
                return diagram;
            }
        }
        return null;
    }

    public static boolean isOfType(Class<?> clazz, String className) {
        if (clazz == null || className == null) {
            return false;
        }
        if (clazz.getName().equals(className)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (MDTUtil.isOfType(c, className)) {
                return true;
            }
            ++n2;
        }
        return MDTUtil.isOfType(clazz.getSuperclass(), className);
    }

    public static IEditorPart getActiveEditor() {
        return EditorHelper.getCurrentEditor();
    }
}

