/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.SyncItem;

public abstract class NodeSizeSyncDispatcher<M extends EObject, T extends EditPart>
extends EMFDispatch {
    protected SyncItem<M, T> item;
    protected int currentWidth;
    protected int currentHeight;

    public NodeSizeSyncDispatcher(SyncItem<M, T> item) {
        this.item = item;
        Size size = (Size)((Node)((EditPart)item.getBackend()).getModel()).getLayoutConstraint();
        this.currentWidth = size.getWidth();
        this.currentHeight = size.getHeight();
    }

    public SyncItem<M, T> getItem() {
        return this.item;
    }

    public EObject getNotifier() {
        Node node = (Node)((EditPart)this.item.getBackend()).getModel();
        return node.getLayoutConstraint();
    }

    public EStructuralFeature getFeature() {
        return null;
    }

    public void onChange(Notification notification) {
        Object feature = notification.getFeature();
        if (feature == NotationPackage.Literals.SIZE__WIDTH || feature == NotationPackage.Literals.SIZE__HEIGHT) {
            Object lc = notification.getNotifier();
            Size size = (Size)lc;
            int width = size.getWidth();
            int height = size.getHeight();
            if (this.currentWidth != width || this.currentHeight != height) {
                this.onFilteredChange(notification);
                this.currentWidth = width;
                this.currentHeight = height;
            }
        }
    }

    protected abstract void onFilteredChange(Notification var1);
}

