/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.runner;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.eclipse.papyrus.junit.framework.classification.ClassificationConfig;
import org.eclipse.papyrus.junit.framework.runner.IgnoreRunner;
import org.eclipse.papyrus.junit.framework.runner.Scenario;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;

public class ScenarioRunner
extends ParentRunner<Runner> {
    private static final Deque<VerificationPointsRunner> runnerStack = new ArrayDeque<VerificationPointsRunner>();

    public ScenarioRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<Runner> getChildren() {
        Iterable methods = Iterables.concat((Iterable)this.getTestClass().getAnnotatedMethods(Test.class), (Iterable)this.getTestClass().getAnnotatedMethods(Scenario.class));
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)methods, (Function)new Function<FrameworkMethod, Runner>(){

            public Runner apply(FrameworkMethod input) {
                return new VerificationPointsRunnerBuilder(input).build();
            }
        }));
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        if (!(child instanceof VerificationPointsRunner)) {
            child.run(notifier);
        } else {
            VerificationPointsRunner points = (VerificationPointsRunner)child;
            ScenarioRunner.pushRunner(points);
            points.start();
            try {
                points.run(notifier);
            }
            finally {
                points.finish();
                ScenarioRunner.popRunner();
            }
        }
    }

    public static boolean verificationPoint() {
        return ScenarioRunner.currentRunner().verificationPoint();
    }

    private static VerificationPointsRunner currentRunner() {
        return runnerStack.getLast();
    }

    private static VerificationPointsRunner popRunner() {
        return runnerStack.removeLast();
    }

    private static void pushRunner(VerificationPointsRunner runner) {
        runnerStack.addLast(runner);
    }

    static boolean isIgnored(Annotation[] testAnnotations) {
        boolean result;
        boolean bl = result = !ClassificationConfig.shouldRun(testAnnotations);
        if (!result) {
            result = Iterators.filter(Arrays.asList(testAnnotations).iterator(), Ignore.class).hasNext();
        }
        return result;
    }

    static class JUnitAccess
    extends BlockJUnit4ClassRunner {
        public JUnitAccess(Class<?> testClass) throws InitializationError {
            super(testClass);
        }

        protected Statement methodBlock(FrameworkMethod method) {
            return super.methodBlock(method);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            ArrayList result = Lists.newArrayList((Iterable)this.getTestClass().getAnnotatedMethods(Scenario.class));
            result.addAll(this.getTestClass().getAnnotatedMethods(Test.class));
            return result;
        }

        Runner classicTest(final FrameworkMethod testMethod) {
            return new Runner(){

                public void run(RunNotifier notifier) {
                    this.runLeaf(this.methodBlock(testMethod), this.getDescription(), notifier);
                }

                public Description getDescription() {
                    return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)testMethod.getName(), (Annotation[])testMethod.getAnnotations());
                }
            };
        }
    }

    private class VerificationPointsRunner
    extends ParentRunner<String> {
        private final FrameworkMethod scenarioMethod;
        private final Scenario scenario;
        private final JUnitAccess junit;
        private List<String> verpts;
        private int nextVerificationPoint;
        private Failure lastFailure;

        VerificationPointsRunner(FrameworkMethod scenarioMethod) throws InitializationError {
            super(scenarioMethod.getMethod().getDeclaringClass());
            this.verpts = Lists.newArrayList();
            this.scenarioMethod = scenarioMethod;
            this.scenario = (Scenario)scenarioMethod.getAnnotation(Scenario.class);
            this.junit = new JUnitAccess(scenarioMethod.getMethod().getDeclaringClass());
        }

        public Description getDescription() {
            Description result = Description.createSuiteDescription((String)this.scenarioMethod.getName(), (Annotation[])this.scenarioMethod.getAnnotations());
            for (Description child : super.getDescription().getChildren()) {
                result.addChild(child);
            }
            return result;
        }

        protected List<String> getChildren() {
            return Arrays.asList(this.scenario.value());
        }

        protected Description describeChild(String child) {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)(String.valueOf(this.scenarioMethod.getName()) + ":" + child));
        }

        protected void runChild(String child, RunNotifier notifier) {
            Description description = this.describeChild(child);
            if (this.verpts.contains(child)) {
                if (this.verpts.get(0).equals(child)) {
                    if (!this.runScenario(child, description, notifier)) {
                        this.nextVerificationPoint = 0;
                    }
                } else {
                    Object last = this.lastFailure == null ? new AssertionError((Object)"Previous execution failed") : this.lastFailure.getException();
                    notifier.fireTestStarted(description);
                    notifier.fireTestFailure(new Failure(description, (Throwable)last));
                    this.lastFailure = null;
                    notifier.fireTestFinished(description);
                }
            } else if (this.failedLastTime(child)) {
                notifier.fireTestStarted(description);
                notifier.fireTestFailure(new Failure(description, this.lastFailure.getException()));
                this.lastFailure = null;
                notifier.fireTestFinished(description);
            } else {
                notifier.fireTestStarted(description);
                notifier.fireTestFinished(description);
            }
        }

        void start() {
            this.verpts.addAll(this.getChildren());
            this.nextVerificationPoint = 0;
        }

        boolean verificationPoint() {
            String[] points = this.scenario.value();
            boolean result = this.nextVerificationPoint < points.length && this.verpts.contains(points[this.nextVerificationPoint]);
            ++this.nextVerificationPoint;
            int limit = Math.min(this.nextVerificationPoint, points.length);
            int i = 0;
            while (i < limit) {
                this.verpts.remove(points[i]);
                ++i;
            }
            return result;
        }

        String currentVerificationPoint() {
            String[] points = this.scenario.value();
            int index = Math.max(0, Math.min(this.nextVerificationPoint - 1, points.length - 1));
            return points[index];
        }

        boolean failedLastTime(String child) {
            boolean result;
            boolean bl = result = this.lastFailure != null;
            if (result) {
                String[] points = this.scenario.value();
                if (this.verpts.isEmpty()) {
                    result = points[points.length - 1].equals(child);
                } else {
                    int successor = Math.max(Arrays.asList(points).indexOf(child) + 1, points.length - 1);
                    result = this.verpts.contains(points[successor]);
                }
            }
            return result;
        }

        void finish() {
            this.verpts.clear();
            this.nextVerificationPoint = this.scenario.value().length;
            this.lastFailure = null;
        }

        private boolean runScenario(final String child, Description description, final RunNotifier notifier) {
            final boolean[] result = new boolean[]{true};
            RunNotifier notifierWrapper = new RunNotifier(){

                public void fireTestFailure(Failure failure) {
                    result[0] = false;
                    if (child.equals(VerificationPointsRunner.this.currentVerificationPoint())) {
                        notifier.fireTestFailure(failure);
                    } else {
                        VerificationPointsRunner.this.lastFailure = failure;
                    }
                }

                public void fireTestAssumptionFailed(Failure failure) {
                    result[0] = false;
                    if (child.equals(VerificationPointsRunner.this.currentVerificationPoint())) {
                        notifier.fireTestAssumptionFailed(failure);
                    } else {
                        VerificationPointsRunner.this.lastFailure = failure;
                    }
                }

                public void fireTestIgnored(Description description) {
                    notifier.fireTestIgnored(description);
                }

                public void fireTestStarted(Description description) throws StoppedByUserException {
                    notifier.fireTestStarted(description);
                }

                public void fireTestFinished(Description description) {
                    notifier.fireTestFinished(description);
                }
            };
            this.runLeaf(this.junit.methodBlock(this.scenarioMethod), description, notifierWrapper);
            return result[0];
        }
    }

    private class VerificationPointsRunnerBuilder
    extends RunnerBuilder {
        private final FrameworkMethod scenarioMethod;

        VerificationPointsRunnerBuilder(FrameworkMethod scenarioMethod) {
            this.scenarioMethod = scenarioMethod;
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            Object result = this.scenarioMethod.getAnnotation(Scenario.class) != null ? new VerificationPointsRunner(this.scenarioMethod) : new JUnitAccess(testClass).classicTest(this.scenarioMethod);
            ArrayList allAnnotations = Lists.newArrayList((Object[])this.scenarioMethod.getAnnotations());
            allAnnotations.addAll(Arrays.asList(this.scenarioMethod.getMethod().getDeclaringClass().getAnnotations()));
            if (ScenarioRunner.isIgnored((Annotation[])Iterables.toArray((Iterable)allAnnotations, Annotation.class))) {
                result = new IgnoreRunner(result.getDescription());
            }
            return result;
        }

        public Runner build() {
            return this.safeRunnerForClass(this.scenarioMethod.getMethod().getDeclaringClass());
        }
    }
}

