/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.classification;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.junit.framework.classification.ClassificationConfig;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;

public class ClassificationSuite
extends Suite {
    private static final LoadingCache<Description, Boolean> enabledSuites = CacheBuilder.newBuilder().build(CacheLoader.from(ClassificationSuite::isEnabled));
    private Description description;

    public ClassificationSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        this(builder, klass, ClassificationSuite.getAnnotatedClasses(klass));
    }

    public ClassificationSuite(Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(klass, (Class[])ClassificationSuite.withDynamicSuites(klass, suiteClasses));
    }

    public ClassificationSuite(RunnerBuilder builder, Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(builder, klass, (Class[])ClassificationSuite.withDynamicSuites(klass, suiteClasses));
    }

    private static Class<?>[] getAnnotatedClasses(Class<?> class_) throws InitializationError {
        Suite.SuiteClasses annotation = class_.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", class_.getName()));
        }
        return annotation.value();
    }

    private static Class<?>[] withDynamicSuites(Class<?> suiteClass, Class<?>[] staticSuites) {
        Class<?>[] result = staticSuites;
        Object[] dynamicSuites = ClassificationSuite.getDynamicSuites(suiteClass);
        if (dynamicSuites.length > 0) {
            result = (Class[])ObjectArrays.concat((Object[])staticSuites, (Object[])dynamicSuites, Class.class);
        }
        return result;
    }

    private static Class<?>[] getDynamicSuites(Class<?> suiteClass) {
        ArrayList result;
        DynamicClasses dynclasses = suiteClass.getAnnotation(DynamicClasses.class);
        if (dynclasses == null) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayListWithCapacity((int)dynclasses.value().length);
            String[] stringArray = dynclasses.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String classname = stringArray[n2];
                try {
                    result.add(suiteClass.getClassLoader().loadClass(classname));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return (Class[])Iterables.toArray((Iterable)result, Class.class);
    }

    protected List<Runner> getChildren() {
        if (ClassificationConfig.shouldRun(this.getRunnerAnnotations())) {
            return super.getChildren();
        }
        return Collections.emptyList();
    }

    public void run(RunNotifier notifier) {
        if (ClassificationConfig.shouldRun(this.getRunnerAnnotations())) {
            super.run(notifier);
        } else {
            Description description = this.getDescription();
            notifier.fireTestIgnored(description);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        return (Boolean)enabledSuites.getUnchecked((Object)this.getDescription()) != false ? super.classBlock(notifier) : this.skipAll(notifier);
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = super.getDescription();
        }
        return this.description;
    }

    protected Statement skipAll(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                ClassificationSuite.this.skipAll(ClassificationSuite.this.getDescription(), notifier);
            }
        };
    }

    protected void skipAll(Description suite, RunNotifier notifier) {
        for (Description next : suite.getChildren()) {
            if (next.isSuite()) {
                this.skipAll(next, notifier);
                continue;
            }
            notifier.fireTestIgnored(next);
        }
        notifier.fireTestIgnored(suite);
    }

    static boolean isEnabled(Description suite) {
        boolean result = false;
        for (Description leaf : ClassificationSuite.getLeafTests(suite)) {
            Iterable annotations = Iterables.concat((Iterable)leaf.getAnnotations(), Arrays.asList(leaf.getTestClass().getAnnotations()));
            if (!ClassificationConfig.shouldRun((Annotation[])Iterables.toArray((Iterable)annotations, Annotation.class))) continue;
            result = true;
            break;
        }
        return result;
    }

    static Iterable<Description> getLeafTests(final Description suite) {
        return new Iterable<Description>(){

            @Override
            public Iterator<Description> iterator() {
                return new AbstractIterator<Description>(suite){
                    Deque<Iterator<Description>> stack = new ArrayDeque<Iterator<Description>>();
                    Iterator<Description> current;
                    {
                        this.current = description.getChildren().iterator();
                    }

                    Iterator<Description> feed() {
                        while (!this.current.hasNext()) {
                            this.current = this.stack.pollLast();
                            if (this.current != null) continue;
                            this.current = Collections.emptyIterator();
                            break;
                        }
                        return this.current;
                    }

                    void push(Description suite) {
                        this.stack.addLast(this.current);
                        this.current = suite.getChildren().iterator();
                    }

                    protected Description computeNext() {
                        Description result = null;
                        while (result == null && this.feed().hasNext()) {
                            Description next = this.feed().next();
                            if (next.isTest() && next.getTestClass() != null) {
                                result = next;
                                continue;
                            }
                            if (next.isSuite()) {
                                this.push(next);
                                continue;
                            }
                            System.err.println("Leaf test without a class: " + next);
                        }
                        if (result == null) {
                            result = (Description)this.endOfData();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DynamicClasses {
        public String[] value();
    }
}

