/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.editor.DiagramEditorUtil;

@Singleton
@SuppressWarnings("all")
public class DocumentProvider extends xpt.editor.DocumentProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  @Override
  public CharSequence setDocumentContent(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setDocumentContent(org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, org.eclipse.ui.IEditorInput element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain domain = diagramDocument.getEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("if (element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IStorage storage = ((");
        CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName_1, "\t\t");
        _builder.append(") element).getStorage();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil.load(domain, storage, true, getProgressMonitor());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("document.setContent(diagram);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if(element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.common.util.URI uri = ((");
    CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName_1, "\t\t");
    _builder.append(") element).getURI();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("resource = domain.getResourceSet().getResource(uri.trimFragment(), false);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (resource == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("resource = domain.getResourceSet().createResource(uri.trimFragment());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!resource.isLoaded()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("@SuppressWarnings({ \"rawtypes\", \"unchecked\" })");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("java.util.Map<?,?> options = new java.util.HashMap(org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory.getDefaultLoadOptions());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("// @see 171060 ");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("// options.put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("resource.load(options);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("resource.unload();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("throw e;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (uri.fragment() != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject rootElement = resource.getEObject(uri.fragment());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("document.setContent(rootElement);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.EObject> it = resource.getContents().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("Object rootElement = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("document.setContent(rootElement);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new RuntimeException(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderNoDiagramInResourceError(it));
    _builder.append(_accessorCall, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.runtime.CoreException thrownExcp = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (e instanceof org.eclipse.core.runtime.CoreException) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("thrownExcp = (org.eclipse.core.runtime.CoreException) e;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("String msg = e.getLocalizedMessage();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("thrownExcp = new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t\t");
    _builder.append(".ID, 0, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("msg != null ? msg : ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderDiagramLoadingError(it));
    _builder.append(_accessorCall_1, "\t\t\t\t");
    _builder.append(", e));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw thrownExcp;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
    _builder.append(_throwIncorrectInputException, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence createEditingDomain(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.transaction.TransactionalEditingDomain createEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory.getInstance().createEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("editingDomain.setID(\"");
    String _editingDomainID = it.getEditingDomainID();
    _builder.append(_editingDomainID, "\t");
    _builder.append("\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final org.eclipse.emf.transaction.NotificationFilter diagramResourceModifiedFilter = org.eclipse.emf.transaction.NotificationFilter.createNotifierFilter(editingDomain.getResourceSet()).and(org.eclipse.emf.transaction.NotificationFilter.createEventTypeFilter(org.eclipse.emf.common.notify.Notification.ADD)).and(org.eclipse.emf.transaction.NotificationFilter.createFeatureFilter(org.eclipse.emf.ecore.resource.ResourceSet.class, org.eclipse.emf.ecore.resource.ResourceSet.RESOURCE_SET__RESOURCES));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("editingDomain.getResourceSet().eAdapters().add(new org.eclipse.emf.common.notify.Adapter() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.emf.common.notify.Notifier myTarger;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public org.eclipse.emf.common.notify.Notifier getTarget() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return myTarger;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public boolean isAdapterForType(Object type) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI_2 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void notifyChanged(org.eclipse.emf.common.notify.Notification notification) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (diagramResourceModifiedFilter.matches(notification)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Object value = notification.getNewValue();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (value instanceof org.eclipse.emf.ecore.resource.Resource) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("((org.eclipse.emf.ecore.resource.Resource) value).setTrackingModification(true);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI_3 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_3, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void setTarget(org.eclipse.emf.common.notify.Notifier newTarget) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("myTarger = newTarget;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editingDomain;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence doSaveDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doSaveDocument(org.eclipse.core.runtime.IProgressMonitor monitor, Object element, org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, boolean overwrite) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!overwrite && !info.isSynchronized()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".ID, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IResourceStatus.OUT_OF_SYNC_LOCAL");
      } else {
        _builder.append("org.eclipse.core.runtime.IStatus.ERROR");
      }
    }
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentUnsynchronizedFileSaveError(it));
    _builder.append(_accessorCall, "\t\t\t\t");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("null));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        _builder.append("\t");
        _builder.append("info.stopResourceListening();");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("fireElementStateChanging(element);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("monitor.beginTask(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveDiagramTask(it));
    _builder.append(_accessorCall_1, "\t\t\t");
    _builder.append(", info.getResourceSet().getResources().size() + 1); //\"Saving diagram\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("monitor.setTaskName(org.eclipse.osgi.util.NLS.bind(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveNextResourceTask(it));
    _builder.append(_accessorCall_2, "\t\t\t\t\t\t");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("nextResource.getURI()));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (nextResource.isLoaded() && !info.getEditingDomain().isReadOnly(nextResource)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("nextResource.save(");
    CharSequence _callGetSaveOptions = this.xptDiagramEditorUtil.callGetSaveOptions(it);
    _builder.append(_callGetSaveOptions, "\t\t\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t\t\t\t\t");
    _builder.append(".ID, org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorStatusCodes.RESOURCE_FAILURE, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("monitor.worked(1);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("monitor.done();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("info.setModificationStamp(computeModificationStamp(info));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (RuntimeException x) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw x;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} ");
    {
      GenApplication _application_2 = it.getEditorGen().getApplication();
      boolean _equals_2 = Objects.equal(null, _application_2);
      if (_equals_2) {
        _builder.append(" finally {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("info.startResourceListening();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} ");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.common.util.URI newResoruceURI;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.List<org.eclipse.core.resources.IFile> affectedFiles = null;");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenApplication _application_3 = it.getEditorGen().getApplication();
      boolean _equals_3 = Objects.equal(null, _application_3);
      if (_equals_3) {
        _builder.append("if (element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile newFile = ((");
        CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName_1, "\t\t\t");
        _builder.append(") element).getFile();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("affectedFiles = java.util.Collections.singletonList(newFile);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("newResoruceURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(newFile.getFullPath().toString(), true);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if(element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("newResoruceURI = ((");
    CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName_1, "\t\t\t");
    _builder.append(") element).getURI();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
    _builder.append(_throwIncorrectInputException, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (false == document instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_2, "\t\t\t");
    _builder.append(".ID, 0,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("\"Incorrect document used: \" + document + \" instead of org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument\", null)); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.append(" ");
    CharSequence _nonNLS_1 = this._common.nonNLS(2);
    _builder.append(_nonNLS_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.emf.ecore.resource.Resource newResource = diagramDocument.getEditingDomain().getResourceSet().createResource(newResoruceURI);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.gmf.runtime.notation.Diagram diagramCopy = org.eclipse.emf.ecore.util.EcoreUtil.copy(diagramDocument.getDiagram());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(diagramDocument.getEditingDomain(), org.eclipse.osgi.util.NLS.bind(");
    CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveAs(it));
    _builder.append(_accessorCall_3, "\t\t\t");
    _builder.append(", diagramCopy.getName()), affectedFiles) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("newResource.getContents().add(diagramCopy);\t\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}.execute(monitor, null);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("newResource.save(");
    CharSequence _callGetSaveOptions_1 = this.xptDiagramEditorUtil.callGetSaveOptions(it);
    _builder.append(_callGetSaveOptions_1, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.core.commands.ExecutionException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_3, "\t\t\t");
    _builder.append(".ID, 0, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_4, "\t\t\t");
    _builder.append(".ID, 0, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("newResource.unload();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence computeSchedulingRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.core.runtime.jobs.ISchedulingRule computeSchedulingRule(org.eclipse.core.resources.IResource toCreateOrModify) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (toCreateOrModify.exists()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(toCreateOrModify);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IResource parent = toCreateOrModify;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("do {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* XXX This is a workaround for");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* https://bugs.eclipse.org/bugs/show_bug.cgi?id=67601");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* IResourceRuleFactory.createRule should iterate the hierarchy");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* itself.");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("toCreateOrModify = parent;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("parent = toCreateOrModify.getParent();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} while (parent != null && !parent.exists());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().createRule(toCreateOrModify);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence doValidateState(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doValidateState(Object element, Object computationContext) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.resources.IFile> files2Validate = new java.util.LinkedList<org.eclipse.core.resources.IFile>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null && file.isReadOnly()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("files2Validate.add(file);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.resources.ResourcesPlugin.getWorkspace().validateEdit(files2Validate.toArray(new org.eclipse.core.resources.IFile[files2Validate.size()]), computationContext);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.doValidateState(element, computationContext);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getResetRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getResetRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule(rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getSaveRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getSaveRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(computeSchedulingRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule(rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getSynchronizeRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getSynchronizeRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule(rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getValidateStateRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getValidateStateRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> files = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("files.add(file);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule(files.toArray(new org.eclipse.core.resources.IFile[files.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
