/**
 * Copyright (c) 2006, 2009, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.papyrusgmfgenextension.ExtendedGenView;
import org.eclipse.papyrus.papyrusgmfgenextension.LabelVisibilityPreference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ExternalNodeLabelEditPart extends diagram.editparts.ExternalNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence extendsList(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ExtendedGenView, Boolean> _function = new Function1<ExtendedGenView, Boolean>() {
        @Override
        public Boolean apply(final ExtendedGenView v) {
          return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        _builder.append("extends ");
        {
          final Function1<ExtendedGenView, Boolean> _function_1 = new Function1<ExtendedGenView, Boolean>() {
            @Override
            public Boolean apply(final ExtendedGenView v) {
              return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
            }
          };
          Iterable<ExtendedGenView> _iterable = IteratorExtensions.<ExtendedGenView>toIterable(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function_1));
          for(final ExtendedGenView extendedObject : _iterable) {
            _builder.newLineIfNotEmpty();
            CharSequence _specifyInheritance = this.specifyInheritance(((ExtendedGenView) extendedObject));
            _builder.append(_specifyInheritance);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence implementsList(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart");
    _builder.newLine();
    {
      final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
        @Override
        public Boolean apply(final LabelVisibilityPreference v) {
          return Boolean.valueOf(v.getExternalNodeLabels().contains(it));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        _builder.append(", org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence additions(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
        @Override
        public Boolean apply(final LabelVisibilityPreference v) {
          return Boolean.valueOf(v.getExternalNodeLabels().contains(it));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append(_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getLabelRole(){");
        _builder.newLine();
        _builder.append("return \"");
        final Function1<LabelVisibilityPreference, Boolean> _function_1 = new Function1<LabelVisibilityPreference, Boolean>() {
          @Override
          public Boolean apply(final LabelVisibilityPreference v) {
            return Boolean.valueOf(v.getExternalNodeLabels().contains(it));
          }
        };
        String _role = IteratorExtensions.<LabelVisibilityPreference>head(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function_1)).getRole();
        _builder.append(_role);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append(_generatedClassComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getIconPathRole(){");
        _builder.newLine();
        _builder.append("return \"");
        final Function1<LabelVisibilityPreference, Boolean> _function_2 = new Function1<LabelVisibilityPreference, Boolean>() {
          @Override
          public Boolean apply(final LabelVisibilityPreference v) {
            return Boolean.valueOf(v.getExternalNodeLabels().contains(it));
          }
        };
        String _iconPathRole = IteratorExtensions.<LabelVisibilityPreference>head(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function_2)).getIconPathRole();
        _builder.append(_iconPathRole);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence refreshBounds(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.append("public void refreshBounds() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int x = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X())).intValue();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int y = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y())).intValue();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int width = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width())).intValue();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int height = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height())).intValue();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getBorderItemLocator().setConstraint(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getBorderItemLocator().relocate(getFigure());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence specifyInheritance(final ExtendedGenView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _superOwnedEditPart = it.getSuperOwnedEditPart();
    _builder.append(_superOwnedEditPart);
    return _builder;
  }
}
