/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.port.xtext.scoping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.QualifiedName;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.RedefinesRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.SubsetsRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.TypeRule;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class UmlPortScopeProvider
extends AbstractDeclarativeScopeProvider {
    public IScope scope_TypeRule_type(TypeRule ctx, EReference ref) {
        return this.create___TypeRule_type___Scope(ctx);
    }

    private IScope create___TypeRule_type___Scope(TypeRule ctx) {
        if (ctx.getPath() == null) {
            EObject contextElement = ContextElementUtil.getContextElement((Resource)ctx.eResource());
            Namespace root = (Namespace)EcoreUtil.getRootContainer((EObject)contextElement);
            TreeIterator i = root.eResource().getAllContents();
            ArrayList<EObject> allContent = new ArrayList<EObject>();
            while (i.hasNext()) {
                EObject object = (EObject)i.next();
                if (!(object instanceof Classifier)) continue;
                allContent.add(object);
            }
            Iterable visibleClassifiers = Scopes.scopedElementsFor(allContent);
            return new SimpleScope(visibleClassifiers);
        }
        ArrayList<Element> tmpVisibleElementsFromPath = new ArrayList<Element>();
        if (ctx.getPath() != null) {
            QualifiedName qualifiedName = ctx.getPath();
            while (qualifiedName.getRemaining() != null) {
                qualifiedName = qualifiedName.getRemaining();
            }
            Namespace nearestNamespace = qualifiedName.getPath();
            if (nearestNamespace != null) {
                ArrayList<Element> tmpVisiblePropertiesFromPath = new ArrayList<Element>();
                tmpVisiblePropertiesFromPath.addAll(new Visitor_GetOwnedAndImportedClassifiers().visit(nearestNamespace));
                for (Element e : tmpVisiblePropertiesFromPath) {
                    tmpVisibleElementsFromPath.add(e);
                }
            }
        }
        SimpleScope resultScope = null;
        if (!tmpVisibleElementsFromPath.isEmpty()) {
            Iterable iterableIEobjectDescriptions = Scopes.scopedElementsFor(tmpVisibleElementsFromPath);
            resultScope = resultScope != null ? new SimpleScope((IScope)resultScope, iterableIEobjectDescriptions) : new SimpleScope(iterableIEobjectDescriptions);
        }
        return resultScope != null ? resultScope : new SimpleScope(Scopes.scopedElementsFor(new ArrayList()));
    }

    public IScope scope_QualifiedName_path(QualifiedName ctx, EReference ref) {
        ArrayList<Namespace> visibleNamespaces = new ArrayList<Namespace>();
        if (ctx != null && ctx.eContainer() != null && ctx.eContainer() instanceof QualifiedName) {
            Namespace parentNameSpace = ((QualifiedName)ctx.eContainer()).getPath();
            visibleNamespaces.addAll(new Visitor_GetOwnedNamespacesAndImportedNamespaces().visit(parentNameSpace));
        } else {
            EObject contextElement = ContextElementUtil.getContextElement((Resource)ctx.eResource());
            Namespace root = (Namespace)EcoreUtil.getRootContainer((EObject)contextElement);
            visibleNamespaces.add(root);
            visibleNamespaces.addAll(new Visitor_GetOwnedNamespacesAndImportedNamespaces().visit(root));
        }
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(visibleNamespaces);
        return new SimpleScope(iterableIEobjectDescription);
    }

    public IScope scope_RedefinesRule_property(RedefinesRule ctx, EReference ref) {
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(UmlPortScopeProvider.retrieveInheritedProperties(ctx));
        return new SimpleScope(iterableIEobjectDescription);
    }

    public IScope scope_SubsetsRule_property(SubsetsRule ctx, EReference ref) {
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(UmlPortScopeProvider.retrieveInheritedProperties(ctx));
        return new SimpleScope(iterableIEobjectDescription);
    }

    public static List<Property> retrieveInheritedProperties(EObject modelRule) {
        Property editedProperty = (Property)ContextElementUtil.getContextElement((Resource)modelRule.eResource());
        if (editedProperty == null) {
            return null;
        }
        Classifier owner = (Classifier)editedProperty.getNamespace();
        ArrayList<Property> inheritedProperties = new ArrayList<Property>();
        for (Classifier parent : owner.getGenerals()) {
            for (Property p : parent.getAllAttributes()) {
                if (!inheritedProperties.contains(p)) {
                    // empty if block
                }
                inheritedProperties.add(p);
            }
        }
        return inheritedProperties;
    }

    private class Visitor_GetImportedNamespaces {
        private Visitor_GetImportedNamespaces() {
        }

        public List<Namespace> visit(Namespace visited) {
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            for (PackageImport pImport : visited.getPackageImports()) {
                namespaces.add((Namespace)pImport.getImportedPackage());
            }
            for (ElementImport eImport : visited.getElementImports()) {
                if (!(eImport.getImportedElement() instanceof Namespace)) continue;
                namespaces.add((Namespace)eImport.getImportedElement());
            }
            return namespaces;
        }
    }

    private class Visitor_GetOwnedAndImportedClassifiers {
        private Visitor_GetOwnedAndImportedClassifiers() {
        }

        public List<Element> visit(Namespace visited) {
            ArrayList<Element> visibleElements = new ArrayList<Element>();
            for (ElementImport eImport : visited.getElementImports()) {
                if (!(eImport.getImportedElement() instanceof Classifier)) continue;
                visibleElements.add((Element)eImport.getImportedElement());
            }
            for (NamedElement n : visited.getOwnedMembers()) {
                if (!(n instanceof Classifier)) continue;
                visibleElements.add((Element)n);
            }
            return visibleElements;
        }
    }

    private class Visitor_GetOwnedNamespacesAndImportedNamespaces
    extends Visitor_GetImportedNamespaces {
        private Visitor_GetOwnedNamespacesAndImportedNamespaces() {
        }

        @Override
        public List<Namespace> visit(Namespace visited) {
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            namespaces.addAll(super.visit(visited));
            for (NamedElement n : visited.getOwnedMembers()) {
                if (!(n instanceof Namespace)) continue;
                namespaces.add((Namespace)n);
            }
            return namespaces;
        }
    }
}

