/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.DisplayedAxisSelectorDialog;
import org.eclipse.papyrus.infra.nattable.filter.PapyrusFilterStrategy;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusSelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.ISlaveAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.selection.ObjectsSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.sort.IPapyrusSortModel;
import org.eclipse.papyrus.infra.nattable.sort.PapyrusCompositeGlazedListSortModel;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellMapKey;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NatTableFocusUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.swt.IFocusService;

public class NattableModelManager
extends AbstractNattableWidgetManager
implements INattableModelManager,
FocusListener {
    private ICompositeAxisManager columnManager;
    private ICompositeAxisManager rowManager;
    private List<Object> verticalElements;
    private List<Object> horizontalElements;
    protected FilterList<Object> verticalFilterList;
    protected FilterList<Object> horizontalFilterList;
    protected EventList<Object> basicVerticalList;
    protected EventList<Object> basicHorizontalList;
    private final Adapter invertAxisListener;
    private AbstractAxisProvider rowProvider;
    private AbstractAxisProvider columnProvider;
    private CommandStackListener refreshListener;
    private FocusListener focusListener;
    private Observer decoractionServiceObserver;
    private ResourceSetListener resourceSetListener;
    private ILayerListener layerListener;
    protected Adapter changeAxisProvider;
    private final AdapterImpl changeAxisProviderHistory;
    private IFocusService focusService;
    private final Adapter tableCellsListener;
    private final BiMap<CellMapKey, Cell> cellsMap;
    private PreferenceStore localPreferenceStore;
    private Runnable refreshRunnable;
    private final AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private ListEventListener<Object> listEventListener;
    protected SortedList<Object> rowSortedList;
    protected SortedList<Object> columnSortedList;

    public NattableModelManager(Table rawModel) {
        this(rawModel, new ObjectsSelectionExtractor());
    }

    public NattableModelManager(Table rawModel, ISelectionExtractor selectionExtractor) {
        this(rawModel, selectionExtractor, true);
    }

    public NattableModelManager(Table rawModel, ISelectionExtractor selectionExtractor, boolean initializeListeners) {
        super(rawModel, selectionExtractor);
        this.rowProvider = rawModel.getCurrentRowAxisProvider();
        this.columnProvider = rawModel.getCurrentColumnAxisProvider();
        this.verticalElements = this.createVerticalElementList();
        this.horizontalElements = this.createHorizontalElementList();
        this.cellsMap = HashBiMap.create();
        this.init();
        if (initializeListeners) {
            this.invertAxisListener = this.createInvertAxisListener();
            if (this.invertAxisListener != null) {
                rawModel.eAdapters().add((Object)this.invertAxisListener);
            }
            this.tableCellsListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == NattablePackage.eINSTANCE.getTable_Cells()) {
                        NattableModelManager.this.updateCellMap(msg);
                    }
                }
            };
            rawModel.eAdapters().add((Object)this.tableCellsListener);
            this.addListeners();
        } else {
            this.tableCellsListener = null;
            this.invertAxisListener = null;
        }
        this.changeAxisProvider = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (!(NattablePackage.eINSTANCE.getTable_CurrentColumnAxisProvider() != msg.getFeature() && NattablePackage.eINSTANCE.getTable_CurrentRowAxisProvider() != msg.getFeature() || msg.getNewValue() == null || msg.getNewValue().equals(msg.getOldValue()))) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NattableModelManager.this.init();
                            NattableModelManager.this.refreshNatTable();
                        }
                    });
                }
            }
        };
        this.changeAxisProviderHistory = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (!(NattablePackage.eINSTANCE.getTable_ColumnAxisProvidersHistory() != msg.getFeature() && NattablePackage.eINSTANCE.getTable_RowAxisProvidersHistory() != msg.getFeature() || msg.getNewValue() == null || msg.getNewValue().equals(msg.getOldValue()))) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NattableModelManager.this.init();
                        }
                    });
                }
            }
        };
        rawModel.eAdapters().add((Object)this.changeAxisProvider);
    }

    protected Adapter createInvertAxisListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getEventType() == 1) {
                    Object oldValue = msg.getOldValue();
                    Object newValue = msg.getNewValue();
                    if (oldValue != null && newValue != null && msg.getFeature() == NattablePackage.eINSTANCE.getTable_InvertAxis()) {
                        NattableModelManager.this.invertJavaObject();
                        NattableModelManager.this.resizeAxis();
                        NattableModelManager.this.resizeHeader();
                        NattableModelManager.this.mergeTable();
                        NattableModelManager.this.getBodyLayerStack().getRowHideShowLayer().showAllRows();
                        NattableModelManager.this.getBodyLayerStack().getColumnHideShowLayer().showAllColumns();
                    }
                }
            }
        };
    }

    protected void addListeners() {
        this.listEventListener = new ListEventListener<Object>(){

            public void listChanged(ListEvent<Object> listChanges) {
                NattableModelManager.this.manageEventListChanges((ListEvent<Object>)listChanges);
            }
        };
        EventList rowsList = (EventList)this.getRowElementsList();
        EventList columnsList = (EventList)this.getColumnElementsList();
        rowsList.addListEventListener(this.listEventListener);
        columnsList.addListEventListener(this.listEventListener);
    }

    private void manageEventListChanges(ListEvent<Object> listChanges) {
        if (this.natTable != null && !this.natTable.isDisposed()) {
            EventList sourceList = listChanges.getSourceList();
            CellEditorDeclaration declaration = TableHelper.getCellEditorDeclaration(this);
            boolean needConfiguration = false;
            if (CellEditorDeclaration.COLUMN == declaration && sourceList == this.getColumnElementsList()) {
                needConfiguration = true;
            }
            if (CellEditorDeclaration.ROW == declaration && sourceList == this.getRowElementsList()) {
                needConfiguration = true;
            }
            if (needConfiguration) {
                this.configureCellAxisEditor();
                this.configureFilters();
            }
        }
    }

    protected void removeListeners() {
        if (this.listEventListener != null) {
            EventList rowsList = (EventList)this.getRowElementsList();
            EventList columnsList = (EventList)this.getColumnElementsList();
            rowsList.removeListEventListener(this.listEventListener);
            columnsList.removeListEventListener(this.listEventListener);
        }
    }

    protected List<Object> createVerticalElementList() {
        this.basicVerticalList = GlazedLists.eventList(new ArrayList());
        this.columnSortedList = new SortedList(this.basicVerticalList, null);
        this.verticalFilterList = new FilterList(this.columnSortedList);
        return this.verticalFilterList;
    }

    protected List<Object> createHorizontalElementList() {
        FilterList filteredList;
        this.basicHorizontalList = GlazedLists.eventList(new ArrayList());
        this.rowSortedList = new SortedList(this.basicHorizontalList, null);
        this.horizontalFilterList = filteredList = new FilterList(this.rowSortedList);
        return this.horizontalFilterList;
    }

    public SortedList<Object> getRowSortedList() {
        return this.rowSortedList;
    }

    public SortedList<Object> getColumnSortedList() {
        return this.columnSortedList;
    }

    @Override
    protected IPapyrusSortModel getRowSortModel() {
        if (this.rowSortModel == null) {
            boolean inverted = this.getTable().isInvertAxis();
            this.rowSortModel = inverted ? new PapyrusCompositeGlazedListSortModel(this, this.getColumnSortedList(), this.getRowSortedList(), inverted) : new PapyrusCompositeGlazedListSortModel(this, this.getRowSortedList(), this.getColumnSortedList(), inverted);
        }
        return this.rowSortModel;
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        this.updateCellMap(null);
        NatTable nattable = super.createNattable(parent, style, site);
        this.refreshListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                NattableModelManager.this.refreshNatTable();
            }
        };
        this.getContextEditingDomain().getCommandStack().addCommandStackListener(this.refreshListener);
        if (this.getTableEditingDomain() != null && this.getTableEditingDomain() != this.getContextEditingDomain()) {
            this.getTableEditingDomain().getCommandStack().addCommandStackListener(this.refreshListener);
        }
        this.focusListener = this;
        nattable.addFocusListener(this.focusListener);
        this.focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (this.focusService != null) {
            String id = null;
            if (this.getTable().getTableConfiguration() != null) {
                id = this.getTable().getTableConfiguration().getType();
            }
            if (id == null) {
                id = this.getTableName();
            }
            this.focusService.addFocusTracker((Control)nattable, id);
        }
        this.layerListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                NattableModelManager.this.updateToggleActionState();
            }
        };
        nattable.addLayerListener(this.layerListener);
        this.updateToggleActionState();
        this.decoractionServiceObserver = this.getOrCreateDecorationServiceObserver();
        this.getDecorationService().addListener(this.decoractionServiceObserver);
        return nattable;
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.updateToggleActionState();
        NatTableFocusUtils.getInstance().setCurrentNattableModelManager(this);
    }

    @Override
    protected void updateToggleActionState() {
        super.updateToggleActionState();
        ICommandService commandService = EclipseCommandUtils.getCommandService();
        if (commandService != null) {
            FeatureLabelProviderConfiguration labelFeatureConf;
            ObjectLabelProviderConfiguration labelConfig;
            AbstractHeaderAxisConfiguration columnAxisConfiguration = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
            AbstractHeaderAxisConfiguration rowAxisConfiguration = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisUsedInTable(this.getTable());
            Command command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.display.index");
            this.updateToggleCommandState(command, columnAxisConfiguration.isDisplayIndex());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.display.label");
            this.updateToggleCommandState(command, columnAxisConfiguration.isDisplayLabel());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.index.style");
            this.updateRadioCommandState(command, columnAxisConfiguration.getIndexStyle().getLiteral());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.display.index");
            this.updateToggleCommandState(command, rowAxisConfiguration.isDisplayIndex());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.display.label");
            this.updateToggleCommandState(command, rowAxisConfiguration.isDisplayLabel());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.index.style");
            this.updateRadioCommandState(command, rowAxisConfiguration.getIndexStyle().getLiteral());
            EList columnLabelConfigurations = columnAxisConfiguration.getOwnedLabelConfigurations();
            EList rowLabelConfigurations = rowAxisConfiguration.getOwnedLabelConfigurations();
            for (ILabelProviderConfiguration current : columnLabelConfigurations) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                labelConfig = (ObjectLabelProviderConfiguration)current;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.display.icon");
                this.updateToggleCommandState(command, labelConfig.isDisplayIcon());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.display.label");
                this.updateToggleCommandState(command, labelConfig.isDisplayLabel());
                if (!(labelConfig instanceof FeatureLabelProviderConfiguration)) continue;
                labelFeatureConf = (FeatureLabelProviderConfiguration)labelConfig;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.isderived");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayIsDerived());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.multiplicity");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayMultiplicity());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.type");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayType());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.name");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayName());
            }
            for (ILabelProviderConfiguration current : rowLabelConfigurations) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                labelConfig = (ObjectLabelProviderConfiguration)current;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.display.icon");
                this.updateToggleCommandState(command, labelConfig.isDisplayIcon());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.display.label");
                this.updateToggleCommandState(command, labelConfig.isDisplayLabel());
                if (!(labelConfig instanceof FeatureLabelProviderConfiguration)) continue;
                labelFeatureConf = (FeatureLabelProviderConfiguration)labelConfig;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.isderived");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayIsDerived());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.multiplicity");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayMultiplicity());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.type");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayType());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.name");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayName());
            }
            if (this.columnProvider instanceof ISlaveAxisProvider) {
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.disconnect.slave");
                this.updateToggleCommandState(command, ((IMasterAxisProvider)this.rowProvider).isDisconnectSlave());
            }
            if (this.rowProvider instanceof ISlaveAxisProvider) {
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.disconnect.slave");
                this.updateToggleCommandState(command, ((IMasterAxisProvider)this.columnProvider).isDisconnectSlave());
            }
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.invert.axis");
            this.updateToggleCommandState(command, this.getTable().isInvertAxis());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.mergeRows");
            this.updateToggleCommandState(command, this.getToggleStateAllRows());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.mergeColumns");
            this.updateToggleCommandState(command, this.getToggleStateAllColumns());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.mergeSelectedRows");
            this.updateToggleCommandState(command, this.getToggleStateSelectedRows());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.mergeSelectedColumns");
            this.updateToggleCommandState(command, this.getToggleStateSelectedColumns());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.wraptext");
            this.updateToggleCommandState(command, StyleUtils.getBooleanNamedStyleValue(this.getTable(), "wrapText"));
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.autoresize.cellheight");
            this.updateToggleCommandState(command, StyleUtils.getBooleanNamedStyleValue(this.getTable(), "autoResizeCellHeight"));
            int selectedAxisIndex = AxisUtils.getUniqueSelectedAxisIndex(this);
            AbstractAxisProvider axisProvider = this.getTable().getCurrentColumnAxisProvider();
            if (axisProvider != null && selectedAxisIndex >= 0 && selectedAxisIndex < axisProvider.getAxis().size()) {
                IAxis selectedAxis = (IAxis)axisProvider.getAxis().get(selectedAxisIndex);
                String commandID = "org.eclipse.papyrus.infra.nattable.displaylist.separatedrows.columnheader";
                if (this.getTable().isInvertAxis()) {
                    commandID = "org.eclipse.papyrus.infra.nattable.displaylist.separatedrows.rowheader";
                }
                command = commandService.getCommand(commandID);
                this.updateToggleCommandState(command, StyleUtils.getBooleanNamedStyleValue((StyledElement)selectedAxis, "displayListOnSeparatedRows", false));
            }
        } else {
            throw new RuntimeException(String.format("The Eclipse service %s has not been found", ICommandService.class));
        }
    }

    private void updateToggleCommandState(Command command, boolean newValue) {
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)newValue);
    }

    protected void updateRadioCommandState(Command command, Object newValue) {
        EclipseCommandUtils.updateRadioCommandState((Command)command, (Object)newValue);
    }

    public void invertJavaObject() {
        this.getRowSortModel().clear();
        AbstractAxisProvider newColumProvider = this.rowProvider;
        AbstractAxisProvider newRowProvider = this.columnProvider;
        List<Object> newVerticalElementList = this.horizontalElements;
        List<Object> newHorizontalElementList = this.verticalElements;
        ICompositeAxisManager newRowManager = this.columnManager;
        ICompositeAxisManager newColumnManager = this.rowManager;
        this.columnProvider = newColumProvider;
        this.rowProvider = newRowProvider;
        this.verticalElements = newVerticalElementList;
        this.horizontalElements = newHorizontalElementList;
        EventList<Object> newHorizontalBasicList = this.basicVerticalList;
        EventList<Object> newVerticalBasicList = this.basicHorizontalList;
        SortedList<Object> newHorizontalSortedList = this.columnSortedList;
        SortedList<Object> newVerticalSortedList = this.rowSortedList;
        FilterList<Object> newVerticalFilterLilst = this.horizontalFilterList;
        FilterList<Object> newHorizontalFilterList = this.verticalFilterList;
        this.basicVerticalList = newVerticalBasicList;
        this.basicHorizontalList = newHorizontalBasicList;
        this.horizontalFilterList = newHorizontalFilterList;
        this.verticalFilterList = newVerticalFilterLilst;
        this.rowSortedList = newHorizontalSortedList;
        this.columnSortedList = newVerticalSortedList;
        this.columnManager = newColumnManager;
        this.rowManager.setAxisComparator(null);
        this.columnManager.setAxisComparator(null);
        this.getRowSortModel().setTableInverted(this.getTable().isInvertAxis());
        this.updateToggleActionState();
        this.configureCellAxisEditor();
        this.configureFilters();
        this.refreshNatTable();
    }

    public EventList<Object> getHorizontalBasicEventList() {
        return this.basicHorizontalList;
    }

    public FilterList<Object> getHorizontalFilterEventList() {
        return this.horizontalFilterList;
    }

    public FilterList<Object> getVerticalFilterList() {
        return this.verticalFilterList;
    }

    public void resizeAxis() {
        if (!this.isColumnWidthAsPercentage()) {
            this.initTableAxis();
        }
        this.refreshNatTable();
    }

    public void resizeHeader() {
        this.initTableHeaders();
        this.refreshNatTable();
    }

    public void mergeTable() {
        this.initTableMerge();
        this.refreshNatTable();
    }

    protected void init() {
        if (this.columnManager != null) {
            this.columnManager.dispose();
        }
        if (this.rowManager != null) {
            this.rowManager.dispose();
        }
        this.columnProvider = this.getTable().getCurrentColumnAxisProvider();
        this.rowProvider = this.getTable().getCurrentRowAxisProvider();
        this.columnManager = this.createAxisManager((List<AxisManagerRepresentation>)this.getTable().getTableConfiguration().getColumnHeaderAxisConfiguration().getAxisManagers(), this.getTable().getCurrentColumnAxisProvider(), true);
        this.rowManager = this.createAxisManager((List<AxisManagerRepresentation>)this.getTable().getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers(), this.getTable().getCurrentRowAxisProvider(), false);
        boolean allIsSlave = this.columnManager.isSlave() && this.rowManager.isSlave();
        Assert.isTrue((!allIsSlave ? 1 : 0) != 0, (String)Messages.NattableModelManager_AtLeastOfOneTheAxisManagerMustBeAMaster);
    }

    protected ICompositeAxisManager createAxisManager(List<AxisManagerRepresentation> representations, AbstractAxisProvider contentProvider, boolean columnAxisManager) {
        CompositeAxisManager compositeAxisManager = new CompositeAxisManager();
        ArrayList<IAxisManager> managers = new ArrayList<IAxisManager>();
        for (AxisManagerRepresentation current : representations) {
            IAxisManager manager = AxisManagerFactory.INSTANCE.getAxisManager(current);
            Assert.isNotNull((Object)manager);
            manager.init(this, current, contentProvider);
            managers.add(manager);
        }
        compositeAxisManager.init(this, null, contentProvider);
        compositeAxisManager.setSubAxisManager(managers);
        return compositeAxisManager;
    }

    @Override
    public void dispose() {
        Table table;
        if (this.decoractionServiceObserver != null) {
            if (this.decorationService != null) {
                this.decorationService.deleteListener(this.decoractionServiceObserver);
                this.decorationService = null;
            }
            this.decoractionServiceObserver = null;
        }
        if (this.tableEditingDomain != null) {
            if (this.tableEditingDomain.getCommandStack() != null) {
                this.tableEditingDomain.getCommandStack().removeCommandStackListener(this.refreshListener);
            }
            if (this.tableEditingDomain != null) {
                this.tableEditingDomain.removeResourceSetListener(this.resourceSetListener);
            }
        }
        if (this.contextEditingDomain != null) {
            if (this.contextEditingDomain.getCommandStack() != null) {
                this.contextEditingDomain.getCommandStack().removeCommandStackListener(this.refreshListener);
            }
            if (this.contextEditingDomain != null) {
                this.contextEditingDomain.removeResourceSetListener(this.resourceSetListener);
            }
        }
        if (this.columnManager != null) {
            this.columnManager.dispose();
            this.columnManager = null;
        }
        if (this.rowManager != null) {
            this.rowManager.dispose();
            this.rowManager = null;
        }
        if ((table = this.getTable()) != null) {
            if (this.tableCellsListener != null) {
                table.eAdapters().remove((Object)this.tableCellsListener);
            }
            if (this.changeAxisProvider != null) {
                table.eAdapters().remove((Object)this.changeAxisProvider);
            }
            if (this.invertAxisListener != null) {
                table.eAdapters().remove((Object)this.invertAxisListener);
            }
        }
        if (this.cellsMap != null) {
            this.cellsMap.clear();
        }
        if (this.natTable != null && !this.natTable.isDisposed()) {
            if (this.layerListener != null) {
                this.natTable.removeLayerListener(this.layerListener);
            }
            if (this.focusListener != null) {
                this.natTable.removeFocusListener(this.focusListener);
            }
        }
        if (this.focusService != null && this.natTable != null) {
            this.focusService.removeFocusTracker((Control)this.natTable);
            this.focusService = null;
        }
        this.removeListeners();
        super.dispose();
    }

    @Override
    public void addRows(Collection<Object> objectsToAdd) {
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.getAddRowElementCommand(objectsToAdd);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public int getColumnCount() {
        return this.getColumnElementsList().size();
    }

    @Override
    public int getRowCount() {
        return this.getRowElementsList().size();
    }

    @Override
    public void addColumns(Collection<Object> objectsToAdd) {
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.getAddColumnElementCommand(objectsToAdd);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public void removeColumns(Collection<Object> objetsToRemove) {
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.getDestroyColumnElementCommand(objetsToRemove);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public void removeRows(Collection<Object> objectsToRemove) {
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.getDestroyRowElementCommand(objectsToRemove);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public IDataProvider getBodyDataProvider() {
        return this;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Object row;
        Object column;
        Object obj1 = this.verticalElements.get(columnIndex);
        Object obj2 = this.horizontalElements.get(rowIndex);
        if (this.getTable().isInvertAxis()) {
            column = obj2;
            row = obj1;
        } else {
            row = obj2;
            column = obj1;
        }
        return CellManagerFactory.INSTANCE.getCrossValue(column, row, this);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Object row;
        Object column;
        Object obj1 = this.verticalElements.get(columnIndex);
        Object obj2 = this.horizontalElements.get(rowIndex);
        if (this.getTable().isInvertAxis()) {
            column = obj2;
            row = obj1;
        } else {
            row = obj2;
            column = obj1;
        }
        CellManagerFactory.INSTANCE.setCellValue(this.getContextEditingDomain(), column, row, newValue, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNatTable() {
        if (this.natTable != null && !this.natTable.isDisposed()) {
            Runnable schedule;
            NattableModelManager nattableModelManager = this;
            synchronized (nattableModelManager) {
                if (this.refreshRunnable == null) {
                    this.refreshRunnable = schedule = this.createRefreshRunnable();
                } else {
                    schedule = null;
                }
            }
            if (schedule != null) {
                Display display;
                NatTable control = this.natTable;
                Display display2 = display = control == null || control.isDisposed() ? null : control.getDisplay();
                if (display != null) {
                    display.asyncExec(schedule);
                }
            }
        }
    }

    private Runnable createRefreshRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NattableModelManager nattableModelManager = NattableModelManager.this;
                synchronized (nattableModelManager) {
                    if (NattableModelManager.this.refreshRunnable != this) {
                        return;
                    }
                    NattableModelManager.this.refreshRunnable = null;
                }
                NattableModelManager.this.refreshInUIThread();
            }
        };
    }

    protected void refreshInUIThread() {
        if (this.natTable != null && this.natTable.isDisposed()) {
            return;
        }
        TableStructuredSelection selectionInTable = this.getSelectionInTable();
        Collection<PositionCoordinate> selectedCells = null;
        Set<Integer> columnPositions = null;
        Set<Integer> rowsPositions = null;
        if (selectionInTable != null) {
            TableSelectionWrapper tableSelectionWrapper = (TableSelectionWrapper)selectionInTable.getAdapter(TableSelectionWrapper.class);
            selectedCells = tableSelectionWrapper.getSelectedCells();
            columnPositions = tableSelectionWrapper.getFullySelectedColumns().keySet();
            rowsPositions = tableSelectionWrapper.getFullySelectedRows().keySet();
        }
        if (this.isRefreshing.compareAndSet(false, true)) {
            SelectionLayer selectionLayer = this.getBodyLayerStack().getSelectionLayer();
            selectionLayer.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
            this.natTable.refresh();
            this.doFillColumnsSize();
            this.reinitialiseRowHeight();
            if (selectedCells != null && !selectedCells.isEmpty()) {
                int position;
                ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
                ArrayList<Integer> selectedRows = new ArrayList<Integer>();
                if (columnPositions != null && !columnPositions.isEmpty()) {
                    List<Range> selectedColumnsRanges = ((PapyrusSelectionLayer)selectionLayer).getRangeSelectedAxis(columnPositions);
                    for (Range selectedColumnRange : selectedColumnsRanges) {
                        position = selectedColumnRange.start;
                        while (position < selectedColumnRange.end) {
                            selectionLayer.doCommand((ILayerCommand)new SelectColumnCommand((ILayer)selectionLayer, position, 0, false, true));
                            selectedColumns.add(position);
                            ++position;
                        }
                    }
                }
                if (rowsPositions != null && !rowsPositions.isEmpty()) {
                    List<Range> selectedRowsRanges = ((PapyrusSelectionLayer)selectionLayer).getRangeSelectedAxis(rowsPositions);
                    for (Range selectedRowRange : selectedRowsRanges) {
                        position = selectedRowRange.start;
                        while (position < selectedRowRange.end) {
                            selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, position, false, true));
                            selectedRows.add(position);
                            ++position;
                        }
                    }
                }
                for (PositionCoordinate selectedCell : selectedCells) {
                    if (selectedColumns.contains(selectedCell.getColumnPosition()) || selectedRows.contains(selectedCell.getRowPosition())) continue;
                    selectionLayer.doCommand((ILayerCommand)new SelectCellCommand((ILayer)selectionLayer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), false, true));
                }
            }
            this.isRefreshing.set(false);
        }
    }

    public void updateAxisContents(final AbstractAxisProvider axis) {
        try {
            if (this.getTableEditingDomain() != null) {
                this.getTableEditingDomain().runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).NattableModelManager.this.natTable != null && !(this).NattableModelManager.this.natTable.isDisposed() && NattableModelManager.this.getTable() != null && NattableModelManager.this.getTable().getTableConfiguration() != null) {
                                    if (axis == NattableModelManager.this.columnProvider) {
                                        NattableModelManager.this.updateColumnContents();
                                        NattableModelManager.this.getRowSortModel().updateSort();
                                    } else {
                                        NattableModelManager.this.updateRowContents();
                                    }
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void updateRowContents() {
        this.rowManager.updateAxisContents();
        CellEditorDeclaration declaration = this.getCellEditorDeclarationToUse(this.getTable());
        if (declaration.equals((Object)CellEditorDeclaration.ROW)) {
            this.refreshNatTable();
        } else {
            this.refreshNatTable();
        }
    }

    private void updateColumnContents() {
        this.columnManager.updateAxisContents();
        CellEditorDeclaration declaration = this.getCellEditorDeclarationToUse(this.getTable());
        if (declaration.equals((Object)CellEditorDeclaration.COLUMN)) {
            this.refreshNatTable();
        } else {
            this.refreshNatTable();
        }
    }

    private CellEditorDeclaration getCellEditorDeclarationToUse(Table table) {
        CellEditorDeclaration declaration = table.getTableConfiguration().getCellEditorDeclaration();
        if (this.getTable().isInvertAxis()) {
            if (declaration.equals((Object)CellEditorDeclaration.COLUMN)) {
                declaration = CellEditorDeclaration.ROW;
            } else if (declaration.equals((Object)CellEditorDeclaration.ROW)) {
                declaration = CellEditorDeclaration.COLUMN;
            }
        }
        return declaration;
    }

    @Override
    public List<Object> getColumnElementsList() {
        return this.verticalElements;
    }

    @Override
    public List<Object> getRowElementsList() {
        return this.horizontalElements;
    }

    @Override
    public boolean canInsertRow(Collection<Object> objectsToAdd, int index) {
        return this.rowManager.canInsertAxis(objectsToAdd, index);
    }

    @Override
    public boolean canInsertColumns(Collection<Object> objectsToAdd, int index) {
        return this.columnManager.canInsertAxis(objectsToAdd, index);
    }

    @Override
    public boolean canDropColumnsElement(Collection<Object> objectsToAdd) {
        return this.columnManager.canDropAxisElement(objectsToAdd);
    }

    @Override
    public boolean canDropRowElement(Collection<Object> objectsToAdd) {
        return this.rowManager.canDropAxisElement(objectsToAdd);
    }

    @Override
    public void insertRows(Collection<Object> objectsToAdd, int index) {
        this.rowManager.getInsertAxisCommand(objectsToAdd, index);
    }

    @Override
    public void insertColumns(Collection<Object> objectsToAdd, int index) {
        this.columnManager.getInsertAxisCommand(objectsToAdd, index);
    }

    @Override
    public Object getColumnElement(int index) {
        if (index < 0 || index >= this.verticalElements.size()) {
            return null;
        }
        return this.verticalElements.get(index);
    }

    @Override
    public Object getRowElement(int index) {
        if (index < 0 || index >= this.horizontalElements.size()) {
            return null;
        }
        return this.horizontalElements.get(index);
    }

    public List<Object> getElementsList(AbstractAxisProvider axisProvider) {
        if (axisProvider == this.columnProvider) {
            return this.verticalElements;
        }
        if (axisProvider == this.rowProvider) {
            return this.horizontalElements;
        }
        return null;
    }

    @Override
    public boolean canMoveRows() {
        return this.rowManager.canMoveAxis();
    }

    @Override
    public boolean canMoveColumns() {
        return this.columnManager.canMoveAxis();
    }

    @Override
    public void moveColumnElement(Object axisToMove, int newIndex) {
        this.columnManager.moveAxis(axisToMove, newIndex);
    }

    @Override
    public void moveRowElement(Object axisToMove, int newIndex) {
        this.rowManager.moveAxis(axisToMove, newIndex);
    }

    @Override
    public void invertAxis() {
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_SwitchLinesAndColumns);
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        boolean oldValue = this.getTable().isInvertAxis();
        if (this.canInvertAxis()) {
            SetCommand tmp = new SetCommand((EditingDomain)domain, (EObject)this.getTable(), (EStructuralFeature)NattablePackage.eINSTANCE.getTable_InvertAxis(), (Object)(!oldValue ? 1 : 0));
            cmd.append((org.eclipse.emf.common.command.Command)tmp);
            domain.getCommandStack().execute((org.eclipse.emf.common.command.Command)cmd);
        }
        this.initTableAxis();
        this.initTableHeaders();
        this.initTableMerge();
    }

    @Override
    public boolean canInvertAxis() {
        return this.columnManager.canBeUsedAsRowManager() && this.rowManager.canBeUsedAsColumnManager();
    }

    @Override
    public boolean canCreateRowElement(String elementType) {
        return this.rowManager.canCreateAxisElement(elementType);
    }

    @Override
    public boolean canCreateColumnElement(String elementType) {
        return this.columnManager.canCreateAxisElement(elementType);
    }

    @Override
    public org.eclipse.emf.common.command.Command getAddRowElementCommand(Collection<Object> objectsToAdd) {
        boolean addComplementaryAxis;
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddRowCommand);
        org.eclipse.emf.common.command.Command tmp = this.rowManager.getAddAxisCommand(domain, objectsToAdd);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = rowsProvider instanceof IMasterAxisProvider && columnsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)rowsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.columnManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    @Override
    public org.eclipse.emf.common.command.Command getAddColumnElementCommand(Collection<Object> objectsToAdd) {
        boolean addComplementaryAxis;
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddColumnCommand);
        org.eclipse.emf.common.command.Command tmp = this.columnManager.getAddAxisCommand(domain, objectsToAdd);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = columnsProvider instanceof IMasterAxisProvider && rowsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)columnsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.rowManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    @Override
    public org.eclipse.emf.common.command.Command getAddRowElementCommand(Collection<Object> objectsToAdd, int index) {
        boolean addComplementaryAxis;
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddRowCommand);
        org.eclipse.emf.common.command.Command tmp = this.rowManager.getAddAxisCommand(domain, objectsToAdd, index);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = rowsProvider instanceof IMasterAxisProvider && columnsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)rowsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.columnManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    @Override
    public org.eclipse.emf.common.command.Command getAddColumnElementCommand(Collection<Object> objectsToAdd, int index) {
        boolean addComplementaryAxis;
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddColumnCommand);
        org.eclipse.emf.common.command.Command tmp = this.columnManager.getAddAxisCommand(domain, objectsToAdd, index);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = columnsProvider instanceof IMasterAxisProvider && rowsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)columnsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.rowManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    public org.eclipse.emf.common.command.Command getDestroyColumnElementCommand(Collection<Object> objectsToDestroy) {
        TransactionalEditingDomain domain = this.getContextEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.columnManager.getDestroyAxisCommand(domain, objectsToDestroy);
        return cmd;
    }

    public org.eclipse.emf.common.command.Command getDestroyRowElementCommand(Collection<Object> objectsToDestroy) {
        TransactionalEditingDomain domain = this.getContextEditingDomain();
        org.eclipse.emf.common.command.Command cmd = this.rowManager.getDestroyAxisCommand(domain, objectsToDestroy);
        return cmd;
    }

    @Override
    public ITableAxisElementProvider getTableAxisElementProvider() {
        return this;
    }

    @Override
    public boolean canCreateDestroyColumnsAxis() {
        return !this.columnManager.isDynamic() && this.columnManager.createPossibleAxisContentProvider(true) != null;
    }

    @Override
    public boolean canCreateDestroyRowsAxis() {
        return !this.rowManager.isDynamic() && this.rowManager.createPossibleAxisContentProvider(true) != null;
    }

    private final void openCreateDestroyAxisManagerDialog(boolean isEditingColumns) {
        ICompositeAxisManager secondAxisManager;
        ICompositeAxisManager editedAxisManager;
        String dialogQuestion;
        String dialogCheckBoxTootip;
        String dialogTitle;
        String checkBoxMessage = Messages.NattableModelManager_DisconnectThisAxisManager;
        if (isEditingColumns) {
            dialogTitle = Messages.NattableModelManager_SelectColumns;
            dialogCheckBoxTootip = Messages.NattableModelManager_DisableTheAutomaticAdditionOfColumnsWhenARowIsAdded;
            dialogQuestion = String.format(Messages.NattableModelManager_TheCheckBoxHasNotBeenCheckedToAvoidAutomaticColumnAddition, checkBoxMessage);
            editedAxisManager = this.columnManager;
            secondAxisManager = this.rowManager;
        } else {
            dialogTitle = Messages.NattableModelManager_SelectRows;
            dialogCheckBoxTootip = Messages.NattableModelManager_DisableTheAutomaticAdditionOfRowsWhenAColumnIsAdded;
            dialogQuestion = String.format(Messages.NattableModelManager_TheCheckBoxHasNotBeenCheckedToAvoidAutomaticRowAddition, checkBoxMessage);
            editedAxisManager = this.rowManager;
            secondAxisManager = this.columnManager;
        }
        LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider();
        AbstractAxisProvider editedAxisProvider = editedAxisManager.getRepresentedContentProvider();
        AbstractAxisProvider secondAxisProvider = secondAxisManager.getRepresentedContentProvider();
        ReferenceSelector selector = new ReferenceSelector(true){

            public void createControls(Composite parent) {
                super.createControls(parent);
                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        selector.setLabelProvider(labelProvider);
        IRestrictedContentProvider provider = editedAxisManager.createPossibleAxisContentProvider(true);
        if (provider != null) {
            boolean checkboxValue;
            selector.setContentProvider((IStaticContentProvider)new FlattenableRestrictedFilteredContentProvider(provider, selector));
            boolean canBeReorder = !editedAxisManager.isDynamic() && editedAxisManager.canMoveAxis();
            DisplayedAxisSelectorDialog dialog = new DisplayedAxisSelectorDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, dialogTitle, true, canBeReorder, -1);
            boolean displayCheckBox = editedAxisProvider instanceof ISlaveAxisProvider;
            dialog.setDisplayCheckBox(displayCheckBox);
            boolean bl = checkboxValue = secondAxisProvider instanceof IMasterAxisProvider && ((IMasterAxisProvider)secondAxisProvider).isDisconnectSlave();
            if (displayCheckBox) {
                dialog.setCheckBoxValues(checkBoxMessage, dialogCheckBoxTootip, checkboxValue);
            }
            dialog.setInformationDialogValues(Messages.NattableModelManager_DisconnectAxisManagerInformationDialogTitle, dialogQuestion);
            dialog.setLabelProvider(labelProvider);
            List<Object> initialSelection = ((CompositeAxisManager)editedAxisManager).getAllManagedAxis(true);
            dialog.setInitialElementSelections(new ArrayList<Object>(initialSelection));
            int open = dialog.open();
            if (open == 0) {
                org.eclipse.emf.common.command.Command setOrderCommand;
                List<Object> existingColumns = initialSelection;
                ArrayList<Object> checkedColumns = new ArrayList<Object>();
                List<Object> result = Arrays.asList(dialog.getResult());
                checkedColumns.addAll(result);
                ArrayList<Object> columnsToAdd = new ArrayList<Object>(checkedColumns);
                columnsToAdd.removeAll(existingColumns);
                CompoundCommand compoundCommand = new CompoundCommand("Update Existing Axis Command");
                if (columnsToAdd.size() > 0) {
                    org.eclipse.emf.common.command.Command addAxisElementCommand = null;
                    addAxisElementCommand = isEditingColumns ? this.getAddColumnElementCommand(columnsToAdd) : this.getAddRowElementCommand(columnsToAdd);
                    compoundCommand.append(addAxisElementCommand);
                }
                ArrayList<Object> axisToDestroy = new ArrayList<Object>(existingColumns);
                axisToDestroy.removeAll(checkedColumns);
                if (axisToDestroy.size() > 0) {
                    org.eclipse.emf.common.command.Command destroyAxisElementCommand = null;
                    destroyAxisElementCommand = isEditingColumns ? this.getDestroyColumnElementCommand(axisToDestroy) : this.getDestroyRowElementCommand(axisToDestroy);
                    compoundCommand.append(destroyAxisElementCommand);
                }
                boolean newState = dialog.isChecked();
                if (displayCheckBox && checkboxValue != newState) {
                    TransactionalEditingDomain domain = this.getTableEditingDomain();
                    SetRequest request = new SetRequest(domain, (EObject)secondAxisProvider, (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_DisconnectSlave(), (Object)newState);
                    IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)secondAxisProvider);
                    compoundCommand.append((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(commandProvider.getEditCommand((IEditCommandRequest)request)));
                }
                if (canBeReorder && (setOrderCommand = editedAxisManager.getSetNewAxisOrderCommand(result)) != null) {
                    compoundCommand.append(setOrderCommand);
                }
                if (!compoundCommand.isEmpty()) {
                    this.getTableEditingDomain().getCommandStack().execute((org.eclipse.emf.common.command.Command)compoundCommand);
                    this.updateToggleActionState();
                }
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.NattableModelManager_CreateDestroyAxis, (String)Messages.NattableModelManager_ActionNotYetSupported);
        }
    }

    @Override
    public void openCreateDestroyRowsManagerDialog() {
        this.openCreateDestroyAxisManagerDialog(false);
    }

    @Override
    public void openCreateDestroyColumnsManagerDialog() {
        this.openCreateDestroyAxisManagerDialog(true);
    }

    @Override
    public void sortColumnsByName(boolean alphabeticOrder) {
        this.columnManager.sortAxisByName(alphabeticOrder, this.natTable.getConfigRegistry(), false);
    }

    @Override
    public void sortRowsByName(boolean alphabeticOrder) {
        this.rowManager.sortAxisByName(alphabeticOrder, this.natTable.getConfigRegistry(), true);
    }

    @Override
    public AbstractAxisProvider getVerticalAxisProvider() {
        if (this.getTable().isInvertAxis()) {
            return this.getTable().getCurrentRowAxisProvider();
        }
        return this.getTable().getCurrentColumnAxisProvider();
    }

    @Override
    public AbstractAxisProvider getHorizontalAxisProvider() {
        if (this.getTable().isInvertAxis()) {
            return this.getTable().getCurrentColumnAxisProvider();
        }
        return this.getTable().getCurrentRowAxisProvider();
    }

    @Override
    public boolean canEditColumnHeader(NatEventData evaluationContext) {
        return this.columnManager.canEditAxisHeader(evaluationContext);
    }

    @Override
    public boolean canEditRowHeader(NatEventData evaluationContext) {
        return this.rowManager.canEditAxisHeader(evaluationContext);
    }

    @Override
    public void openEditRowAliasDialog(NatEventData event) {
        this.rowManager.openEditAxisAliasDialog(event, event.getNatTable().getRowIndexByPosition(event.getRowPosition()));
    }

    @Override
    public void openEditColumnAliasDialog(NatEventData event) {
        this.columnManager.openEditAxisAliasDialog(event, event.getNatTable().getColumnIndexByPosition(event.getColumnPosition()));
    }

    @Override
    public IAxisManager getColumnAxisManager() {
        return this.columnManager;
    }

    @Override
    public IAxisManager getRowAxisManager() {
        return this.rowManager;
    }

    @Override
    public void setTableLabel(String label) {
        this.getTableEditingDomain().getCommandStack().execute(LabelInternationalization.getInstance().getSetTableLabelCommand((EditingDomain)this.getTableEditingDomain(), this.getTable(), label, null));
    }

    @Override
    public void setTableName(String name) {
        SetRequest setNameRequest = new SetRequest((EObject)this.getTable(), (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name(), (Object)name);
        IElementEditService editService = ElementEditServiceUtils.getCommandProvider((EObject)this.getTable());
        ICommand setNameCommand = editService.getEditCommand((IEditCommandRequest)setNameRequest);
        this.getTableEditingDomain().getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(setNameCommand));
    }

    @Override
    public String getTableName() {
        return this.getTable().getName();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == NatTable.class) {
            return this.natTable;
        }
        return super.getAdapter(adapter);
    }

    private void updateCellMap(final Notification notification) {
        Job job = new Job("Update cells"){

            protected IStatus run(IProgressMonitor monitor) {
                block4: {
                    Object coll;
                    int eventType;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    if (NattableModelManager.this.cellsMap == null) break block4;
                                    if (notification != null) break block5;
                                    NattableModelManager.this.cellsMap.clear();
                                    if (NattableModelManager.this.getTable() == null || NattableModelManager.this.getTable().getCells() == null) break block4;
                                    for (Cell current : NattableModelManager.this.getTable().getCells()) {
                                        CellMapKey key = NattableModelManager.this.createCellMapKeyWaitingCellAxis(current);
                                        NattableModelManager.this.cellsMap.put((Object)key, (Object)current);
                                    }
                                    break block4;
                                }
                                eventType = notification.getEventType();
                                if (eventType != 3) break block6;
                                Object object = notification.getNewValue();
                                if (!(object instanceof Cell)) break block4;
                                Cell cell = (Cell)object;
                                CellMapKey key = NattableModelManager.this.createCellMapKeyWaitingCellAxis(cell);
                                NattableModelManager.this.cellsMap.put((Object)key, (Object)cell);
                                break block4;
                            }
                            if (eventType != 5) break block7;
                            Object coll2 = notification.getNewValue();
                            if (!(coll2 instanceof Collection)) break block4;
                            for (Object object : (Collection)coll2) {
                                if (!(object instanceof Cell)) continue;
                                Cell cell = (Cell)object;
                                CellMapKey key = NattableModelManager.this.createCellMapKeyWaitingCellAxis(cell);
                                NattableModelManager.this.cellsMap.put((Object)key, (Object)cell);
                            }
                            break block4;
                        }
                        if (eventType != 4) break block8;
                        Object oldCell = notification.getOldValue();
                        if (!(oldCell instanceof Cell)) break block4;
                        CellMapKey key = (CellMapKey)NattableModelManager.this.cellsMap.inverse().get(oldCell);
                        NattableModelManager.this.cellsMap.remove((Object)key);
                        break block4;
                    }
                    if (eventType == 6 && (coll = notification.getOldValue()) instanceof Collection) {
                        for (Object object : (Collection)coll) {
                            if (!(object instanceof Cell)) continue;
                            CellMapKey key = (CellMapKey)NattableModelManager.this.cellsMap.inverse().get(object);
                            NattableModelManager.this.cellsMap.remove((Object)key);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                NattableModelManager.this.refreshNatTable();
            }
        });
        job.schedule();
        this.resourceSetListener = new ResourceSetListener(){

            public org.eclipse.emf.common.command.Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                return null;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                for (final Notification notification : event.getNotifications()) {
                    Table notifiedTable = NattableModelManager.findTable(notification);
                    if (!NattableModelManager.this.getTable().equals(notifiedTable)) continue;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).NattableModelManager.this.natTable != null && !(this).NattableModelManager.this.natTable.isDisposed()) {
                                EObject mergeContainer;
                                if (notification.getNotifier() instanceof BooleanValueStyle && ((mergeContainer = ((EObject)notification.getNotifier()).eContainer()) instanceof AbstractHeaderAxisConfiguration || mergeContainer instanceof IAxis)) {
                                    NattableModelManager.this.mergeTable();
                                }
                                if (notification.getNotifier() instanceof IntValueStyle) {
                                    EObject resizeContainer = ((EObject)notification.getNotifier()).eContainer();
                                    if (resizeContainer instanceof AbstractHeaderAxisConfiguration) {
                                        NattableModelManager.this.resizeHeader();
                                    }
                                    if (resizeContainer instanceof IAxis) {
                                        NattableModelManager.this.resizeAxis();
                                    }
                                }
                                if (notification.getNewValue() instanceof BooleanValueStyle) {
                                    NattableModelManager.this.mergeTable();
                                }
                                if (notification.getNewValue() instanceof IntValueStyle) {
                                    if (notification.getNotifier() instanceof IAxis) {
                                        NattableModelManager.this.resizeAxis();
                                    }
                                    if (notification.getNotifier() instanceof AbstractHeaderAxisConfiguration) {
                                        NattableModelManager.this.resizeHeader();
                                    }
                                }
                                if (notification.getNewValue() == null && notification.getOldValue() != null) {
                                    NattableModelManager.this.mergeTable();
                                    NattableModelManager.this.resizeAxis();
                                    NattableModelManager.this.resizeHeader();
                                }
                            }
                        }
                    });
                }
            }

            public boolean isPrecommitOnly() {
                return false;
            }

            public boolean isPostcommitOnly() {
                return false;
            }

            public boolean isAggregatePrecommitListener() {
                return false;
            }

            public NotificationFilter getFilter() {
                return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)3)).or(NotificationFilter.createEventTypeFilter((int)4)).and(NotificationFilter.createNotifierTypeFilter(BooleanValueStyle.class).or(NotificationFilter.createNotifierTypeFilter(IntValueStyle.class)).or(NotificationFilter.createNotifierTypeFilter(EObjectAxis.class)).or(NotificationFilter.createNotifierTypeFilter(FeatureIdAxis.class)).or(NotificationFilter.createNotifierTypeFilter(EStructuralFeatureAxis.class)).or(NotificationFilter.createNotifierTypeFilter(LocalTableHeaderAxisConfiguration.class)).or(NotificationFilter.createNotifierTypeFilter(Table.class)));
            }
        };
        this.getContextEditingDomain().addResourceSetListener(this.resourceSetListener);
        if (this.getTableEditingDomain() != null && this.getTableEditingDomain() != this.getContextEditingDomain()) {
            this.getTableEditingDomain().addResourceSetListener(this.resourceSetListener);
        }
    }

    @Override
    public Cell getCell(Object columnElement, Object rowElement) {
        CellMapKey key = new CellMapKey(columnElement, rowElement);
        return (Cell)this.cellsMap.get((Object)key);
    }

    private CellMapKey createCellMapKeyWaitingCellAxis(Cell cell) {
        while (cell.getColumnWrapper() == null || cell.getRowWrapper() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
        }
        while (cell.getColumnWrapper().getElement() == null || cell.getRowWrapper().getElement() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return new CellMapKey(cell.getColumnWrapper().getElement(), cell.getRowWrapper().getElement());
    }

    @Override
    public PreferenceStore getTablePreferenceStore() {
        return this.localPreferenceStore;
    }

    @Override
    public void setWorkspacePreferenceStore(PreferenceStore store) {
        this.localPreferenceStore = store;
    }

    @Override
    protected IFilterStrategy<Object> createFilterStrategy() {
        return new PapyrusFilterStrategy(this, new PapyrusColumnAccesor());
    }

    private Observer getOrCreateDecorationServiceObserver() {
        if (this.decoractionServiceObserver == null) {
            this.decoractionServiceObserver = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    NattableModelManager.this.refreshNatTable();
                }
            };
        }
        return this.decoractionServiceObserver;
    }

    protected void reinitialiseRowHeight() {
        IConfigRegistry configRegistry = this.natTable.getConfigRegistry();
        Boolean isAutoResizeRowsEnabled = (Boolean)configRegistry.getConfigAttribute(NattableConfigAttributes.REINITIALISE_ROW_HEIGHT, "NORMAL", new String[0]);
        if (isAutoResizeRowsEnabled.booleanValue()) {
            int rowIndex = 0;
            while (rowIndex < this.natTable.getRowCount()) {
                this.natTable.doCommand((ILayerCommand)new InitializeAutoResizeRowsCommand((ILayer)this.natTable, rowIndex, this.natTable.getConfigRegistry(), new GCFactory((Drawable)this.natTable)));
                ++rowIndex;
            }
            configRegistry.registerConfigAttribute(NattableConfigAttributes.REINITIALISE_ROW_HEIGHT, (Object)false);
        }
    }

    public class PapyrusColumnAccesor
    implements IColumnAccessor<Object> {
        public Object getDataValue(Object rowObject, int columnIndex) {
            return CellManagerFactory.INSTANCE.getCrossValue(NattableModelManager.this.getColumnElement(columnIndex), rowObject, NattableModelManager.this);
        }

        public void setDataValue(Object rowObject, int columnIndex, Object newValue) {
        }

        public int getColumnCount() {
            return 0;
        }
    }
}

