/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.infra.ui.extension.commands.ICreationCondition;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreationCommandExtensionFactory
extends ExtensionUtils {
    public static final CreationCommandExtensionFactory eINSTANCE = new CreationCommandExtensionFactory();
    public static final String CREATION_COMMAND_EXTENSIONPOINT = "creationCommand";
    public static final String CREATION_COMMAND_CLASS_ATTR = "creationCommandClass";
    public static final String CONDITION_COMMAND_CLASS_ATTR = "creationCondition";
    public static final String LABEL_ATTR = "label";
    public static final String ID_ATTRIBUTE = "id";
    public static final String ICON_ATTR = "icon";
    public static final String LANGUAGE_ATTR = "language";

    public static CreationCommandExtensionFactory getInstance() {
        return eINSTANCE;
    }

    public CreationCommandDescriptor createCreationCommand(IConfigurationElement element) throws ExtensionException {
        Class classCondition;
        String attributeForCreationCondition;
        this.checkTagName(element, CREATION_COMMAND_EXTENSIONPOINT);
        CreationCommandDescriptor res = new CreationCommandDescriptor();
        res.creationCommandClass = this.parseClass(element, CREATION_COMMAND_CLASS_ATTR, CREATION_COMMAND_EXTENSIONPOINT);
        res.commandId = element.getAttribute(ID_ATTRIBUTE);
        res.label = element.getAttribute(LABEL_ATTR);
        res.language = element.getAttribute(LANGUAGE_ATTR);
        String iconPath = element.getAttribute(ICON_ATTR);
        if (iconPath != null) {
            res.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)iconPath);
        }
        if ((attributeForCreationCondition = element.getAttribute(CONDITION_COMMAND_CLASS_ATTR)) != null && attributeForCreationCondition.length() > 0 && (classCondition = this.parseClass(element, CONDITION_COMMAND_CLASS_ATTR, CREATION_COMMAND_EXTENSIONPOINT)) != null) {
            try {
                res.setCondition((ICreationCondition)classCondition.newInstance());
            }
            catch (InstantiationException e) {
                throw new ExtensionException("can nott instantiate class : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new ExtensionException("can nott acces to class : " + e.getMessage());
            }
        }
        Activator.log.debug("a creation command ready " + res);
        return res;
    }
}

