/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.dnd;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.activity.dnd.InterfaceCreateTAndUpdateCommand;

public abstract class GenericCreateTAndUpdateCommand<T extends EObject, E extends EObject, S extends EObject>
extends AbstractCommand
implements InterfaceCreateTAndUpdateCommand {
    protected final EditPart targetEditPart;
    protected final boolean headless;
    protected final Class<T> typeParameterClass;
    protected final E targetElementDiagram;
    protected final S sourceElement;
    private final IHintedType typeToCreate;

    public GenericCreateTAndUpdateCommand(EditPart targetEditPart, Class<T> typeParameterClass, E targetElementDiagram, S sourceElement, boolean headless, IHintedType typeToCreate) {
        super("Create");
        this.targetEditPart = targetEditPart;
        this.headless = headless;
        this.typeParameterClass = typeParameterClass;
        this.targetElementDiagram = targetElementDiagram;
        this.sourceElement = sourceElement;
        this.typeToCreate = typeToCreate;
    }

    protected T getNewEObject(CreateElementRequest request) {
        if (this.typeParameterClass.isAssignableFrom(request.getNewElement().getClass())) {
            return (T)request.getNewElement();
        }
        return null;
    }

    public T getNewEObject(CommandResult commandResult) {
        Object objectResult = commandResult.getReturnValue();
        if (objectResult instanceof List) {
            List listResult = (List)objectResult;
            for (Object elementResult : listResult) {
                EObject newElement;
                CreateElementRequest request;
                if (!(elementResult instanceof CreateElementRequestAdapter) || (request = (CreateElementRequest)((CreateElementRequestAdapter)elementResult).getAdapter(CreateElementRequest.class)) == null || !this.typeParameterClass.isAssignableFrom((newElement = request.getNewElement()).getClass())) continue;
                EObject newObject = newElement;
                return (T)newObject;
            }
        } else if (this.typeParameterClass.isAssignableFrom(commandResult.getReturnValue().getClass())) {
            return (T)((EObject)commandResult.getReturnValue());
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.targetEditPart);
        CreateElementRequest createElementRequest = new CreateElementRequest(domain, this.targetElementDiagram, (IElementType)this.typeToCreate);
        CreateElementCommand creationElementCommand = new CreateElementCommand(createElementRequest);
        creationElementCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        CommandResult commandResult = creationElementCommand.getCommandResult();
        if (commandResult != null && !commandResult.getStatus().isOK()) {
            return commandResult;
        }
        T newCallBehaviorAction = this.getNewEObject(commandResult);
        if (newCallBehaviorAction == null) {
            newCallBehaviorAction = this.getNewEObject(createElementRequest);
        }
        if (newCallBehaviorAction == null) {
            return CommandResult.newErrorCommandResult((String)"Could not create the calloperation for operation");
        }
        this.updateNewlyCreatedEObjectWithEObjectDragged(newCallBehaviorAction, this.sourceElement);
        return CommandResult.newOKCommandResult();
    }

    protected abstract void updateNewlyCreatedEObjectWithEObjectDragged(T var1, S var2) throws ExecutionException;

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("not implemented");
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("not implemented");
    }
}

