/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.util.CommandTreeIterator;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy.CanonicalStateListener;
import org.eclipse.papyrus.infra.gmfdiag.canonical.internal.Activator;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ICreationTargetStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.IVisualChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.SemanticChildrenStrategyRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.RollingDeferredArrangeRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IPapyrusCanonicalEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.VisualTypeService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;

public class PapyrusCanonicalEditPolicy
extends CanonicalEditPolicy
implements IPapyrusCanonicalEditPolicy {
    static final String FILTER_ID = "org.eclipse.papyrus.canonicalDependents";
    static final String SEMI_ACTIVE_FILTER_ID = "org.eclipse.papyrus.semiCanonical";
    private static final Set<View> createdByCanonical = Sets.newSetFromMap(new WeakHashMap());
    private final RollingDeferredArrangeRequest.IArrangementContext arrangeContext = new RollingDeferredArrangeRequest.IArrangementContext(){

        public EditPart getHost() {
            return PapyrusCanonicalEditPolicy.this.getHost();
        }

        public void execute(org.eclipse.gef.commands.Command command) {
            PapyrusCanonicalEditPolicy.this.executeCommand(command);
        }
    };
    private ISemanticChildrenStrategy semanticChildrenStrategy = null;
    private ICreationTargetStrategy creationTargetStrategy;
    private Collection<? extends EObject> dependents = null;
    private CanonicalStateListener canonicalStateListener;
    private CanonicalStateListener.Handler refreshHandler;
    private State state = State.INACTIVE;
    private boolean overrideEnabled;
    private ChildrenKindStack currentChildrenKind;

    public final void activate() {
        if (this.host().getNotationView() != null) {
            SemanticChildrenStrategyRegistry reg = SemanticChildrenStrategyRegistry.getInstance();
            this.semanticChildrenStrategy = reg.getSemanticChildrenStrategy(this.getHost());
            this.creationTargetStrategy = ICreationTargetStrategy.Safe.safe(reg.getCreationTargetStrategy(this.getHost()));
            this.hookCanonicalStateListener();
            if (this.isEnabled()) {
                this.doActivate();
            } else {
                this.transition(State.SEMIACTIVE);
            }
        }
    }

    protected final void basicActivate() {
        this.transition(State.ACTIVE);
        super.activate();
    }

    protected void doActivate() {
        this.basicActivate();
        if (this.semanticChildrenStrategy != null) {
            this.dependents = this.semanticChildrenStrategy.getCanonicalDependents(this.getSemanticHost(), this.host().getNotationView());
            this.hookDependentsListener(this.dependents);
        }
    }

    public final void deactivate() {
        if (this.host().getNotationView() != null) {
            this.unhookCanonicalStateListener();
        }
        this.doDeactivate();
        this.transition(State.INACTIVE);
    }

    protected final void basicDeactivate() {
        super.deactivate();
        this.transition(State.SEMIACTIVE);
    }

    protected void doDeactivate() {
        this.basicDeactivate();
    }

    private State transition(State newState) {
        State result = this.state;
        if (newState != this.state) {
            if (!this.state.validateTransition(newState)) {
                Activator.log.warn(String.format("PapyrusCanonicalEditPolicy forcing invalid transition %s => %s ", new Object[]{this.state, newState}));
            }
            switch (newState) {
                case INACTIVE: {
                    this.removeListenerFilter(SEMI_ACTIVE_FILTER_ID);
                    break;
                }
                case SEMIACTIVE: {
                    EObject semanticHost = this.getSemanticHost();
                    if (semanticHost == null) break;
                    this.addListenerFilter(SEMI_ACTIVE_FILTER_ID, (NotificationListener)this, semanticHost);
                    break;
                }
                case ACTIVE: {
                    this.removeListenerFilter(SEMI_ACTIVE_FILTER_ID);
                }
            }
            this.state = newState;
        }
        return result;
    }

    protected final boolean isInState(State state) {
        return this.state == state;
    }

    public void enableRefresh(boolean enable) {
        if (!this.isInState(State.INACTIVE)) {
            super.enableRefresh(enable);
        }
    }

    public void refreshActive() {
        if (this.canonicalStateListener != null) {
            if (!this.isActive()) {
                if (this.isCanonicalStyleEnabled()) {
                    this.doActivate();
                    this.canonicalStateListener.pokeHandlers(this.refreshHandler, true);
                }
            } else if (!this.isCanonicalStyleEnabled()) {
                this.doDeactivate();
                this.canonicalStateListener.pokeHandlers(this.refreshHandler, false);
            }
        }
    }

    protected CanonicalStyle getCanonicalStyle() {
        return (CanonicalStyle)this.canonicalHost().getNotationView().getStyle(NotationPackage.eINSTANCE.getCanonicalStyle());
    }

    protected final IGraphicalEditPart canonicalHost() {
        IGraphicalEditPart result = this.host();
        if (result instanceof IResizableCompartmentEditPart) {
            result = result.getTopGraphicEditPart();
        }
        return result;
    }

    private void hookCanonicalStateListener() {
        this.refreshHandler = new CanonicalStateListener.Handler(){

            @Override
            public Runnable handleAdd(CanonicalStyle style) {
                Runnable result = null;
                if (style.isCanonical()) {
                    if (!PapyrusCanonicalEditPolicy.this.isActive()) {
                        class Activate
                        implements Runnable {
                            Activate() {
                            }

                            @Override
                            public void run() {
                                PapyrusCanonicalEditPolicy.this.doActivate();
                            }
                        }
                        result = new Activate();
                    }
                } else if (PapyrusCanonicalEditPolicy.this.isActive()) {
                    class Deactivate
                    implements Runnable {
                        Deactivate() {
                        }

                        @Override
                        public void run() {
                            PapyrusCanonicalEditPolicy.this.doDeactivate();
                        }
                    }
                    result = new Deactivate();
                }
                return result;
            }

            @Override
            public Runnable handleRemove(CanonicalStyle style) {
                Deactivate result = null;
                if (PapyrusCanonicalEditPolicy.this.isActive()) {
                    result = new Deactivate();
                }
                return result;
            }
        };
        this.canonicalStateListener = CanonicalStateListener.getInstance(this.canonicalHost());
        this.canonicalStateListener.addCanonicalRefreshHandler(this.refreshHandler);
    }

    private void unhookCanonicalStateListener() {
        if (this.canonicalStateListener != null) {
            this.canonicalStateListener.removeCanonicalRefreshHandler(this.refreshHandler);
            this.canonicalStateListener.release();
            this.canonicalStateListener = null;
        }
    }

    protected void hookDependentsListener(Iterable<? extends EObject> dependents) {
        if (dependents != null) {
            for (EObject eObject : dependents) {
                this.addListenerFilter(FILTER_ID, (NotificationListener)this, eObject);
            }
        }
    }

    public boolean isEnabled() {
        if (this.overrideEnabled) {
            return true;
        }
        if (this.getCanonicalStyle() == null) {
            return false;
        }
        return super.isEnabled();
    }

    protected boolean isCanonicalStyleEnabled() {
        CanonicalStyle style = this.getCanonicalStyle();
        return style != null && style.isCanonical();
    }

    protected List<EObject> getSemanticChildrenList() {
        List<EObject> result = this.getSemanticChildrenList(ChildrenKind.NODE);
        if (this.isManageConnections()) {
            result = PapyrusCanonicalEditPolicy.concat(result, this.getSemanticChildrenList(ChildrenKind.CONNECTION));
        }
        return result;
    }

    static <E> List<E> concat(Iterable<? extends E> list1, Iterable<? extends E> list2) {
        ArrayList result = null;
        if (list1 != null) {
            result = Lists.newArrayList(list1);
        }
        if (list2 != null) {
            if (result != null) {
                Iterables.addAll((Collection)result, list2);
            } else {
                result = Lists.newArrayList(list2);
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    protected List<EObject> getSemanticChildrenList(ChildrenKind kind) {
        if (this.semanticChildrenStrategy != null) {
            List<? extends EObject> children;
            ArrayList<EObject> ancestor = this.getAllEObjectAncestor();
            switch (kind) {
                case NODE: {
                    children = this.semanticChildrenStrategy.getCanonicalSemanticChildren(this.getSemanticHost(), this.host().getNotationView());
                    break;
                }
                case CONNECTION: {
                    children = this.semanticChildrenStrategy.getCanonicalSemanticConnections(this.getSemanticHost(), this.host().getNotationView());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.name());
                }
            }
            if (children != null) {
                for (EObject eObject : children) {
                    if (!ancestor.contains(eObject)) continue;
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(children);
            }
        }
        return Collections.emptyList();
    }

    protected ArrayList<EObject> getAllEObjectAncestor() {
        ArrayList<EObject> ancestor = new ArrayList<EObject>();
        EditPart currentEditPart = this.getHost();
        if (currentEditPart.getModel() instanceof View) {
            ancestor.add(((View)currentEditPart.getModel()).getElement());
        }
        while (currentEditPart.getParent() != null) {
            if (!((currentEditPart = currentEditPart.getParent()).getModel() instanceof View)) continue;
            ancestor.add(((View)currentEditPart.getModel()).getElement());
        }
        return ancestor;
    }

    protected void handleNotificationEvent(Notification event) {
        boolean oldOverride = this.overrideEnabled;
        this.overrideEnabled = this.overrideEnabled || this.isInState(State.SEMIACTIVE);
        try {
            super.handleNotificationEvent(event);
            if (this.semanticChildrenStrategy != null && this.dependents == null) {
                this.dependents = this.semanticChildrenStrategy.getCanonicalDependents(this.getSemanticHost(), this.host().getNotationView());
                this.hookDependentsListener(this.dependents);
            }
        }
        finally {
            this.overrideEnabled = oldOverride;
        }
    }

    protected boolean shouldHandleNotificationEvent(Notification event) {
        Object element;
        boolean result = super.shouldHandleNotificationEvent(event);
        if (!result && this.isManagedListCompartment() && (element = event.getNotifier()) instanceof EObject && !(element instanceof View)) {
            result = event.getEventType() == 7;
        }
        return result;
    }

    protected void refreshSemantic() {
        List<IAdaptable> createdViews = this.refreshSemanticChildren(ChildrenKind.NODE);
        this.makeViewsImmutable(createdViews);
        if (this.isManageConnections()) {
            ListenableFuture createdConnections = DiagramHelper.submit((EditPart)this.getHost(), (Callable)new Callable<List<IAdaptable>>(){

                @Override
                public List<IAdaptable> call() throws Exception {
                    return PapyrusCanonicalEditPolicy.this.refreshSemanticChildren(ChildrenKind.CONNECTION);
                }
            });
            Futures.addCallback((ListenableFuture)createdConnections, (FutureCallback)new FutureCallback<List<IAdaptable>>(){

                public void onSuccess(List<IAdaptable> result) {
                    PapyrusCanonicalEditPolicy.this.makeViewsImmutable(result);
                }

                public void onFailure(Throwable t) {
                    Activator.log.error(t);
                }
            });
        }
    }

    protected List<IAdaptable> refreshSemanticChildren(ChildrenKind kind) {
        if (this.resolveSemanticElement() == null) {
            return Collections.emptyList();
        }
        if (this.isInState(State.SEMIACTIVE) && createdByCanonical.isEmpty()) {
            return Collections.emptyList();
        }
        List<View> viewChildren = this.getViewChildren(kind);
        List<EObject> allSemanticChildren = this.getSemanticChildrenList(kind);
        ArrayList<EObject> semanticChildren = new ArrayList<EObject>(allSemanticChildren);
        boolean changed = false;
        if (!this.isInState(State.INACTIVE)) {
            List orphaned = this.cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
            if (!orphaned.isEmpty() && this.isInState(State.SEMIACTIVE)) {
                this.filterCanonicallyCreated(orphaned);
            }
            if (!orphaned.isEmpty()) {
                changed = this.deleteViews(orphaned);
            }
        }
        List createdViews = Collections.emptyList();
        if (this.isInState(State.ACTIVE)) {
            List<? extends View> newViewOrder;
            if (!semanticChildren.isEmpty()) {
                this.pushChildrenKind(kind);
                try {
                    createdViews = this.createViews(semanticChildren);
                }
                finally {
                    this.popChildrenKind();
                }
            }
            if (this.isManagedListCompartment() && (newViewOrder = this.matchCanonicalOrdering(viewChildren, allSemanticChildren)) != null) {
                this.setViewOrder(newViewOrder);
            }
        }
        if (changed || !createdViews.isEmpty()) {
            this.postProcessRefreshSemantic(createdViews);
        }
        return createdViews;
    }

    private void pushChildrenKind(ChildrenKind kind) {
        this.currentChildrenKind = new ChildrenKindStack(kind);
    }

    private void popChildrenKind() {
        this.currentChildrenKind = this.currentChildrenKind.parent();
    }

    protected final ChildrenKind currentChildrenKind() {
        return this.currentChildrenKind == null ? null : this.currentChildrenKind.kind();
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        if (super.isOrphaned(semanticChildren, view)) {
            return this.isNoSemanticConnectorOrphaned(semanticChildren, view);
        }
        return false;
    }

    private boolean isNoSemanticConnectorOrphaned(Collection<EObject> semanticChildren, View view) {
        EObject element = view.getElement();
        if (element != null || !(view instanceof Connector)) {
            return true;
        }
        EdgeWithNoSemanticElementRepresentationImpl noSemanticConnector = this.createNoSemanticConnector((Connector)view);
        return !semanticChildren.contains(noSemanticConnector);
    }

    private EdgeWithNoSemanticElementRepresentationImpl createNoSemanticConnector(Connector connector) {
        return new EdgeWithNoSemanticElementRepresentationImpl(connector.getSource().getElement(), connector.getTarget().getElement(), connector.getType());
    }

    protected boolean deleteViews(Iterable<? extends View> views) {
        boolean bl;
        if (!this.isEnabled() && this.isInState(State.INACTIVE)) {
            return false;
        }
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.DeleteCommand_Label);
        for (View view : views) {
            if (!this.shouldDeleteView(view)) continue;
            cc.add(this.getDeleteViewCommand(view));
        }
        boolean bl2 = bl = !cc.isEmpty() && cc.canExecute();
        if (bl) {
            this.executeCommand((org.eclipse.gef.commands.Command)cc);
        }
        return bl;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element) {
        Object result;
        String viewType;
        boolean isEdge = false;
        IGraphicalEditPart parentPart = this.host();
        IGraphicalEditPart sourcePart = null;
        IGraphicalEditPart targetPart = null;
        switch (this.currentChildrenKind()) {
            case NODE: {
                viewType = VisualTypeService.getInstance().getNodeType(parentPart.getNotationView(), element);
                break;
            }
            case CONNECTION: {
                isEdge = true;
                parentPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.host());
                viewType = VisualTypeService.getInstance().getLinkType(this.host().getNotationView().getDiagram(), element);
                if (viewType == null) break;
                sourcePart = this.semanticChildrenStrategy.resolveSourceEditPart(element, this.host());
                targetPart = this.semanticChildrenStrategy.resolveTargetEditPart(element, this.host());
                break;
            }
            default: {
                viewType = null;
            }
        }
        if (viewType != null && (!isEdge || sourcePart != null && targetPart != null)) {
            SemanticElementAdapter elementAdapter = new SemanticElementAdapter(element, VisualTypeService.getInstance().getElementType(this.host().getNotationView().getDiagram(), viewType));
            int pos = this.getViewIndexFor(element);
            result = isEdge ? new ChildConnectionDescriptor((IAdaptable)elementAdapter, viewType, pos, (EditPart)sourcePart, (EditPart)targetPart) : new ChildNodeDescriptor((IAdaptable)elementAdapter, viewType, pos, (EditPart)parentPart);
        } else {
            result = super.getViewDescriptor(element);
        }
        return result;
    }

    protected org.eclipse.gef.commands.Command getCreateViewCommand(CreateRequest request) {
        org.eclipse.gef.commands.Command result;
        if (!(request instanceof CreateViewRequest)) {
            result = super.getCreateViewCommand(request);
        } else {
            CreateViewRequest createViewRequest = (CreateViewRequest)request;
            List descriptors = createViewRequest.getViewDescriptors();
            CompoundCommand compoundCommand = new CompoundCommand();
            for (CreateViewRequest.ViewDescriptor viewDescriptor : descriptors) {
                org.eclipse.gef.commands.Command cmd;
                EditPart targetEditPart;
                EObject element = (EObject)viewDescriptor.getElementAdapter().getAdapter(EObject.class);
                if (element == null) continue;
                CreateRequest newRequest = this.createCreateRequest(viewDescriptor);
                if (newRequest instanceof CreateConnectionViewRequest) {
                    EditPart sourceEditPart = ((CreateConnectionViewRequest)newRequest).getSourceEditPart();
                    targetEditPart = ((CreateConnectionViewRequest)newRequest).getTargetEditPart();
                    newRequest.setType((Object)"connection start");
                    sourceEditPart.getCommand((Request)newRequest);
                    newRequest.setType((Object)"connection end");
                    cmd = targetEditPart.getCommand((Request)newRequest);
                } else {
                    IGraphicalEditPart parentEditPart = viewDescriptor instanceof ChildNodeDescriptor ? ((ChildNodeDescriptor)viewDescriptor).getParentEditPart() : this.host();
                    targetEditPart = this.creationTargetStrategy.getTargetEditPart((EditPart)parentEditPart, element);
                    cmd = targetEditPart.getCommand((Request)newRequest);
                }
                if (cmd == null || !cmd.canExecute()) continue;
                compoundCommand.add(cmd);
            }
            result = compoundCommand.unwrap();
            if (result.canExecute()) {
                result = this.tagAndArrange(result);
            }
        }
        return result;
    }

    protected CreateRequest createCreateRequest(CreateViewRequest.ViewDescriptor viewDescriptor) {
        CreateViewRequest result;
        if (viewDescriptor instanceof CreateConnectionViewRequest.ConnectionViewDescriptor) {
            CreateConnectionViewRequest.ConnectionViewDescriptor cvd = (CreateConnectionViewRequest.ConnectionViewDescriptor)viewDescriptor;
            CreateConnectionViewRequest ccvr = new CreateConnectionViewRequest(cvd);
            if (cvd instanceof ChildConnectionDescriptor) {
                ChildConnectionDescriptor ccd = (ChildConnectionDescriptor)cvd;
                ccvr.setSourceEditPart(ccd.getSourceEditPart());
                ccvr.setTargetEditPart(ccd.getTargetEditPart());
            }
            ccvr.setLocation(new Point(-1, -1));
            result = ccvr;
        } else {
            result = new CreateViewRequest(viewDescriptor);
        }
        return result;
    }

    protected List<View> getViewChildren() {
        List<View> result = this.getViewChildren(ChildrenKind.NODE);
        if (this.isManageConnections()) {
            result.addAll(this.getViewChildren(ChildrenKind.CONNECTION));
        }
        return result;
    }

    protected List<View> getViewChildren(ChildrenKind kind) {
        List<? extends View> childViews;
        IGraphicalEditPart host = this.host();
        View view = host.getNotationView();
        IVisualChildrenStrategy strategy = SemanticChildrenStrategyRegistry.getInstance().getVisualChildrenStrategy((EditPart)host);
        if (strategy == null) {
            strategy = IVisualChildrenStrategy.DEFAULT;
        }
        switch (kind) {
            case NODE: {
                childViews = strategy.getCanonicalChildren((EditPart)host, view);
                break;
            }
            case CONNECTION: {
                childViews = strategy.getCanonicalEdges((EditPart)host, view);
                break;
            }
            default: {
                throw new IllegalArgumentException(kind.name());
            }
        }
        ArrayList result = childViews == null ? Collections.emptyList() : Lists.newArrayList(childViews);
        return result;
    }

    protected boolean isManageConnections() {
        IGraphicalEditPart host = this.host();
        return host instanceof TopGraphicEditPart || host instanceof IBorderItemEditPart;
    }

    private org.eclipse.gef.commands.Command tagAndArrange(org.eclipse.gef.commands.Command creationCommand) {
        return new PostCreationWrapperCommand<List<IAdaptable>>(creationCommand){

            @Override
            protected List<IAdaptable> createAccumulator() {
                return Lists.newArrayList();
            }

            @Override
            protected void postProcessView(Object viewish, List<IAdaptable> accumulator) {
                if (viewish instanceof IAdaptable) {
                    View view = (View)((IAdaptable)viewish).getAdapter(View.class);
                    if (view != null && view instanceof DecorationNode) {
                        view = (View)view.eContainer();
                        viewish = new EObjectAdapter((EObject)view);
                    }
                    accumulator.add((IAdaptable)viewish);
                }
                super.postProcessView(viewish, accumulator);
            }

            @Override
            protected void postProcessView(View view, List<IAdaptable> accumulator) {
                createdByCanonical.add(view);
            }

            @Override
            protected void complete(List<IAdaptable> accumulator) {
                if (!accumulator.isEmpty()) {
                    RollingDeferredArrangeRequest.post((RollingDeferredArrangeRequest.IArrangementContext)PapyrusCanonicalEditPolicy.this.arrangeContext, accumulator);
                }
            }
        };
    }

    private <C extends Collection<? extends View>> C filterCanonicallyCreated(C views) {
        Iterator<? extends View> iter = views.iterator();
        while (iter.hasNext()) {
            if (createdByCanonical.contains(iter.next())) continue;
            iter.remove();
        }
        return views;
    }

    protected boolean isManagedListCompartment() {
        boolean result = false;
        if (this.host() instanceof ListCompartmentEditPart) {
            SortingStyle style = (SortingStyle)this.host().getNotationView().getStyle(NotationPackage.Literals.SORTING_STYLE);
            result = style == null || style.getSorting() == Sorting.NONE_LITERAL;
        }
        return result;
    }

    protected List<? extends View> matchCanonicalOrdering(List<? extends View> viewChildren, final List<EObject> semanticChildren) {
        List result = Ordering.natural().onResultOf((Function)new Function<View, Integer>(){

            public Integer apply(View input) {
                return semanticChildren.indexOf(input.getElement());
            }
        }).sortedCopy(viewChildren);
        if (result.equals(viewChildren)) {
            result = null;
        }
        return result;
    }

    protected void setViewOrder(List<? extends View> childViews) {
        IGraphicalEditPart host = this.host();
        this.executeCommand(EMFtoGEFCommandWrapper.wrap((Command)SetCommand.create((EditingDomain)host.getEditingDomain(), (Object)host.getNotationView(), (Object)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN, childViews)));
    }

    private class ChildConnectionDescriptor
    extends CreateConnectionViewRequest.ConnectionViewDescriptor {
        private final EditPart sourceEditPart;
        private final EditPart targetEditPart;

        public ChildConnectionDescriptor(IAdaptable elementAdapter, String factoryHint, int index, EditPart sourceEditPart, EditPart targetEditPart) {
            super(elementAdapter, factoryHint, index, PapyrusCanonicalEditPolicy.this.host().getDiagramPreferencesHint());
            this.sourceEditPart = sourceEditPart;
            this.targetEditPart = targetEditPart;
        }

        EditPart getSourceEditPart() {
            return this.sourceEditPart;
        }

        EditPart getTargetEditPart() {
            return this.targetEditPart;
        }
    }

    private class ChildNodeDescriptor
    extends CreateViewRequest.ViewDescriptor {
        private final EditPart parentEditPart;

        public ChildNodeDescriptor(IAdaptable elementAdapter, String factoryHint, int index, EditPart parentEditPart) {
            super(elementAdapter, Node.class, factoryHint, index, PapyrusCanonicalEditPolicy.this.host().getDiagramPreferencesHint());
            this.parentEditPart = parentEditPart;
        }

        EditPart getParentEditPart() {
            return this.parentEditPart;
        }
    }

    protected static enum ChildrenKind {
        NODE,
        CONNECTION;

    }

    private final class ChildrenKindStack {
        private final ChildrenKind kind;
        private final ChildrenKindStack parent;

        ChildrenKindStack(ChildrenKind kind) {
            this.kind = kind;
            this.parent = PapyrusCanonicalEditPolicy.this.currentChildrenKind;
        }

        ChildrenKind kind() {
            return this.kind;
        }

        ChildrenKindStack parent() {
            return this.parent;
        }
    }

    protected static abstract class PostCreationWrapperCommand<A>
    extends GEFCommandWrapper {
        public PostCreationWrapperCommand(org.eclipse.gef.commands.Command command) {
            super(command);
        }

        public void execute() {
            super.execute();
            A accumulator = this.createAccumulator();
            this.postProcessViews(this.getCommand(), accumulator);
            this.complete(accumulator);
        }

        protected A createAccumulator() {
            return null;
        }

        protected void complete(A accumulator) {
        }

        private void postProcessViews(org.eclipse.gef.commands.Command command, A accumulator) {
            CommandTreeIterator iter = CommandTreeIterator.iterateGMF((Object)command);
            while (iter.hasNext()) {
                CommandResult result = ((ICommand)iter.next()).getCommandResult();
                if (result == null || result.getStatus() != null && !result.getStatus().isOK()) continue;
                Object returnValue = result.getReturnValue();
                if (returnValue instanceof Iterable) {
                    for (Object next : (Iterable)returnValue) {
                        this.postProcessView(next, accumulator);
                    }
                    continue;
                }
                if (returnValue == null) continue;
                this.postProcessView(returnValue, accumulator);
            }
        }

        protected void postProcessView(Object viewish, A accumulator) {
            View view = (View)PlatformHelper.getAdapter((Object)viewish, View.class);
            if (view != null) {
                this.postProcessView(view, accumulator);
            }
        }

        protected void postProcessView(View view, A accumulator) {
        }
    }

    protected static enum State {
        INACTIVE,
        SEMIACTIVE,
        ACTIVE;


        boolean validateTransition(State next) {
            switch (this) {
                case INACTIVE: 
                case SEMIACTIVE: {
                    return next != this;
                }
                case ACTIVE: {
                    return next == SEMIACTIVE;
                }
            }
            throw new IllegalStateException("No such state: " + (Object)((Object)this));
        }
    }
}

