/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class WorkspaceSaveHelper {
    WorkspaceSaveHelper() {
    }

    void initializeSaveDelegates(ISavedState state, List<SaveDelegate> saveDelegates) throws CoreException {
        SaveDelegate[] currentDelegate = new SaveDelegate[1];
        state = this.delegatingSavedState(state, () -> currentDelegate[0]);
        Iterator<SaveDelegate> iterator = saveDelegates.iterator();
        while (iterator.hasNext()) {
            SaveDelegate next;
            currentDelegate[0] = next = iterator.next();
            next.initializer.accept(state);
        }
    }

    ISaveParticipant createSaveParticipant(List<SaveDelegate> saveDelegates) {
        return new DelegatingSaveParticipant(saveDelegates);
    }

    private ISaveContext delegatingSaveContext(final ISaveContext context, final Supplier<? extends SaveDelegate> currentDelegate) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                block10: {
                    if (method.getDeclaringClass() != ISaveContext.class) break block10;
                    switch (method.getName()) {
                        case "getFiles": {
                            if (method.getParameterCount() != 0) break;
                            return this.getFiles();
                        }
                        case "map": {
                            if (method.getParameterCount() != 2) break;
                            return this.map((IPath)args[0], (IPath)args[1]);
                        }
                    }
                }
                return method.invoke((Object)context, args);
            }

            private IPath[] getFiles() {
                IPath prefix = ((SaveDelegate)currentDelegate.get()).pathPrefix;
                return (IPath[])Stream.of(context.getFiles()).filter(arg_0 -> ((IPath)prefix).isPrefixOf(arg_0)).map(p -> p.makeRelativeTo(prefix)).toArray(IPath[]::new);
            }

            private Void map(IPath path, IPath location) {
                context.map(((SaveDelegate)currentDelegate.get()).pathPrefix.append(path), location);
                return null;
            }
        };
        return (ISaveContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ISaveContext.class}, handler);
    }

    private ISavedState delegatingSavedState(final ISavedState state, final Supplier<? extends SaveDelegate> currentDelegate) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                block10: {
                    if (method.getDeclaringClass() != ISavedState.class) break block10;
                    switch (method.getName()) {
                        case "getFiles": {
                            if (method.getParameterCount() != 0) break;
                            return this.getFiles();
                        }
                        case "lookup": {
                            if (method.getParameterCount() != 1) break;
                            return this.lookup((IPath)args[0]);
                        }
                    }
                }
                return method.invoke((Object)state, args);
            }

            private IPath[] getFiles() {
                IPath prefix = ((SaveDelegate)currentDelegate.get()).pathPrefix;
                return (IPath[])Stream.of(state.getFiles()).filter(arg_0 -> ((IPath)prefix).isPrefixOf(arg_0)).map(p -> p.makeRelativeTo(prefix)).toArray(IPath[]::new);
            }

            private IPath lookup(IPath path) {
                return state.lookup(((SaveDelegate)currentDelegate.get()).pathPrefix.append(path));
            }
        };
        return (ISavedState)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ISavedState.class}, handler);
    }

    private class DelegatingSaveParticipant
    implements ISaveParticipant {
        private final List<SaveDelegate> delegates;

        DelegatingSaveParticipant(Collection<? extends SaveDelegate> delegates) {
            this.delegates = ImmutableList.copyOf(delegates);
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
            if (context.getKind() == 1) {
                this.iterate(context, ISaveParticipant::prepareToSave);
            }
        }

        public void saving(ISaveContext context) throws CoreException {
            if (context.getKind() == 1) {
                this.iterate(context, ISaveParticipant::saving);
                context.needSaveNumber();
            }
        }

        public void doneSaving(ISaveContext context) {
            if (context.getKind() == 1) {
                this.safeIterate(context, ISaveParticipant::doneSaving);
            }
        }

        public void rollback(ISaveContext context) {
            if (context.getKind() == 1) {
                this.safeIterate(context, ISaveParticipant::rollback);
            }
        }

        void iterate(ISaveContext context, SaveAction saveAction) throws CoreException {
            SaveDelegate[] current = new SaveDelegate[1];
            ISaveContext privateContext = WorkspaceSaveHelper.this.delegatingSaveContext(context, () -> current[0]);
            Iterator<SaveDelegate> iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                SaveDelegate next;
                current[0] = next = iterator.next();
                saveAction.accept(next.participant, privateContext);
            }
        }

        void safeIterate(ISaveContext context, BiConsumer<? super ISaveParticipant, ? super ISaveContext> saveAction) {
            SaveDelegate[] current = new SaveDelegate[1];
            ISaveContext privateContext = WorkspaceSaveHelper.this.delegatingSaveContext(context, () -> current[0]);
            Iterator<SaveDelegate> iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                SaveDelegate next;
                current[0] = next = iterator.next();
                saveAction.accept((ISaveParticipant)next.participant, (ISaveContext)privateContext);
            }
        }
    }

    @FunctionalInterface
    static interface InitAction {
        public void accept(ISavedState var1) throws CoreException;
    }

    @FunctionalInterface
    static interface SaveAction {
        public void accept(ISaveParticipant var1, ISaveContext var2) throws CoreException;
    }

    static final class SaveDelegate {
        final IPath pathPrefix;
        final ISaveParticipant participant;
        final InitAction initializer;

        SaveDelegate(String pathPrefix, ISaveParticipant participant, InitAction initializer) {
            this.pathPrefix = new Path(pathPrefix);
            this.participant = participant;
            this.initializer = initializer;
        }
    }
}

