/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.architecture.internal.customizationconfiguration.comparators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.architecture.api.ICustomizationReferenceMerger;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.AbsoluteOrder;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.CustomizationConfigurationPackage;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.CustomizationReference;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.EMFFacetTreeViewerConfiguration;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.IApplicationRule;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.Location;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.Redefinition;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.RelativeOrder;
import org.eclipse.papyrus.emf.facet.architecture.internal.customizationconfiguration.comparators.CustomizationReferenceAbsoluteOrderComparator;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;

public class CustomizationReferenceMerger
implements ICustomizationReferenceMerger {
    private final Collection<EMFFacetTreeViewerConfiguration> input;
    private final List<Customization> mergedCustomizations = new ArrayList<Customization>();
    private final Map<EObject, List<IStatus>> statusMap = new HashMap<EObject, List<IStatus>>();

    public CustomizationReferenceMerger(Collection<EMFFacetTreeViewerConfiguration> references) {
        this.input = references;
    }

    @Override
    public boolean doValidationAndMerge() {
        this.statusMap.clear();
        this.mergedCustomizations.clear();
        if (this.input == null || this.input.isEmpty()) {
            return this.isValid();
        }
        List<CustomizationReference> intermediateState = new ArrayList<CustomizationReference>();
        this.checkInput();
        ArrayList<List<EMFFacetTreeViewerConfiguration>> configurationToMergeByLevel = new ArrayList<List<EMFFacetTreeViewerConfiguration>>();
        ArrayList<EMFFacetTreeViewerConfiguration> roots = new ArrayList<EMFFacetTreeViewerConfiguration>();
        if (this.isValid()) {
            configurationToMergeByLevel.addAll(this.organizeEMFFacetTreeViewerConfigurations(this.input));
            roots.addAll((Collection)configurationToMergeByLevel.remove(0));
            this.checkRootsDefinitions(roots);
            if (this.isValid()) {
                ArrayList<CustomizationReference> allAbsoluteOrder = new ArrayList<CustomizationReference>();
                for (EMFFacetTreeViewerConfiguration current : roots) {
                    allAbsoluteOrder.addAll((Collection<CustomizationReference>)current.getCustomizationReferences());
                }
                ArrayList<EMFFacetTreeViewerConfiguration> absoluteOrderLocation = new ArrayList<EMFFacetTreeViewerConfiguration>(this.input);
                absoluteOrderLocation.removeAll(roots);
                allAbsoluteOrder.addAll(this.getAllAbsoluteOrder(absoluteOrderLocation));
                this.checkAbsoluteOrderUnitity(allAbsoluteOrder);
                if (this.isValid()) {
                    intermediateState.addAll(allAbsoluteOrder);
                    Collections.sort(intermediateState, new CustomizationReferenceAbsoluteOrderComparator());
                    List<List<CustomizationReference>> customizationReferenceByLevel = this.organizeCustomizationReferences(configurationToMergeByLevel);
                    this.excludeAbsoluteOrder(customizationReferenceByLevel);
                    this.checkRedefines(customizationReferenceByLevel);
                    if (this.isValid()) {
                        this.checkBeforeAfter(customizationReferenceByLevel);
                        if (this.isValid()) {
                            for (List<CustomizationReference> referencesList : customizationReferenceByLevel) {
                                List<CustomizationReference> newState = this.mergeCustomization(Collections.unmodifiableList(intermediateState), referencesList);
                                if (!this.isValid()) break;
                                intermediateState = newState;
                            }
                        }
                    }
                }
            }
        }
        for (CustomizationReference current : intermediateState) {
            this.mergedCustomizations.add(current.getReferencedCustomization());
        }
        return this.isValid();
    }

    @Override
    public Map<EObject, IStatus> getStatus() {
        HashMap<EObject, IStatus> resultingStatus = new HashMap<EObject, IStatus>();
        for (Map.Entry<EObject, List<IStatus>> entry : this.statusMap.entrySet()) {
            if (entry.getValue().size() > 1) {
                MultiStatus multiStatus = new MultiStatus("org.eclipse.papyrus.emf.facet.architecture", 14, "Several error on me");
                for (IStatus current : entry.getValue()) {
                    multiStatus.add(current);
                }
                resultingStatus.put(entry.getKey(), (IStatus)multiStatus);
                continue;
            }
            resultingStatus.put(entry.getKey(), entry.getValue().get(0));
        }
        return resultingStatus;
    }

    @Override
    public List<Customization> getMergedCustomizations() {
        return this.mergedCustomizations;
    }

    @Override
    public boolean isValid() {
        return this.statusMap.isEmpty();
    }

    private void checkInput() {
        for (EMFFacetTreeViewerConfiguration current : this.input) {
            if (current.getExtends() == null || this.input.contains(current.getExtends())) continue;
            this.createErrorStatus((EObject)current, 1, NLS.bind((String)"I'm extending a configuration which is not available in the current {0}.", (Object)ArchitecturePackage.eINSTANCE.getArchitectureDescriptionLanguage().getName()));
        }
        block1: for (EMFFacetTreeViewerConfiguration current : this.input) {
            ArrayList<EMFFacetTreeViewerConfiguration> alreadyCrossed = new ArrayList<EMFFacetTreeViewerConfiguration>();
            EMFFacetTreeViewerConfiguration tmp = current;
            while (tmp != null) {
                if (alreadyCrossed.contains(tmp)) {
                    this.createErrorStatus((EObject)current, 2, NLS.bind((String)"There is an infinite loop with with the extends declaration.", null));
                    continue block1;
                }
                alreadyCrossed.add(tmp);
                tmp = tmp.getExtends();
            }
        }
    }

    private void createErrorStatus(EObject eobjectInError, int errorCode, String message) {
        Status status = new Status(4, "org.eclipse.papyrus.emf.facet.architecture", errorCode, message, null);
        List<IStatus> list = this.statusMap.get(eobjectInError);
        if (list == null) {
            list = new ArrayList<IStatus>();
            this.statusMap.put(eobjectInError, list);
        }
        list.add((IStatus)status);
    }

    private void checkRootsDefinitions(Collection<EMFFacetTreeViewerConfiguration> roots) {
        for (EMFFacetTreeViewerConfiguration current : roots) {
            for (CustomizationReference custoRef : current.getCustomizationReferences()) {
                IApplicationRule rule = custoRef.getApplicationRule();
                if (rule instanceof AbsoluteOrder) continue;
                ArrayList<String> args = new ArrayList<String>();
                args.add(CustomizationConfigurationPackage.eINSTANCE.getEMFFacetTreeViewerConfiguration().getName());
                args.add(CustomizationConfigurationPackage.eINSTANCE.getCustomizationReference().getName());
                args.add(CustomizationConfigurationPackage.eINSTANCE.getAbsoluteOrder().getName());
                this.createErrorStatus(custoRef, 3, NLS.bind((String)"In the root {0}, the {0} must only use {1} to define customization", (Object[])args.toArray()));
            }
        }
    }

    private List<CustomizationReference> getAllAbsoluteOrder(Collection<EMFFacetTreeViewerConfiguration> input) {
        ArrayList<CustomizationReference> absoluteOrder = new ArrayList<CustomizationReference>();
        for (EMFFacetTreeViewerConfiguration current : input) {
            for (CustomizationReference tmp : current.getCustomizationReferences()) {
                if (!(tmp.getApplicationRule() instanceof AbsoluteOrder)) continue;
                absoluteOrder.add(tmp);
            }
        }
        return absoluteOrder;
    }

    private void checkAbsoluteOrderUnitity(List<CustomizationReference> allAbsoluteOrder) {
        HashMap<Integer, ArrayList<CustomizationReference>> order = new HashMap<Integer, ArrayList<CustomizationReference>>();
        for (CustomizationReference customizationReference : allAbsoluteOrder) {
            AbsoluteOrder absOrder = (AbsoluteOrder)customizationReference.getApplicationRule();
            Integer intOrder = absOrder.getOrder();
            ArrayList<CustomizationReference> list = (ArrayList<CustomizationReference>)order.get(intOrder);
            if (list == null) {
                list = new ArrayList<CustomizationReference>();
                order.put(intOrder, list);
            }
            list.add(customizationReference);
        }
        for (Map.Entry entry : order.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (CustomizationReference custoRef : (List)entry.getValue()) {
                this.createErrorStatus(custoRef, 4, NLS.bind((String)"Another customization is already defined with the priority {0}", entry.getKey()));
            }
        }
    }

    private List<List<EMFFacetTreeViewerConfiguration>> organizeEMFFacetTreeViewerConfigurations(Collection<EMFFacetTreeViewerConfiguration> input) {
        HashMap<EMFFacetTreeViewerConfiguration, ArrayList<EMFFacetTreeViewerConfiguration>> extendedByMap = new HashMap<EMFFacetTreeViewerConfiguration, ArrayList<EMFFacetTreeViewerConfiguration>>();
        ArrayList<EMFFacetTreeViewerConfiguration> extendsNothing = new ArrayList<EMFFacetTreeViewerConfiguration>();
        for (EMFFacetTreeViewerConfiguration current : input) {
            EMFFacetTreeViewerConfiguration extends_ = current.getExtends();
            if (extends_ == null) {
                extendsNothing.add(current);
                continue;
            }
            ArrayList<EMFFacetTreeViewerConfiguration> list = (ArrayList<EMFFacetTreeViewerConfiguration>)extendedByMap.get(extends_);
            if (list == null) {
                list = new ArrayList<EMFFacetTreeViewerConfiguration>();
                extendedByMap.put(extends_, list);
            }
            list.add(current);
        }
        ArrayList<List<EMFFacetTreeViewerConfiguration>> extension = new ArrayList<List<EMFFacetTreeViewerConfiguration>>();
        extension.add(extendsNothing);
        int index = 0;
        while (extendedByMap.size() > 0) {
            ArrayList nextLevelExtension = new ArrayList();
            for (EMFFacetTreeViewerConfiguration current : (List)extension.get(index)) {
                if (extendedByMap.get(current) == null) continue;
                nextLevelExtension.addAll((Collection)extendedByMap.get(current));
                extendedByMap.remove(current);
            }
            extension.add(nextLevelExtension);
            ++index;
        }
        return extension;
    }

    private List<CustomizationReference> mergeCustomization(List<CustomizationReference> intermediateState, List<CustomizationReference> referencesList) {
        int index;
        IApplicationRule rule;
        ArrayList<CustomizationReference> workingList = new ArrayList<CustomizationReference>(intermediateState);
        ArrayList<CustomizationReference> beforeAfter = new ArrayList<CustomizationReference>();
        for (CustomizationReference current : referencesList) {
            rule = current.getApplicationRule();
            if (rule instanceof Redefinition) {
                CustomizationReference redefinedCustomization = ((Redefinition)rule).getRedefinedCustomizationReference();
                index = workingList.indexOf(redefinedCustomization);
                if (index >= 0) {
                    workingList.set(index, current);
                    continue;
                }
                this.createErrorStatus(rule, 11, NLS.bind((String)"The redefined Customization {0} has not be found by the merge process.", (Object)redefinedCustomization.getReferencedCustomization().getName()));
                continue;
            }
            if (!(rule instanceof RelativeOrder)) continue;
            beforeAfter.add(current);
        }
        for (CustomizationReference current : beforeAfter) {
            rule = (RelativeOrder)current.getApplicationRule();
            CustomizationReference relativeRef = rule.getRelativeCustomizationReference();
            index = workingList.indexOf(relativeRef);
            Location location = rule.getLocation();
            if (index >= 0) {
                if (location == Location.BEFORE) {
                    workingList.add(index, current);
                    continue;
                }
                workingList.add(++index, current);
                continue;
            }
            int errorCode = location == Location.BEFORE ? 12 : 13;
            this.createErrorStatus(rule, errorCode, NLS.bind((String)"The relative customization {0} has not been found by the merge process", (Object)relativeRef.getReferencedCustomization().getName()));
        }
        return workingList;
    }

    private void checkRedefines(List<List<CustomizationReference>> customizationReferenceByLevel) {
        HashMap<CustomizationReference, ArrayList<CustomizationReference>> redefinitionMap = new HashMap<CustomizationReference, ArrayList<CustomizationReference>>();
        for (List<CustomizationReference> list : customizationReferenceByLevel) {
            for (CustomizationReference custoRef : list) {
                IApplicationRule rule = custoRef.getApplicationRule();
                if (!(rule instanceof Redefinition)) continue;
                Redefinition redefinition = (Redefinition)rule;
                CustomizationReference referencedCusto = redefinition.getRedefinedCustomizationReference();
                ArrayList<CustomizationReference> list2 = (ArrayList<CustomizationReference>)redefinitionMap.get(referencedCusto);
                if (list2 == null) {
                    list2 = new ArrayList<CustomizationReference>();
                    redefinitionMap.put(referencedCusto, list2);
                }
                list2.add(custoRef);
            }
        }
        for (Map.Entry entry : redefinitionMap.entrySet()) {
            if (((List)entry.getValue()).size() == 1) continue;
            this.createErrorStatus((EObject)entry.getKey(), 5, NLS.bind((String)"{0}: I'm redefined {1} timeinstead of 1 time.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName(), (Object)((List)entry.getValue()).size()));
            for (CustomizationReference ref : (List)entry.getValue()) {
                this.createErrorStatus(ref, 6, NLS.bind((String)"I'm not alone to redefine the Customization {0}.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName()));
            }
        }
    }

    private void checkBeforeAfter(List<List<CustomizationReference>> customizationReferenceByLevel) {
        HashMap<CustomizationReference, ArrayList<CustomizationReference>> before = new HashMap<CustomizationReference, ArrayList<CustomizationReference>>();
        HashMap<CustomizationReference, ArrayList<CustomizationReference>> after = new HashMap<CustomizationReference, ArrayList<CustomizationReference>>();
        for (List<CustomizationReference> list : customizationReferenceByLevel) {
            for (CustomizationReference custoRef : list) {
                List<CustomizationReference> list2;
                IApplicationRule rule = custoRef.getApplicationRule();
                if (!(rule instanceof RelativeOrder)) continue;
                RelativeOrder order = (RelativeOrder)rule;
                CustomizationReference referencedCusto = order.getRelativeCustomizationReference();
                if (order.getLocation() == Location.BEFORE) {
                    list2 = (ArrayList<CustomizationReference>)before.get(referencedCusto);
                    if (list2 == null) {
                        list2 = new ArrayList<CustomizationReference>();
                        before.put(referencedCusto, (ArrayList<CustomizationReference>)list2);
                    }
                    list2.add(custoRef);
                    continue;
                }
                list2 = (List)after.get(referencedCusto);
                if (list2 == null) {
                    list2 = new ArrayList();
                    after.put(referencedCusto, (ArrayList<CustomizationReference>)list2);
                }
                list2.add(custoRef);
            }
        }
        for (Map.Entry entry : before.entrySet()) {
            if (((List)entry.getValue()).size() == 1) continue;
            this.createErrorStatus((EObject)entry.getKey(), 7, NLS.bind((String)"{0} : the {1} relative location is used more than 1 time to insert a Customization before me.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName(), (Object)Location.BEFORE.getName()));
            for (CustomizationReference ref : (List)entry.getValue()) {
                this.createErrorStatus(ref, 8, NLS.bind((String)"I'm not alone to insert a Customization before {0}.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName()));
            }
        }
        for (Map.Entry entry : after.entrySet()) {
            if (((List)entry.getValue()).size() == 1) continue;
            this.createErrorStatus((EObject)entry.getKey(), 9, NLS.bind((String)"{0} : the {1} relative location is used more than 1 time to insert a Customization after me.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName(), (Object)Location.AFTER.getName()));
            for (CustomizationReference ref : (List)entry.getValue()) {
                this.createErrorStatus(ref, 10, NLS.bind((String)"I'm not alone to insert a Customization after {0}.", (Object)((CustomizationReference)entry.getKey()).getReferencedCustomization().getName()));
            }
        }
    }

    private void excludeAbsoluteOrder(List<List<CustomizationReference>> customizationReferenceByLevel) {
        Iterator<List<CustomizationReference>> iterOnList = customizationReferenceByLevel.iterator();
        while (iterOnList.hasNext()) {
            ListIterator<CustomizationReference> custoRefIter = iterOnList.next().listIterator();
            while (custoRefIter.hasNext()) {
                CustomizationReference custoRef = custoRefIter.next();
                if (!(custoRef.getApplicationRule() instanceof AbsoluteOrder)) continue;
                custoRefIter.remove();
            }
        }
    }

    private List<List<CustomizationReference>> organizeCustomizationReferences(List<List<EMFFacetTreeViewerConfiguration>> configurationToMergeByLevel) {
        ArrayList<List<CustomizationReference>> customizationReferenceByLevel = new ArrayList<List<CustomizationReference>>();
        for (List<EMFFacetTreeViewerConfiguration> current : configurationToMergeByLevel) {
            ArrayList<CustomizationReference> refs = new ArrayList<CustomizationReference>();
            for (EMFFacetTreeViewerConfiguration conf : current) {
                refs.addAll((Collection<CustomizationReference>)conf.getCustomizationReferences());
            }
            customizationReferenceByLevel.add(refs);
        }
        return customizationReferenceByLevel;
    }
}

