/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.JavaResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class StandaloneResourceSetFixture<T extends EObject>
extends TestWatcher {
    private final Class<? extends T> modelType;
    private ResourceSet resourceSet;
    private Resource resource;
    private T model;

    public StandaloneResourceSetFixture(Class<? extends T> modelType) {
        this.modelType = modelType;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        return this.getResourceSet().getResource(uri, loadOnDemand);
    }

    public T getModel() {
        return this.model;
    }

    public <E extends EObject> E getModel(Class<E> modelType) {
        EObject result = null;
        Iterator iter = this.resourceSet.getResources().iterator();
        while (result == null && iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            result = (EObject)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resource.getContents(), modelType), null);
        }
        return (E)result;
    }

    public static <T extends EObject> StandaloneResourceSetFixture<T> create(Class<T> modelType) {
        return new StandaloneResourceSetFixture<T>(modelType);
    }

    protected void starting(Description description) {
        JavaResource annotation = JUnitUtils.getAnnotation(description, JavaResource.class);
        MatcherAssert.assertThat((String)"No @JavaResource annotation found in test case.", (Object)annotation, (Matcher)CoreMatchers.notNullValue());
        this.resourceSet = new ResourceSetImpl();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            EcorePlugin.ExtensionProcessor.process(null);
        }
        Class<?> testClass = JUnitUtils.getTestClass(description);
        String[] stringArray = annotation.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            this.resourceSet.getResource(this.getTestResourceURI(next, testClass), true);
            ++n2;
        }
        this.model = this.getModel(this.modelType);
        MatcherAssert.assertThat((String)("No model of type " + this.modelType.getSimpleName() + " loaded."), this.model, (Matcher)CoreMatchers.notNullValue());
        this.resource = this.model.eResource();
    }

    protected void finished(Description description) {
        Iterator iter = this.resourceSet.getResources().iterator();
        while (iter.hasNext()) {
            Resource next = (Resource)iter.next();
            next.unload();
            iter.remove();
            next.eAdapters().clear();
        }
        this.resourceSet.eAdapters().clear();
        this.resourceSet = null;
        this.resource = null;
        this.model = null;
    }

    protected URI getTestResourceURI(String path, Class<?> context) {
        Path resourcePath = new Path(path);
        URL resultURL = resourcePath.isAbsolute() ? context.getClassLoader().getResource(path) : context.getResource(path);
        return URI.createURI((String)resultURL.toString(), (boolean)true);
    }
}

