/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.toolsmiths.factory.FileBasedExtensionFactory;
import org.eclipse.papyrus.toolsmiths.messages.Messages;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationPluginPackage;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.FileBasedCustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.ModelTemplate;
import org.w3c.dom.Element;

public class ModelTemplateExtensionFactory
extends FileBasedExtensionFactory {
    public static final String MODEL_TEMPLATE_ROOT_FOLDER = new String("modelTemplate");

    public ModelTemplateExtensionFactory() {
        super(Messages.ModelTemplateExtensionFactory_ModelTemplate, "org.eclipse.papyrus.uml.diagram.wizards.templates", "file", "template", true);
    }

    @Override
    public void addElement(CustomizableElement element, IPluginEditor editor) {
        super.addElement(element, editor);
        editor.addDependency("org.eclipse.papyrus.uml.diagram.wizards");
    }

    @Override
    protected Element createExtension(FileBasedCustomizableElement customizableElement, IPluginEditor editor) {
        Element extension = super.createExtension(customizableElement, editor);
        if (customizableElement instanceof ModelTemplate) {
            ModelTemplate element = (ModelTemplate)customizableElement;
            extension.setAttribute("id", element.getId());
            if (element.getName() != null) {
                extension.setAttribute("name", element.getName());
            }
            if (element.getLanguage() != null) {
                extension.setAttribute("language", element.getLanguage());
            }
            if (element.getLanguage() != null) {
                extension.setAttribute("di_file", this.getFilePath(element.getDi_file()));
            }
            if (element.getLanguage() != null) {
                extension.setAttribute("notation_file", this.getFilePath(element.getNotation_file()));
            }
        }
        return extension;
    }

    @Override
    protected String getTargetPath(FileBasedCustomizableElement element) {
        return this.getFilePath(element.getFile());
    }

    protected String getFilePath(String file) {
        return File.separator + MODEL_TEMPLATE_ROOT_FOLDER + File.separator + this.getFileName(file);
    }

    @Override
    public EClass getCustomizableElementClass() {
        return CustomizationPluginPackage.eINSTANCE.getModelTemplate();
    }

    @Override
    protected void copyFile(FileBasedCustomizableElement element, IPluginEditor editor) throws FileNotFoundException, IOException {
        this.copyFile(element.getFile(), this.getFilePath(((ModelTemplate)element).getFile()), editor);
        this.copyFile(((ModelTemplate)element).getDi_file(), this.getFilePath(((ModelTemplate)element).getDi_file()), editor);
        this.copyFile(((ModelTemplate)element).getNotation_file(), this.getFilePath(((ModelTemplate)element).getNotation_file()), editor);
    }
}

