/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.service;

import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;

class GenModelHelper {
    private static final GenModelHelper INSTANCE;

    static {
        GenModelHelper instance;
        try {
            instance = new Default();
        }
        catch (Exception | LinkageError e) {
            instance = new GenModelHelper();
        }
        INSTANCE = instance;
    }

    private GenModelHelper() {
    }

    public boolean hasGeneratorModel(Package package_, ResourceSet resourceSet) {
        EObject generatorModel = this.getGeneratorModel(package_, resourceSet);
        return generatorModel != null && this.isForeignModelOf(package_, generatorModel, resourceSet);
    }

    EObject getGeneratorModel(Package package_, ResourceSet resourceSet) {
        return null;
    }

    boolean isForeignModelOf(Package package_, EObject generatorModel, ResourceSet context) {
        return false;
    }

    public static GenModelHelper getInstance() {
        return INSTANCE;
    }

    private static final class Default
    extends GenModelHelper {
        private static final String UML_IMPORTER_ID = "org.eclipse.uml2.uml.ecore.importer";
        private static final String GENMODEL_EXTENSION = "genmodel";

        private Default() {
        }

        GenModel getGeneratorModel(Package package_, ResourceSet resourceSet) {
            URI genmodelURI = package_.eResource().getURI().trimFileExtension().appendFileExtension(GENMODEL_EXTENSION);
            return (GenModel)UML2Util.load((ResourceSet)resourceSet, (URI)genmodelURI, (EClass)GenModelPackage.Literals.GEN_MODEL);
        }

        @Override
        boolean isForeignModelOf(Package package_, EObject generatorModel, ResourceSet context) {
            boolean result = false;
            GenModel genmodel = (GenModel)generatorModel;
            if (UML_IMPORTER_ID.equals(genmodel.getImporterID())) {
                URIConverter converter = context.getURIConverter();
                URI genmodelURI = converter.normalize(EcoreUtil.getURI((EObject)genmodel).trimFragment());
                URI sourceURI = converter.normalize(EcoreUtil.getURI((EObject)package_).trimFragment());
                Iterator foreignModel = genmodel.getForeignModel().iterator();
                while (!result && foreignModel.hasNext()) {
                    URI foreignModelURI = URI.createURI((String)((String)foreignModel.next())).resolve(genmodelURI);
                    result = foreignModelURI.equals(sourceURI);
                }
            }
            return result;
        }
    }
}

