/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.commands.SashLayoutCommandFactory;
import org.eclipse.papyrus.infra.ui.services.SaveLayoutBeforeClose;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class TogglePageLayoutStorageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart active = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (active instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)active;
            this.togglePrivatePageLayout(editor);
            try {
                SaveLayoutBeforeClose save = (SaveLayoutBeforeClose)editor.getServicesRegistry().getService(SaveLayoutBeforeClose.class);
                save.saveBeforeClose(editor);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return null;
    }

    public void togglePrivatePageLayout(IMultiDiagramEditor editor) {
        Command command = new SashLayoutCommandFactory(editor).createTogglePrivateLayoutCommand();
        EditingDomain domain = (EditingDomain)editor.getAdapter(EditingDomain.class);
        try {
            TransactionHelper.run((EditingDomain)domain, () -> command.execute());
        }
        catch (RollbackException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        catch (InterruptedException e) {
            Activator.log.error("Failed to execute page layout toggle command", (Throwable)e);
        }
    }
}

